/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.RequiresTypeResolution;
import io.gitlab.arturbosch.detekt.rules.JunkKt;
import io.gitlab.arturbosch.detekt.rules.KtCallExpressionKt;
import io.gitlab.arturbosch.detekt.rules.style.UnnecessaryLetKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtSafeQualifiedExpression;

@RequiresTypeResolution
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/UnnecessaryLet;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitCallExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "report", "message", "", "Companion", "detekt-rules-style"})
public final class UnnecessaryLet
extends Rule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Issue issue;
    @NotNull
    private static final FqName letFqName = new FqName("kotlin.let");

    public UnnecessaryLet(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        String string2 = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue(string2, "getSimpleName(...)");
        this.issue = new Issue(string2, Severity.Style, "The `let` usage is unnecessary.", Debt.Companion.getFIVE_MINS());
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    @Override
    public void visitCallExpression(@NotNull KtCallExpression expression2) {
        int referenceCount;
        KtLambdaExpression lambdaExpr;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        super.visitCallExpression(expression2);
        if (!KtCallExpressionKt.isCalling(expression2, letFqName, this.getBindingContext())) {
            return;
        }
        List<KtLambdaArgument> list = expression2.getLambdaArguments();
        Intrinsics.checkNotNullExpressionValue(list, "getLambdaArguments(...)");
        KtLambdaArgument ktLambdaArgument = CollectionsKt.firstOrNull(list);
        KtLambdaExpression ktLambdaExpression = lambdaExpr = ktLambdaArgument != null ? ktLambdaArgument.getLambdaExpression() : null;
        int n = referenceCount = ktLambdaExpression != null ? UnnecessaryLetKt.access$countLambdaParameterReference(ktLambdaExpression, this.getBindingContext()) : 0;
        if (referenceCount > 1) {
            return;
        }
        if (expression2.getParent() instanceof KtSafeQualifiedExpression) {
            if (lambdaExpr != null) {
                if (referenceCount == 0 && !JunkKt.receiverIsUsed(expression2, this.getBindingContext())) {
                    this.report(expression2, "let expression can be replaced with a simple if");
                } else if (referenceCount == 1 && UnnecessaryLetKt.access$canBeReplacedWithCall(lambdaExpr)) {
                    this.report(expression2, "let expression can be omitted");
                }
            }
        } else if (referenceCount == 0 || UnnecessaryLetKt.access$canBeReplacedWithCall(lambdaExpr) || !UnnecessaryLetKt.access$inCallChains(expression2)) {
            this.report(expression2, "let expression can be omitted");
        }
    }

    private final void report(KtCallExpression expression2, String message) {
        this.report(new CodeSmell(this.getIssue(), Entity.Companion.from$default(Entity.Companion, expression2, 0, 2, null), message, null, null, 24, null));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/UnnecessaryLet$Companion;", "", "<init>", "()V", "letFqName", "Lorg/jetbrains/kotlin/name/FqName;", "detekt-rules-style"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

