/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.RequiresTypeResolution;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LazyParseableElement;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtElementUtilsKt;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@RequiresTypeResolution
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00182\u00020\u0001:\u0002\u0017\u0018B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u000e\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\rH\u0002J\u001a\u0010\u0010\u001a\u00020\u0011*\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J\u0014\u0010\u0010\u001a\u00020\u0011*\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0015H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0019"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/UnnecessaryFilter;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitCallExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "lambda", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "isCalling", "", "Lorg/jetbrains/kotlin/psi/KtExpression;", "fqNames", "", "Lorg/jetbrains/kotlin/name/FqName;", "fqName", "SecondCall", "Companion", "detekt-rules-style"})
@SourceDebugExtension(value={"SMAP\nUnnecessaryFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnnecessaryFilter.kt\nio/gitlab/arturbosch/detekt/rules/style/UnnecessaryFilter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,104:1\n1863#2,2:105\n774#2:107\n865#2,2:108\n*S KotlinDebug\n*F\n+ 1 UnnecessaryFilter.kt\nio/gitlab/arturbosch/detekt/rules/style/UnnecessaryFilter\n*L\n65#1:105,2\n80#1:107\n80#1:108,2\n*E\n"})
public final class UnnecessaryFilter
extends Rule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Issue issue;
    @NotNull
    private static final List<FqName> filterFqNames;
    @NotNull
    private static final List<SecondCall> secondCalls;

    public UnnecessaryFilter(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        this.issue = new Issue("UnnecessaryFilter", Severity.Style, "`filter()` with other collection operations may be simplified.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ UnnecessaryFilter(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    @Override
    public void visitCallExpression(@NotNull KtCallExpression expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        super.visitCallExpression(expression2);
        if (!this.isCalling((KtExpression)expression2, filterFqNames)) {
            return;
        }
        Object object = this.lambda(expression2);
        if (object == null || (object = ((LazyParseableElement)object).getText()) == null) {
            return;
        }
        Object lambdaArgumentText = object;
        KtExpression qualifiedOrCall = KtPsiUtilKt.getQualifiedExpressionForSelectorOrThis(expression2);
        KtExpression ktExpression = KtPsiUtilKt.getQualifiedExpressionForReceiver(qualifiedOrCall);
        if (ktExpression == null || (ktExpression = ktExpression.getSelectorExpression()) == null) {
            return;
        }
        KtExpression nextCall = ktExpression;
        Iterable $this$forEach$iv = secondCalls;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SecondCall it = (SecondCall)element$iv;
            boolean bl = false;
            if (!this.isCalling(nextCall, it.getFqName())) continue;
            String message = '\'' + expression2.getText() + "' can be replaced by '" + it.getCorrectOperator() + ' ' + (String)lambdaArgumentText + '\'';
            this.report(new CodeSmell(this.getIssue(), Entity.Companion.from$default(Entity.Companion, expression2, 0, 2, null), message, null, null, 24, null));
        }
    }

    private final KtLambdaExpression lambda(KtCallExpression $this$lambda) {
        KtValueArgument argument;
        KtElement ktElement;
        KtValueArgument ktValueArgument;
        List<KtLambdaArgument> list = $this$lambda.getLambdaArguments();
        Intrinsics.checkNotNullExpressionValue(list, "getLambdaArguments(...)");
        KtLambdaArgument ktLambdaArgument = CollectionsKt.singleOrNull(list);
        if (ktLambdaArgument != null) {
            ktValueArgument = ktLambdaArgument;
        } else {
            List<KtValueArgument> list2 = $this$lambda.getValueArguments();
            Intrinsics.checkNotNullExpressionValue(list2, "getValueArguments(...)");
            ktValueArgument = CollectionsKt.singleOrNull(list2);
        }
        return (ktElement = (argument = ktValueArgument)) != null && (ktElement = ktElement.getArgumentExpression()) != null ? KtElementUtilsKt.unpackFunctionLiteral$default((KtExpression)ktElement, false, 1, null) : null;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isCalling(KtExpression $this$isCalling, List<FqName> fqNames) {
        void $this$filterTo$iv$iv;
        Object object = $this$isCalling instanceof KtCallExpression ? (KtCallExpression)$this$isCalling : null;
        if (object == null || (object = ((KtCallExpression)object).getCalleeExpression()) == null || (object = object.getText()) == null) {
            object = $this$isCalling.getText();
        }
        Object calleeText = object;
        Iterable $this$filter$iv = fqNames;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FqName it = (FqName)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual(it.shortName().asString(), calleeText)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List targetFqNames = (List)destination$iv$iv;
        if (targetFqNames.isEmpty()) {
            return false;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall($this$isCalling, this.getBindingContext());
        return CollectionsKt.contains(targetFqNames, resolvedCall2 != null && (resolvedCall2 = resolvedCall2.getResultingDescriptor()) != null ? DescriptorUtilsKt.fqNameOrNull((DeclarationDescriptor)((Object)resolvedCall2)) : null);
    }

    private final boolean isCalling(KtExpression $this$isCalling, FqName fqName) {
        return this.isCalling($this$isCalling, CollectionsKt.listOf(fqName));
    }

    public UnnecessaryFilter() {
        this((Config)null, 1, (DefaultConstructorMarker)null);
    }

    static {
        Object[] objectArray = new FqName[]{new FqName("kotlin.collections.filter"), new FqName("kotlin.sequences.filter")};
        filterFqNames = CollectionsKt.listOf(objectArray);
        objectArray = new SecondCall[]{new SecondCall(new FqName("kotlin.collections.List.size"), "count"), new SecondCall(new FqName("kotlin.collections.List.isEmpty"), "any"), new SecondCall(new FqName("kotlin.collections.isNotEmpty"), "none"), new SecondCall(new FqName("kotlin.collections.count"), null, 2, null), new SecondCall(new FqName("kotlin.sequences.count"), null, 2, null)};
        secondCalls = CollectionsKt.listOf(objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/UnnecessaryFilter$Companion;", "", "<init>", "()V", "filterFqNames", "", "Lorg/jetbrains/kotlin/name/FqName;", "secondCalls", "Lio/gitlab/arturbosch/detekt/rules/style/UnnecessaryFilter$SecondCall;", "detekt-rules-style"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/UnnecessaryFilter$SecondCall;", "", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "correctOperator", "", "<init>", "(Lorg/jetbrains/kotlin/name/FqName;Ljava/lang/String;)V", "getFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "getCorrectOperator", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "detekt-rules-style"})
    private static final class SecondCall {
        @NotNull
        private final FqName fqName;
        @NotNull
        private final String correctOperator;

        public SecondCall(@NotNull FqName fqName, @NotNull String correctOperator) {
            Intrinsics.checkNotNullParameter(fqName, "fqName");
            Intrinsics.checkNotNullParameter(correctOperator, "correctOperator");
            this.fqName = fqName;
            this.correctOperator = correctOperator;
        }

        public /* synthetic */ SecondCall(FqName fqName, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                string2 = fqName.shortName().asString();
            }
            this(fqName, string2);
        }

        @NotNull
        public final FqName getFqName() {
            return this.fqName;
        }

        @NotNull
        public final String getCorrectOperator() {
            return this.correctOperator;
        }

        @NotNull
        public final FqName component1() {
            return this.fqName;
        }

        @NotNull
        public final String component2() {
            return this.correctOperator;
        }

        @NotNull
        public final SecondCall copy(@NotNull FqName fqName, @NotNull String correctOperator) {
            Intrinsics.checkNotNullParameter(fqName, "fqName");
            Intrinsics.checkNotNullParameter(correctOperator, "correctOperator");
            return new SecondCall(fqName, correctOperator);
        }

        public static /* synthetic */ SecondCall copy$default(SecondCall secondCall, FqName fqName, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                fqName = secondCall.fqName;
            }
            if ((n & 2) != 0) {
                string2 = secondCall.correctOperator;
            }
            return secondCall.copy(fqName, string2);
        }

        @NotNull
        public String toString() {
            return "SecondCall(fqName=" + this.fqName + ", correctOperator=" + this.correctOperator + ')';
        }

        public int hashCode() {
            int result2 = this.fqName.hashCode();
            result2 = result2 * 31 + this.correctOperator.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SecondCall)) {
                return false;
            }
            SecondCall secondCall = (SecondCall)other;
            if (!Intrinsics.areEqual(this.fqName, secondCall.fqName)) {
                return false;
            }
            return Intrinsics.areEqual(this.correctOperator, secondCall.correctOperator);
        }
    }
}

