/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Location;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.TextLocation;
import java.util.List;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtAnnotationUseSiteTarget;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001cB\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001e\u0010\u0011\u001a\u00020\u000b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001d"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/UnnecessaryAnnotationUseSiteTarget;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitPrimaryConstructor", "", "constructor", "Lorg/jetbrains/kotlin/psi/KtPrimaryConstructor;", "visitProperty", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "checkForUnnecessaryUseSiteTarget", "annotations", "", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "useSiteTarget", "Lio/gitlab/arturbosch/detekt/rules/style/UnnecessaryAnnotationUseSiteTarget$UseSiteTarget;", "report", "useSite", "Lorg/jetbrains/kotlin/psi/KtAnnotationUseSiteTarget;", "message", "", "UseSiteTarget", "detekt-rules-style"})
@SourceDebugExtension(value={"SMAP\nUnnecessaryAnnotationUseSiteTarget.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnnecessaryAnnotationUseSiteTarget.kt\nio/gitlab/arturbosch/detekt/rules/style/UnnecessaryAnnotationUseSiteTarget\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,79:1\n1863#2,2:80\n1863#2,2:82\n*S KotlinDebug\n*F\n+ 1 UnnecessaryAnnotationUseSiteTarget.kt\nio/gitlab/arturbosch/detekt/rules/style/UnnecessaryAnnotationUseSiteTarget\n*L\n41#1:80,2\n53#1:82,2\n*E\n"})
public final class UnnecessaryAnnotationUseSiteTarget
extends Rule {
    @NotNull
    private final Issue issue;

    public UnnecessaryAnnotationUseSiteTarget(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        String string2 = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue(string2, "getSimpleName(...)");
        this.issue = new Issue(string2, Severity.Style, "Unnecessary Annotation use-site Target. It can be removed.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ UnnecessaryAnnotationUseSiteTarget(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    @Override
    public void visitPrimaryConstructor(@NotNull KtPrimaryConstructor constructor) {
        Intrinsics.checkNotNullParameter(constructor, "constructor");
        Iterable $this$forEach$iv = constructor.getValueParameters();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtParameter parameter = (KtParameter)element$iv;
            boolean bl = false;
            List<KtAnnotationEntry> list = parameter.getAnnotationEntries();
            Intrinsics.checkNotNullExpressionValue(list, "getAnnotationEntries(...)");
            this.checkForUnnecessaryUseSiteTarget(list, UseSiteTarget.PARAM);
        }
        super.visitPrimaryConstructor(constructor);
    }

    @Override
    public void visitProperty(@NotNull KtProperty property) {
        Intrinsics.checkNotNullParameter(property, "property");
        List<KtAnnotationEntry> list = property.getAnnotationEntries();
        Intrinsics.checkNotNullExpressionValue(list, "getAnnotationEntries(...)");
        this.checkForUnnecessaryUseSiteTarget(list, UseSiteTarget.PROPERTY);
        super.visitProperty(property);
    }

    private final void checkForUnnecessaryUseSiteTarget(List<? extends KtAnnotationEntry> annotations2, UseSiteTarget useSiteTarget) {
        Iterable $this$forEach$iv = annotations2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtAnnotationEntry annotationEntry = (KtAnnotationEntry)element$iv;
            boolean bl = false;
            KtAnnotationUseSiteTarget useSite = annotationEntry.getUseSiteTarget();
            if (useSite == null || !Intrinsics.areEqual(useSite.getText(), useSiteTarget.getUseSiteTarget())) continue;
            this.report(useSite, useSiteTarget.getMessage());
        }
    }

    private final void report(KtAnnotationUseSiteTarget useSite, String message) {
        Location location = Location.Companion.from$default(Location.Companion, useSite, 0, 2, null);
        boolean bl = false;
        Location location2 = Location.copy$default(location, null, TextLocation.copy$default(location.getText(), 0, location.getText().getEnd() + 1, 1, null), null, null, 13, null);
        this.report(new CodeSmell(this.getIssue(), Entity.Companion.from((PsiElement)useSite, location2), message, null, null, 24, null));
    }

    public UnnecessaryAnnotationUseSiteTarget() {
        this((Config)null, 1, (DefaultConstructorMarker)null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/UnnecessaryAnnotationUseSiteTarget$UseSiteTarget;", "", "useSiteTarget", "", "message", "<init>", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;)V", "getUseSiteTarget", "()Ljava/lang/String;", "getMessage", "PARAM", "PROPERTY", "detekt-rules-style"})
    private static final class UseSiteTarget
    extends Enum<UseSiteTarget> {
        @NotNull
        private final String useSiteTarget;
        @NotNull
        private final String message;
        public static final /* enum */ UseSiteTarget PARAM = new UseSiteTarget("param", "An annotation over a parameter doesn't need the use-site target @param.");
        public static final /* enum */ UseSiteTarget PROPERTY = new UseSiteTarget("property", "An annotation over a property, that it's not a parameter, doesn't need the use-site target @property.");
        private static final /* synthetic */ UseSiteTarget[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private UseSiteTarget(String useSiteTarget, String message) {
            this.useSiteTarget = useSiteTarget;
            this.message = message;
        }

        @NotNull
        public final String getUseSiteTarget() {
            return this.useSiteTarget;
        }

        @NotNull
        public final String getMessage() {
            return this.message;
        }

        public static UseSiteTarget[] values() {
            return (UseSiteTarget[])$VALUES.clone();
        }

        public static UseSiteTarget valueOf(String value2) {
            return Enum.valueOf(UseSiteTarget.class, value2);
        }

        @NotNull
        public static EnumEntries<UseSiteTarget> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = useSiteTargetArray = new UseSiteTarget[]{UseSiteTarget.PARAM, UseSiteTarget.PROPERTY};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

