/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 02\u00020\u0001:\u00010B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\u0018\u0010\"\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020$2\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010%\u001a\u00020\u00172\u0006\u0010&\u001a\u00020$H\u0002J\f\u0010'\u001a\u00020\u0017*\u00020!H\u0002J\u0010\u0010(\u001a\u00020\u00172\u0006\u0010)\u001a\u00020*H\u0002J\u0010\u0010+\u001a\u00020$2\u0006\u0010,\u001a\u00020$H\u0002J\u0018\u0010-\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010.\u001a\u00020$H\u0002J\f\u0010/\u001a\u00020\u0017*\u00020$H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR!\u0010\n\u001a\u00020\u000b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\u0011\u0012\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000fR!\u0010\u0012\u001a\u00020\u000b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0015\u0010\u0011\u0012\u0004\b\u0013\u0010\r\u001a\u0004\b\u0014\u0010\u000fR!\u0010\u0016\u001a\u00020\u00178BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u001b\u0010\u0011\u0012\u0004\b\u0018\u0010\r\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/UnderscoresInNumericLiterals;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "acceptableDecimalLength", "", "getAcceptableDecimalLength$annotations", "()V", "getAcceptableDecimalLength", "()I", "acceptableDecimalLength$delegate", "Lkotlin/properties/ReadOnlyProperty;", "acceptableLength", "getAcceptableLength$annotations", "getAcceptableLength", "acceptableLength$delegate", "allowNonStandardGrouping", "", "getAllowNonStandardGrouping$annotations", "getAllowNonStandardGrouping", "()Z", "allowNonStandardGrouping$delegate", "nonCompliantRegex", "Lkotlin/text/Regex;", "visitConstantExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtConstantExpression;", "checkNormalized", "normalizedText", "", "isNotDecimalNumber", "rawText", "isSerialUidProperty", "isSerializable", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "normalizeForMatching", "text", "doReport", "message", "hasNonStandardGrouping", "Companion", "detekt-rules-style"})
@SourceDebugExtension(value={"SMAP\nUnderscoresInNumericLiterals.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnderscoresInNumericLiterals.kt\nio/gitlab/arturbosch/detekt/rules/style/UnderscoresInNumericLiterals\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,128:1\n1755#2,3:129\n*S KotlinDebug\n*F\n+ 1 UnderscoresInNumericLiterals.kt\nio/gitlab/arturbosch/detekt/rules/style/UnderscoresInNumericLiterals\n*L\n103#1:129,3\n*E\n"})
public final class UnderscoresInNumericLiterals
extends Rule {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty acceptableDecimalLength$delegate;
    @NotNull
    private final ReadOnlyProperty acceptableLength$delegate;
    @NotNull
    private final ReadOnlyProperty allowNonStandardGrouping$delegate;
    @NotNull
    private final Regex nonCompliantRegex;
    @NotNull
    private static final Regex HAS_ONLY_STANDARD_GROUPING;
    @NotNull
    private static final String HEX_PREFIX = "0x";
    @NotNull
    private static final String BIN_PREFIX = "0b";
    @NotNull
    private static final String SERIALIZABLE = "Serializable";
    @NotNull
    private static final String SERIAL_UID_PROPERTY_NAME = "serialVersionUID";

    public UnderscoresInNumericLiterals(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        String string2 = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue(string2, "getSimpleName(...)");
        this.issue = new Issue(string2, Severity.Style, "Report missing or invalid underscores in base 10 numbers. Numeric literals should be underscore separated to increase readability.", Debt.Companion.getFIVE_MINS());
        this.acceptableDecimalLength$delegate = ConfigPropertyKt.config(5, UnderscoresInNumericLiterals::acceptableDecimalLength_delegate$lambda$0);
        this.acceptableLength$delegate = ConfigPropertyKt.configWithFallback(new PropertyReference0Impl(this){

            public Object get() {
                return UnderscoresInNumericLiterals.access$getAcceptableDecimalLength((UnderscoresInNumericLiterals)this.receiver);
            }
        }, 4);
        this.allowNonStandardGrouping$delegate = ConfigPropertyKt.config(false);
        this.nonCompliantRegex = new Regex("\\d{" + (this.getAcceptableLength() + 1) + ",}");
    }

    public /* synthetic */ UnderscoresInNumericLiterals(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final int getAcceptableDecimalLength() {
        return ((Number)this.acceptableDecimalLength$delegate.getValue(this, $$delegatedProperties[0])).intValue();
    }

    @Configuration(description="Length under which base 10 numbers are not required to have underscores")
    @Deprecated(message="Use `acceptableLength` instead")
    private static /* synthetic */ void getAcceptableDecimalLength$annotations() {
    }

    private final int getAcceptableLength() {
        return ((Number)this.acceptableLength$delegate.getValue(this, $$delegatedProperties[1])).intValue();
    }

    @Configuration(description="Maximum number of consecutive digits that a numeric literal can have without using an underscore")
    private static /* synthetic */ void getAcceptableLength$annotations() {
    }

    private final boolean getAllowNonStandardGrouping() {
        return (Boolean)this.allowNonStandardGrouping$delegate.getValue(this, $$delegatedProperties[2]);
    }

    @Configuration(description="If set to false, groups of exactly three digits must be used. If set to true, 100_00 is allowed.")
    private static /* synthetic */ void getAllowNonStandardGrouping$annotations() {
    }

    @Override
    public void visitConstantExpression(@NotNull KtConstantExpression expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        String string2 = expression2.getText();
        Intrinsics.checkNotNullExpressionValue(string2, "getText(...)");
        String normalizedText = this.normalizeForMatching(string2);
        this.checkNormalized(normalizedText, expression2);
    }

    private final void checkNormalized(String normalizedText, KtConstantExpression expression2) {
        if (this.isNotDecimalNumber(normalizedText)) {
            return;
        }
        if (this.isSerialUidProperty(expression2)) {
            return;
        }
        Object object = new char[]{'.'};
        String numberString = (String)CollectionsKt.first(StringsKt.split$default((CharSequence)normalizedText, object, false, 0, 6, null));
        if (!this.getAllowNonStandardGrouping() && this.hasNonStandardGrouping(numberString)) {
            this.doReport(expression2, "The number contains a non standard grouping.");
            return;
        }
        object = numberString;
        if (this.nonCompliantRegex.containsMatchIn((CharSequence)object)) {
            this.doReport(expression2, "This number should be separated by underscores in order to increase readability.");
            return;
        }
    }

    private final boolean isNotDecimalNumber(String rawText) {
        return StringsKt.toDoubleOrNull(StringsKt.replace$default(rawText, "_", "", false, 4, null)) == null || StringsKt.startsWith$default(rawText, HEX_PREFIX, false, 2, null) || StringsKt.startsWith$default(rawText, BIN_PREFIX, false, 2, null);
    }

    private final boolean isSerialUidProperty(KtConstantExpression $this$isSerialUidProperty) {
        PsiElement psiElement;
        if ($this$isSerialUidProperty.getParent() instanceof KtPrefixExpression) {
            PsiElement psiElement2 = $this$isSerialUidProperty.getParent();
            psiElement = psiElement2 != null ? psiElement2.getParent() : null;
        } else {
            psiElement = $this$isSerialUidProperty.getParent();
        }
        PsiElement propertyElement = psiElement;
        KtProperty property = propertyElement instanceof KtProperty ? (KtProperty)propertyElement : null;
        return property != null && Intrinsics.areEqual(property.getName(), SERIAL_UID_PROPERTY_NAME) && this.isSerializable(property);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isSerializable(KtProperty property) {
        boolean bl;
        List<KtSuperTypeListEntry> list;
        KtClassOrObject ktClassOrObject;
        KtClassOrObject containingClassOrObject = KtPsiUtilKt.getContainingClassOrObject(property);
        if (containingClassOrObject instanceof KtObjectDeclaration && ((KtObjectDeclaration)containingClassOrObject).isCompanion()) {
            containingClassOrObject = KtPsiUtilKt.getContainingClassOrObject(containingClassOrObject);
        }
        if ((ktClassOrObject = containingClassOrObject) != null && (list = ktClassOrObject.getSuperTypeListEntries()) != null) {
            boolean bl2;
            block6: {
                void $this$any$iv;
                Iterable iterable = list;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        KtSuperTypeListEntry it = (KtSuperTypeListEntry)element$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual(it.getText(), SERIALIZABLE)) continue;
                        bl2 = true;
                        break block6;
                    }
                    bl2 = false;
                }
            }
            bl = bl2;
        } else {
            bl = false;
        }
        return bl;
    }

    private final String normalizeForMatching(String text) {
        String string2 = ((Object)StringsKt.trim((CharSequence)text)).toString();
        Locale locale = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue(locale, "ROOT");
        String string3 = string2.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue(string3, "toLowerCase(...)");
        return StringsKt.removeSuffix(StringsKt.removeSuffix(StringsKt.removeSuffix(string3, (CharSequence)"l"), (CharSequence)"d"), (CharSequence)"f");
    }

    private final void doReport(KtConstantExpression expression2, String message) {
        this.report(new CodeSmell(this.getIssue(), Entity.Companion.from$default(Entity.Companion, expression2, 0, 2, null), message, null, null, 24, null));
    }

    private final boolean hasNonStandardGrouping(String $this$hasNonStandardGrouping) {
        CharSequence charSequence;
        return StringsKt.contains$default((CharSequence)$this$hasNonStandardGrouping, '_', false, 2, null) && !HAS_ONLY_STANDARD_GROUPING.matches(charSequence = (CharSequence)$this$hasNonStandardGrouping);
    }

    private static final int acceptableDecimalLength_delegate$lambda$0(int it) {
        return it - 1;
    }

    public UnderscoresInNumericLiterals() {
        this((Config)null, 1, (DefaultConstructorMarker)null);
    }

    public static final /* synthetic */ int access$getAcceptableDecimalLength(UnderscoresInNumericLiterals $this) {
        return $this.getAcceptableDecimalLength();
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(UnderscoresInNumericLiterals.class, "acceptableDecimalLength", "getAcceptableDecimalLength()I", 0)), Reflection.property1(new PropertyReference1Impl(UnderscoresInNumericLiterals.class, "acceptableLength", "getAcceptableLength()I", 0)), Reflection.property1(new PropertyReference1Impl(UnderscoresInNumericLiterals.class, "allowNonStandardGrouping", "getAllowNonStandardGrouping()Z", 0))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
        HAS_ONLY_STANDARD_GROUPING = new Regex("\\d{1,3}(?:_\\d{3})*");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/UnderscoresInNumericLiterals$Companion;", "", "<init>", "()V", "HAS_ONLY_STANDARD_GROUPING", "Lkotlin/text/Regex;", "HEX_PREFIX", "", "BIN_PREFIX", "SERIALIZABLE", "SERIAL_UID_PROPERTY_NAME", "detekt-rules-style"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

