/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\b\u001a\u00020\tJ\u0011\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0000H\u0096\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/Section;", "", "priority", "", "<init>", "(I)V", "getPriority", "()I", "toDescription", "", "compareTo", "other", "detekt-rules-style"})
final class Section
implements Comparable<Section> {
    private final int priority;

    public Section(int priority) {
        this.priority = priority;
        int n = this.priority;
        if (!(0 <= n ? n < 4 : false)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
    }

    public final int getPriority() {
        return this.priority;
    }

    @NotNull
    public final String toDescription() {
        String string2;
        switch (this.priority) {
            case 0: {
                string2 = "property declarations and initializer blocks";
                break;
            }
            case 1: {
                string2 = "secondary constructors";
                break;
            }
            case 2: {
                string2 = "method declarations";
                break;
            }
            case 3: {
                string2 = "companion object";
                break;
            }
            default: {
                string2 = "";
            }
        }
        return string2;
    }

    @Override
    public int compareTo(@NotNull Section other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return Intrinsics.compare(this.priority, other.priority);
    }
}

