/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtIsExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J$\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0016\u0010\u0015\u001a\u00020\u000f*\u0004\u0018\u00010\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u000e\u0010\u0016\u001a\u00020\u000f*\u0004\u0018\u00010\u0011H\u0002J\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0011*\u0004\u0018\u00010\u0011H\u0002J\u0010\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0019"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/SafeCast;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitIfExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "isIfElseNull", "", "thenClause", "Lorg/jetbrains/kotlin/psi/KtExpression;", "elseClause", "identifier", "", "isIdentifier", "isNullConstant", "singleExpression", "addReport", "detekt-rules-style"})
@SourceDebugExtension(value={"SMAP\nSafeCast.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SafeCast.kt\nio/gitlab/arturbosch/detekt/rules/style/SafeCast\n+ 2 Junk.kt\nio/gitlab/arturbosch/detekt/rules/JunkKt\n*L\n1#1,83:1\n40#2:84\n*S KotlinDebug\n*F\n+ 1 SafeCast.kt\nio/gitlab/arturbosch/detekt/rules/style/SafeCast\n*L\n77#1:84\n*E\n"})
public final class SafeCast
extends Rule {
    @NotNull
    private final Issue issue;

    public SafeCast(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        String string2 = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue(string2, "getSimpleName(...)");
        this.issue = new Issue(string2, Severity.Style, "Prefer to use a safe cast instead of if-else-null.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ SafeCast(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    @Override
    public void visitIfExpression(@NotNull KtIfExpression expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        KtExpression condition = expression2.getCondition();
        if (condition instanceof KtIsExpression) {
            KtExpression ktExpression = ((KtIsExpression)condition).getLeftHandSide();
            Intrinsics.checkNotNullExpressionValue(ktExpression, "getLeftHandSide(...)");
            KtExpression leftHandSide = ktExpression;
            if (leftHandSide instanceof KtNameReferenceExpression) {
                boolean bl;
                String identifier = ((KtNameReferenceExpression)leftHandSide).getText();
                KtExpression thenClause = expression2.getThen();
                KtExpression elseClause = expression2.getElse();
                boolean bl2 = ((KtIsExpression)condition).isNegated();
                if (bl2) {
                    Intrinsics.checkNotNull(identifier);
                    bl = this.isIfElseNull(elseClause, thenClause, identifier);
                } else if (!bl2) {
                    Intrinsics.checkNotNull(identifier);
                    bl = this.isIfElseNull(thenClause, elseClause, identifier);
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                boolean result2 = bl;
                if (result2) {
                    this.addReport(expression2);
                }
            }
        }
    }

    private final boolean isIfElseNull(KtExpression thenClause, KtExpression elseClause, String identifier) {
        return this.isIdentifier(thenClause, identifier) && this.isNullConstant(elseClause);
    }

    private final boolean isIdentifier(KtExpression $this$isIdentifier, String identifier) {
        KtExpression ktExpression = this.singleExpression($this$isIdentifier);
        return Intrinsics.areEqual(ktExpression != null ? ktExpression.getText() : null, identifier);
    }

    private final boolean isNullConstant(KtExpression $this$isNullConstant) {
        KtExpression ktExpression = this.singleExpression($this$isNullConstant);
        if (ktExpression == null) {
            return false;
        }
        KtExpression singleExpression = ktExpression;
        return singleExpression instanceof KtConstantExpression && Intrinsics.areEqual(((KtConstantExpression)singleExpression).getNode().getElementType(), KtNodeTypes.NULL);
    }

    private final KtExpression singleExpression(KtExpression $this$singleExpression) {
        KtExpression ktExpression;
        if ($this$singleExpression instanceof KtBlockExpression) {
            PsiElement[] psiElementArray = ((KtBlockExpression)$this$singleExpression).getChildren();
            Intrinsics.checkNotNullExpressionValue(psiElementArray, "getChildren(...)");
            PsiElement psiElement = (PsiElement)ArraysKt.singleOrNull((Object[])psiElementArray);
            if (psiElement != null) {
                PsiElement $this$safeAs$iv = psiElement;
                boolean $i$f$safeAs = false;
                PsiElement psiElement2 = $this$safeAs$iv;
                if (!(psiElement2 instanceof KtExpression)) {
                    psiElement2 = null;
                }
                ktExpression = (KtExpression)psiElement2;
            } else {
                ktExpression = null;
            }
        } else {
            ktExpression = $this$singleExpression;
        }
        return ktExpression;
    }

    private final void addReport(KtIfExpression expression2) {
        this.report(new CodeSmell(this.getIssue(), Entity.Companion.from$default(Entity.Companion, expression2, 0, 2, null), "This cast should be replaced with a safe cast: as?", null, null, 24, null));
    }

    public SafeCast() {
        this((Config)null, 1, (DefaultConstructorMarker)null);
    }
}

