/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.SplitPatternKt;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.rules.GuardClausesKt;
import io.gitlab.arturbosch.detekt.rules.style.ReturnCount$countReturnStatements$;
import io.gitlab.arturbosch.detekt.rules.style.ReturnCount$countReturnStatements$lambda$1$;
import io.gitlab.arturbosch.detekt.rules.style.ReturnCountKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiRecursiveElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0016J\u0010\u0010+\u001a\u00020\u001a2\u0006\u0010)\u001a\u00020*H\u0002J\u0010\u0010,\u001a\u00020\u000b2\u0006\u0010)\u001a\u00020*H\u0002J\f\u0010-\u001a\u00020\u001a*\u00020.H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR!\u0010\n\u001a\u00020\u000b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\u0011\u0012\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000fR'\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00138BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0018\u0010\u0011\u0012\u0004\b\u0015\u0010\r\u001a\u0004\b\u0016\u0010\u0017R!\u0010\u0019\u001a\u00020\u001a8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u001e\u0010\u0011\u0012\u0004\b\u001b\u0010\r\u001a\u0004\b\u001c\u0010\u001dR!\u0010\u001f\u001a\u00020\u001a8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\"\u0010\u0011\u0012\u0004\b \u0010\r\u001a\u0004\b!\u0010\u001dR!\u0010#\u001a\u00020\u001a8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b&\u0010\u0011\u0012\u0004\b$\u0010\r\u001a\u0004\b%\u0010\u001d\u00a8\u0006/"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/ReturnCount;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "max", "", "getMax$annotations", "()V", "getMax", "()I", "max$delegate", "Lkotlin/properties/ReadOnlyProperty;", "excludedFunctions", "", "Lkotlin/text/Regex;", "getExcludedFunctions$annotations", "getExcludedFunctions", "()Ljava/util/List;", "excludedFunctions$delegate", "excludeLabeled", "", "getExcludeLabeled$annotations", "getExcludeLabeled", "()Z", "excludeLabeled$delegate", "excludeReturnFromLambda", "getExcludeReturnFromLambda$annotations", "getExcludeReturnFromLambda", "excludeReturnFromLambda$delegate", "excludeGuardClauses", "getExcludeGuardClauses$annotations", "getExcludeGuardClauses", "excludeGuardClauses$delegate", "visitNamedFunction", "", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "shouldBeIgnored", "countReturnStatements", "isNamedReturnFromLambda", "Lorg/jetbrains/kotlin/psi/KtReturnExpression;", "detekt-rules-style"})
@SourceDebugExtension(value={"SMAP\nReturnCount.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReturnCount.kt\nio/gitlab/arturbosch/detekt/rules/style/ReturnCount\n+ 2 GuardClauses.kt\nio/gitlab/arturbosch/detekt/rules/GuardClausesKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 5 Traversing.kt\nio/gitlab/arturbosch/detekt/rules/TraversingKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,122:1\n15#2,11:123\n1272#3,2:134\n1274#3:137\n125#4:136\n309#4,15:152\n229#4,2:167\n241#4:169\n328#4:170\n12#5,10:138\n1557#6:148\n1628#6,3:149\n*S KotlinDebug\n*F\n+ 1 ReturnCount.kt\nio/gitlab/arturbosch/detekt/rules/style/ReturnCount\n*L\n100#1:123,11\n107#1:134,2\n107#1:137\n107#1:136\n105#1:152,15\n105#1:167,2\n105#1:169\n105#1:170\n113#1:138,10\n62#1:148\n62#1:149,3\n*E\n"})
public final class ReturnCount
extends Rule {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty max$delegate;
    @NotNull
    private final ReadOnlyProperty excludedFunctions$delegate;
    @NotNull
    private final ReadOnlyProperty excludeLabeled$delegate;
    @NotNull
    private final ReadOnlyProperty excludeReturnFromLambda$delegate;
    @NotNull
    private final ReadOnlyProperty excludeGuardClauses$delegate;

    public ReturnCount(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        String string2 = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue(string2, "getSimpleName(...)");
        this.issue = new Issue(string2, Severity.Style, "Restrict the number of return statements in methods.", Debt.Companion.getTEN_MINS());
        this.max$delegate = ConfigPropertyKt.config(2);
        this.excludedFunctions$delegate = ConfigPropertyKt.config(CollectionsKt.listOf("equals"), ReturnCount::excludedFunctions_delegate$lambda$0);
        this.excludeLabeled$delegate = ConfigPropertyKt.config(false);
        this.excludeReturnFromLambda$delegate = ConfigPropertyKt.config(true);
        this.excludeGuardClauses$delegate = ConfigPropertyKt.config(false);
    }

    public /* synthetic */ ReturnCount(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final int getMax() {
        return ((Number)this.max$delegate.getValue(this, $$delegatedProperties[0])).intValue();
    }

    @Configuration(description="define the maximum number of return statements allowed per function")
    private static /* synthetic */ void getMax$annotations() {
    }

    private final List<Regex> getExcludedFunctions() {
        return (List)this.excludedFunctions$delegate.getValue(this, $$delegatedProperties[1]);
    }

    @Configuration(description="define a list of function names to be ignored by this check")
    private static /* synthetic */ void getExcludedFunctions$annotations() {
    }

    private final boolean getExcludeLabeled() {
        return (Boolean)this.excludeLabeled$delegate.getValue(this, $$delegatedProperties[2]);
    }

    @Configuration(description="if labeled return statements should be ignored")
    private static /* synthetic */ void getExcludeLabeled$annotations() {
    }

    private final boolean getExcludeReturnFromLambda() {
        return (Boolean)this.excludeReturnFromLambda$delegate.getValue(this, $$delegatedProperties[3]);
    }

    @Configuration(description="if labeled return from a lambda should be ignored")
    private static /* synthetic */ void getExcludeReturnFromLambda$annotations() {
    }

    private final boolean getExcludeGuardClauses() {
        return (Boolean)this.excludeGuardClauses$delegate.getValue(this, $$delegatedProperties[4]);
    }

    @Configuration(description="if true guard clauses at the beginning of a method should be ignored")
    private static /* synthetic */ void getExcludeGuardClauses$annotations() {
    }

    @Override
    public void visitNamedFunction(@NotNull KtNamedFunction function2) {
        int numberOfReturns;
        Intrinsics.checkNotNullParameter(function2, "function");
        super.visitNamedFunction(function2);
        if (!this.shouldBeIgnored(function2) && (numberOfReturns = this.countReturnStatements(function2)) > this.getMax()) {
            this.report(new CodeSmell(this.getIssue(), Entity.Companion.atName(function2), "Function " + function2.getName() + " has " + numberOfReturns + " return statements which exceeds the limit of " + this.getMax() + '.', null, null, 24, null));
        }
    }

    private final boolean shouldBeIgnored(KtNamedFunction function2) {
        return ReturnCountKt.access$contains(this.getExcludedFunctions(), function2.getName());
    }

    /*
     * WARNING - void declaration
     */
    private final int countReturnStatements(KtNamedFunction function2) {
        Sequence sequence2;
        if (this.getExcludeGuardClauses()) {
            KtNamedFunction $this$yieldStatementsSkippingGuardClauses$iv = function2;
            boolean $i$f$yieldStatementsSkippingGuardClauses = false;
            sequence2 = SequencesKt.sequence((Function2)new Function2<SequenceScope<? super KtExpression>, Continuation<? super Unit>, Object>($this$yieldStatementsSkippingGuardClauses$iv, null){
                Object L$1;
                Object L$2;
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ KtNamedFunction $this_yieldStatementsSkippingGuardClauses;
                {
                    this.$this_yieldStatementsSkippingGuardClauses = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled aggressive block sorting
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object object) {
                    Object object2;
                    Object object3;
                    boolean bl;
                    Iterator<T> iterator2;
                    Ref.BooleanRef firstNonGuardFound;
                    SequenceScope $this$sequence;
                    Object object4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure(object);
                            $this$sequence = (SequenceScope)this.L$0;
                            firstNonGuardFound = new Ref.BooleanRef();
                            KtBlockExpression ktBlockExpression = this.$this_yieldStatementsSkippingGuardClauses.getBodyBlockExpression();
                            Object object5 = ktBlockExpression;
                            if (ktBlockExpression == null) return Unit.INSTANCE;
                            List<KtExpression> list = ((KtBlockExpression)object5).getStatements();
                            object5 = list;
                            if (list == null) return Unit.INSTANCE;
                            Iterable $this$forEach$iv = (Iterable)object5;
                            boolean $i$f$forEach = false;
                            iterator2 = $this$forEach$iv.iterator();
                            break;
                        }
                        case 1: {
                            void $result;
                            boolean $i$f$forEach = false;
                            bl = false;
                            iterator2 = (Iterator<T>)this.L$2;
                            firstNonGuardFound = (Ref.BooleanRef)this.L$1;
                            $this$sequence = (SequenceScope)this.L$0;
                            ResultKt.throwOnFailure($result);
                            object3 = $result;
                            break;
                        }
                        case 2: {
                            void $result;
                            boolean $i$f$forEach = false;
                            bl = false;
                            iterator2 = (Iterator)this.L$2;
                            firstNonGuardFound = (Ref.BooleanRef)this.L$1;
                            $this$sequence = (SequenceScope)this.L$0;
                            ResultKt.throwOnFailure($result);
                            object2 = $result;
                            break;
                        }
                        default: {
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }
                    }
                    while (iterator2.hasNext()) {
                        KtExpression descendantExpr$iv;
                        T element$iv = iterator2.next();
                        KtExpression it = (KtExpression)element$iv;
                        bl = false;
                        if (firstNonGuardFound.element) {
                            Intrinsics.checkNotNull(it);
                            this.L$0 = $this$sequence;
                            this.L$1 = firstNonGuardFound;
                            this.L$2 = iterator2;
                            this.label = 1;
                            object3 = $this$sequence.yield(it, this);
                            if (object3 != object4) continue;
                            return object4;
                        }
                        Intrinsics.checkNotNull(it);
                        KtExpression $this$isGuardClause$iv = it;
                        boolean $i$f$isGuardClause = false;
                        PsiElement $this$findDescendantOfType_u24default$iv$iv = $this$isGuardClause$iv;
                        Function1 predicate$iv$iv = countReturnStatements$$inlined$yieldStatementsSkippingGuardClauses$1$1.INSTANCE;
                        boolean $i$f$findDescendantOfType = false;
                        PsiElement $this$findDescendantOfType$iv$iv$iv = $this$findDescendantOfType_u24default$iv$iv;
                        boolean $i$f$findDescendantOfType2 = false;
                        PsiUtilsKt.checkDecompiledText($this$findDescendantOfType$iv$iv$iv);
                        Ref.ObjectRef<T> result$iv$iv$iv = new Ref.ObjectRef<T>();
                        $this$findDescendantOfType$iv$iv$iv.accept(new PsiRecursiveElementWalkingVisitor(predicate$iv$iv, result$iv$iv$iv){
                            final /* synthetic */ Function1 $predicate;
                            final /* synthetic */ Ref.ObjectRef $result;
                            {
                                this.$predicate = $predicate;
                                this.$result = $result;
                            }

                            public void visitElement(PsiElement element) {
                                Intrinsics.checkNotNullParameter(element, "element");
                                if (element instanceof KtReturnExpression && ((Boolean)this.$predicate.invoke(element)).booleanValue()) {
                                    this.$result.element = element;
                                    this.stopWalking();
                                    return;
                                }
                                PsiElement it = element;
                                boolean bl = false;
                                super.visitElement(element);
                            }
                        });
                        if (((KtExpression)((PsiElement)result$iv$iv$iv.element) == null ? false : GuardClausesKt.isIfConditionGuardClause($this$isGuardClause$iv, descendantExpr$iv) || GuardClausesKt.isElvisOperatorGuardClause($this$isGuardClause$iv, descendantExpr$iv)) || GuardClausesKt.isSuperCall(it)) continue;
                        firstNonGuardFound.element = true;
                        this.L$0 = $this$sequence;
                        this.L$1 = firstNonGuardFound;
                        this.L$2 = iterator2;
                        this.label = 2;
                        object2 = $this$sequence.yield(it, this);
                        if (object2 == object4) return object4;
                    }
                    return Unit.INSTANCE;
                }

                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                    Function2<SequenceScope<? super KtExpression>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    function2.L$0 = value2;
                    return (Continuation)((Object)function2);
                }

                public final Object invoke(SequenceScope<? super KtExpression> p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            });
        } else {
            Object object = function2.getBodyBlockExpression();
            if ((object != null && (object = ((KtBlockExpression)object).getStatements()) != null ? CollectionsKt.asSequence((Iterable)object) : (sequence2 = null)) == null) {
                sequence2 = SequencesKt.emptySequence();
            }
        }
        Sequence statements = sequence2;
        Sequence<KtReturnExpression> $this$count$iv = SequencesKt.filterNot(SequencesKt.flatMap(statements, ReturnCount::countReturnStatements$lambda$1), arg_0 -> ReturnCount.countReturnStatements$lambda$2(this, arg_0));
        boolean $i$f$count = false;
        int count$iv = 0;
        Iterator<KtReturnExpression> iterator2 = $this$count$iv.iterator();
        while (iterator2.hasNext()) {
            void $this$getParentOfType$iv;
            KtReturnExpression element$iv;
            KtReturnExpression it = element$iv = iterator2.next();
            boolean bl = false;
            PsiElement psiElement = it;
            boolean strict$iv = true;
            boolean $i$f$getParentOfType = false;
            if (!Intrinsics.areEqual(PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtNamedFunction.class, strict$iv), function2) || ++count$iv >= 0) continue;
            CollectionsKt.throwCountOverflow();
        }
        return count$iv;
    }

    private final boolean isNamedReturnFromLambda(KtReturnExpression $this$isNamedReturnFromLambda) {
        PsiElement label2 = $this$isNamedReturnFromLambda.getLabeledExpression();
        if (label2 != null) {
            KtElement $this$parentsOfTypeUntil_u24default$iv = $this$isNamedReturnFromLambda;
            boolean strict$iv = true;
            boolean $i$f$parentsOfTypeUntil = false;
            return SequencesKt.any(SequencesKt.sequence((Function2)new Function2<SequenceScope<? super KtLambdaExpression>, Continuation<? super Unit>, Object>(strict$iv, $this$parentsOfTypeUntil_u24default$iv, null){
                Object L$1;
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ boolean $strict;
                final /* synthetic */ KtElement $this_parentsOfTypeUntil;
                {
                    this.$strict = $strict;
                    this.$this_parentsOfTypeUntil = $receiver;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object var1_1) {
                    var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure(var1_1);
                            $this$sequence = (SequenceScope)this.L$0;
                            v0 = current = this.$strict != false ? this.$this_parentsOfTypeUntil.getParent() : (PsiElement)this.$this_parentsOfTypeUntil;
lbl7:
                            // 2 sources

                            while (current != null && !(current instanceof KtNamedFunction)) {
                                if (current instanceof KtLambdaExpression) {
                                    this.L$0 = $this$sequence;
                                    this.L$1 = current;
                                    this.label = 1;
                                    v1 = $this$sequence.yield(current, this);
                                    if (v1 == var2_2) {
                                        var5_5 = var2_2;
                                        return var5_5;
                                    }
                                }
                                ** GOTO lbl23
                            }
                            break;
                        }
                        case 1: {
                            current = (PsiElement)this.L$1;
                            $this$sequence = (SequenceScope)this.L$0;
                            ResultKt.throwOnFailure($result);
                            v1 = $result;
lbl23:
                            // 2 sources

                            current = current.getParent();
                            ** GOTO lbl7
                        }
                    }
                    return Unit.INSTANCE;
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                    Function2<SequenceScope<? super KtLambdaExpression>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    function2.L$0 = value2;
                    return (Continuation)((Object)function2);
                }

                public final Object invoke(SequenceScope<? super KtLambdaExpression> p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static final List excludedFunctions_delegate$lambda$0(List it) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(it, "it");
        Iterable $this$map$iv = it;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            boolean $i$f$excludedFunctions_delegate$lambda$0$stub_for_inlining = false;
            collection.add(SplitPatternKt.simplePatternToRegex((String)p0));
        }
        return (List)destination$iv$iv;
    }

    private static final boolean countReturnStatements$isExcluded(KtReturnExpression $this$countReturnStatements_u24isExcluded, ReturnCount this$0) {
        return this$0.getExcludeReturnFromLambda() && this$0.isNamedReturnFromLambda($this$countReturnStatements_u24isExcluded) || this$0.getExcludeLabeled() && $this$countReturnStatements_u24isExcluded.getLabeledExpression() != null;
    }

    /*
     * WARNING - void declaration
     */
    private static final Sequence countReturnStatements$lambda$1(KtExpression it) {
        void $this$forEachDescendantOfType$iv$iv$iv$iv;
        void $this$collectDescendantsOfTypeTo$iv$iv$iv;
        Intrinsics.checkNotNullParameter(it, "it");
        PsiElement $this$collectDescendantsOfType_u24default$iv = it;
        Function1 predicate$iv = countReturnStatements$lambda$1$$inlined$collectDescendantsOfType$default$1.INSTANCE;
        boolean $i$f$collectDescendantsOfType = false;
        PsiElement $this$collectDescendantsOfType$iv$iv = $this$collectDescendantsOfType_u24default$iv;
        boolean $i$f$collectDescendantsOfType2 = false;
        PsiElement psiElement = $this$collectDescendantsOfType$iv$iv;
        Collection to$iv$iv$iv = new ArrayList();
        boolean $i$f$collectDescendantsOfTypeTo = false;
        void var9_9 = $this$collectDescendantsOfTypeTo$iv$iv$iv;
        Function1 action$iv$iv$iv$iv = new Function1<KtReturnExpression, Unit>(predicate$iv, to$iv$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Collection $to;
            {
                this.$predicate = $predicate;
                this.$to = $to;
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final void invoke(PsiElement it) {
                Intrinsics.checkNotNullParameter(it, "it");
                if (((Boolean)this.$predicate.invoke(it)).booleanValue()) {
                    this.$to.add(it);
                }
            }
        };
        boolean $i$f$forEachDescendantOfType = false;
        PsiUtilsKt.checkDecompiledText((PsiElement)$this$forEachDescendantOfType$iv$iv$iv$iv);
        $this$forEachDescendantOfType$iv$iv$iv$iv.accept(new PsiRecursiveElementVisitor(action$iv$iv$iv$iv){
            final /* synthetic */ Function1 $action;
            {
                this.$action = $action;
            }

            public void visitElement(PsiElement element) {
                Intrinsics.checkNotNullParameter(element, "element");
                PsiElement it = element;
                boolean bl = false;
                super.visitElement(element);
                if (element instanceof KtReturnExpression) {
                    this.$action.invoke(element);
                }
            }
        });
        return CollectionsKt.asSequence((List)to$iv$iv$iv);
    }

    private static final boolean countReturnStatements$lambda$2(ReturnCount this$0, KtReturnExpression it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return ReturnCount.countReturnStatements$isExcluded(it, this$0);
    }

    public ReturnCount() {
        this((Config)null, 1, (DefaultConstructorMarker)null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(ReturnCount.class, "max", "getMax()I", 0)), Reflection.property1(new PropertyReference1Impl(ReturnCount.class, "excludedFunctions", "getExcludedFunctions()Ljava/util/List;", 0)), Reflection.property1(new PropertyReference1Impl(ReturnCount.class, "excludeLabeled", "getExcludeLabeled()Z", 0)), Reflection.property1(new PropertyReference1Impl(ReturnCount.class, "excludeReturnFromLambda", "getExcludeReturnFromLambda()Z", 0)), Reflection.property1(new PropertyReference1Impl(ReturnCount.class, "excludeGuardClauses", "getExcludeGuardClauses()Z", 0))};
        $$delegatedProperties = kPropertyArray;
    }
}

