/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0011"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/OptionalAbstractKeyword;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitClass", "", "klass", "Lorg/jetbrains/kotlin/psi/KtClass;", "handleAbstractKeyword", "dcl", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "detekt-rules-style"})
@SourceDebugExtension(value={"SMAP\nOptionalAbstractKeyword.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OptionalAbstractKeyword.kt\nio/gitlab/arturbosch/detekt/rules/style/OptionalAbstractKeyword\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,65:1\n1863#2,2:66\n158#3:68\n13409#4,2:69\n*S KotlinDebug\n*F\n+ 1 OptionalAbstractKeyword.kt\nio/gitlab/arturbosch/detekt/rules/style/OptionalAbstractKeyword\n*L\n52#1:66,2\n53#1:68\n53#1:69,2\n*E\n"})
public final class OptionalAbstractKeyword
extends Rule {
    @NotNull
    private final Issue issue;

    public OptionalAbstractKeyword(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        String string2 = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue(string2, "getSimpleName(...)");
        this.issue = new Issue(string2, Severity.Style, "Unnecessary abstract modifier in interface detected. This abstract modifier is unnecessary and thus can be removed.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ OptionalAbstractKeyword(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    @Override
    public void visitClass(@NotNull KtClass klass) {
        Intrinsics.checkNotNullParameter(klass, "klass");
        if (klass.isInterface()) {
            this.handleAbstractKeyword(klass);
            KtClassBody body2 = klass.getBody();
            if (body2 != null) {
                PsiElement[] $this$forEach$iv = (PsiElement[])body2.getProperties();
                boolean $i$f$forEach = false;
                for (Object t : $this$forEach$iv) {
                    KtProperty it = (KtProperty)t;
                    boolean bl = false;
                    this.handleAbstractKeyword(it);
                }
                PsiElement $this$getChildrenOfType$iv = body2;
                boolean $i$f$getChildrenOfType = false;
                PsiElement[] psiElementArray = PsiTreeUtil.getChildrenOfType((PsiElement)$this$getChildrenOfType$iv, KtNamedFunction.class);
                if (psiElementArray == null) {
                    psiElementArray = new KtNamedFunction[0];
                }
                $this$forEach$iv = psiElementArray;
                $i$f$forEach = false;
                for (PsiElement element$iv : $this$forEach$iv) {
                    KtNamedFunction it = (KtNamedFunction)element$iv;
                    boolean bl = false;
                    this.handleAbstractKeyword(it);
                }
            }
        }
        super.visitClass(klass);
    }

    private final void handleAbstractKeyword(KtDeclaration dcl) {
        block0: {
            PsiElement psiElement = dcl.getModifierList();
            if (psiElement == null || (psiElement = psiElement.getModifier(KtTokens.ABSTRACT_KEYWORD)) == null) break block0;
            PsiElement it = psiElement;
            boolean bl = false;
            this.report(new CodeSmell(this.getIssue(), Entity.Companion.from$default(Entity.Companion, it, 0, 2, null), "The abstract keyword on this declaration is unnecessary.", null, null, 24, null));
        }
    }

    public OptionalAbstractKeyword() {
        this((Config)null, 1, (DefaultConstructorMarker)null);
    }
}

