/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.RequiresTypeResolution;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@RequiresTypeResolution
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\f\u0010\u000e\u001a\u00020\u000f*\u00020\u0010H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0011"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/NullableBooleanCheck;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitBinaryExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "isBooleanConstant", "", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "detekt-rules-style"})
public final class NullableBooleanCheck
extends Rule {
    @NotNull
    private final Issue issue;

    public NullableBooleanCheck(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        String string2 = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue(string2, "getSimpleName(...)");
        this.issue = new Issue(string2, Severity.Style, "Nullable boolean check should use `==` rather than `?:`", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ NullableBooleanCheck(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    @Override
    public void visitBinaryExpression(@NotNull KtBinaryExpression expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        if (Intrinsics.areEqual(expression2.getOperationToken(), KtTokens.ELVIS)) {
            KtExpression ktExpression = expression2.getRight();
            boolean bl = ktExpression != null ? this.isBooleanConstant(ktExpression) : false;
            if (bl) {
                Object object = expression2.getLeft();
                boolean bl2 = object != null && (object = CallUtilKt.getType((KtExpression)object, this.getBindingContext())) != null ? TypeUtilsKt.isBooleanOrNullableBoolean((KotlinType)object) : false;
                if (bl2) {
                    KtExpression ktExpression2 = expression2.getRight();
                    String messageSuffix = Intrinsics.areEqual(ktExpression2 != null ? ktExpression2.getText() : null, "true") ? "`!= false` rather than `?: true`" : "`== true` rather than `?: false`";
                    this.report(new CodeSmell(this.getIssue(), Entity.Companion.from$default(Entity.Companion, expression2, 0, 2, null), "The nullable boolean check `" + expression2.getText() + "` should use " + messageSuffix, null, null, 24, null));
                }
            }
        }
        super.visitBinaryExpression(expression2);
    }

    private final boolean isBooleanConstant(PsiElement $this$isBooleanConstant) {
        return Intrinsics.areEqual($this$isBooleanConstant.getNode().getElementType(), KtNodeTypes.BOOLEAN_CONSTANT);
    }

    public NullableBooleanCheck() {
        this((Config)null, 1, (DefaultConstructorMarker)null);
    }
}

