/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.rules.KtModifierListKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtEnumEntry;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\f\u0010\u000f\u001a\u00020\u0010*\u00020\u0011H\u0002J\f\u0010\u0012\u001a\u00020\u0010*\u00020\u0011H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0013"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/NestedClassesVisibility;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitClass", "", "klass", "Lorg/jetbrains/kotlin/psi/KtClass;", "checkDeclarations", "isNoEnum", "", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "isNoCompanionObj", "detekt-rules-style"})
@SourceDebugExtension(value={"SMAP\nNestedClassesVisibility.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NestedClassesVisibility.kt\nio/gitlab/arturbosch/detekt/rules/style/NestedClassesVisibility\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,66:1\n808#2,11:67\n774#2:78\n865#2,2:79\n1863#2,2:81\n*S KotlinDebug\n*F\n+ 1 NestedClassesVisibility.kt\nio/gitlab/arturbosch/detekt/rules/style/NestedClassesVisibility\n*L\n57#1:67,11\n58#1:78\n58#1:79,2\n59#1:81,2\n*E\n"})
public final class NestedClassesVisibility
extends Rule {
    @NotNull
    private final Issue issue;

    public NestedClassesVisibility(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        this.issue = new Issue("NestedClassesVisibility", Severity.Style, "The explicit public modifier still results in an internal nested class.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ NestedClassesVisibility(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    @Override
    public void visitClass(@NotNull KtClass klass) {
        Intrinsics.checkNotNullParameter(klass, "klass");
        if (!klass.isInterface() && klass.isTopLevel() && KtModifierListKt.isInternal(klass)) {
            this.checkDeclarations(klass);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkDeclarations(KtClass klass) {
        void $this$filterTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = klass.getDeclarations();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof KtClassOrObject)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KtClassOrObject it = (KtClassOrObject)element$iv$iv;
            boolean bl = false;
            if (!(it.hasModifier(KtTokens.PUBLIC_KEYWORD) && this.isNoEnum(it) && this.isNoCompanionObj(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtClassOrObject it = (KtClassOrObject)element$iv;
            boolean bl = false;
            this.report(new CodeSmell(this.getIssue(), Entity.Companion.from$default(Entity.Companion, it, 0, 2, null), this.getIssue().getDescription(), null, null, 24, null));
        }
    }

    private final boolean isNoEnum(KtClassOrObject $this$isNoEnum) {
        return !$this$isNoEnum.hasModifier(KtTokens.ENUM_KEYWORD) && !($this$isNoEnum instanceof KtEnumEntry);
    }

    private final boolean isNoCompanionObj(KtClassOrObject $this$isNoCompanionObj) {
        return !$this$isNoCompanionObj.hasModifier(KtTokens.COMPANION_KEYWORD);
    }

    public NestedClassesVisibility() {
        this((Config)null, 1, (DefaultConstructorMarker)null);
    }
}

