/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.github.detekt.psi.KtFilesKt;
import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Location;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.SourceLocation;
import io.gitlab.arturbosch.detekt.api.TextLocation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtLiteralStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a$\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002\u001a\f\u0010\f\u001a\u00020\r*\u00020\u000eH\u0002\u001a\f\u0010\u000f\u001a\u00020\r*\u00020\u0010H\u0002\u001a\f\u0010\u0011\u001a\u00020\r*\u00020\u0012H\u0002\u001a\f\u0010\u0013\u001a\u00020\n*\u00020\bH\u0002\u001a\u0014\u0010\u0014\u001a\u00020\b*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\nH\u0002\u001a\u001c\u0010\u0017\u001a\u00020\u0006*\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0002\u00a8\u0006\u001b"}, d2={"report", "", "Lio/gitlab/arturbosch/detekt/api/Rule;", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "location", "Lio/gitlab/arturbosch/detekt/api/Location;", "message", "", "desiredIntent", "", "currentIndent", "isSurroundedByLineBreaks", "", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "isBlankOrLineBreak", "Lorg/jetbrains/kotlin/psi/KtStringTemplateEntry;", "isTabChar", "", "countIndent", "getLine", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiFile;", "line", "getLocation", "start", "Lio/gitlab/arturbosch/detekt/api/SourceLocation;", "end", "detekt-rules-style"})
@SourceDebugExtension(value={"SMAP\nMultilineRawStringIndentation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultilineRawStringIndentation.kt\nio/gitlab/arturbosch/detekt/rules/style/MultilineRawStringIndentationKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Junk.kt\nio/gitlab/arturbosch/detekt/rules/JunkKt\n+ 5 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,211:1\n5298#2,7:212\n5172#2,6:222\n1755#3,3:219\n1755#3,3:228\n40#4:231\n1069#5,2:232\n648#5,5:234\n*S KotlinDebug\n*F\n+ 1 MultilineRawStringIndentation.kt\nio/gitlab/arturbosch/detekt/rules/style/MultilineRawStringIndentationKt\n*L\n176#1:212,7\n177#1:222,6\n176#1:219,3\n177#1:228,3\n181#1:231\n182#1:232,2\n187#1:234,5\n*E\n"})
public final class MultilineRawStringIndentationKt {
    private static final void report(Rule $this$report, KtElement element, Location location, String message) {
        $this$report.report(new CodeSmell($this$report.getIssue(), Entity.Companion.from((PsiElement)element, location), message, null, null, 24, null));
    }

    private static final String message(int desiredIntent, int currentIndent) {
        return "The indentation should be " + desiredIntent + " but it is " + currentIndent + '.';
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isSurroundedByLineBreaks(KtStringTemplateExpression $this$isSurroundedByLineBreaks) {
        KtStringTemplateEntry it;
        List<KtStringTemplateEntry> list;
        boolean $i$f$any;
        Iterable $this$any$iv;
        block6: {
            KtStringTemplateEntry it2;
            KtStringTemplateEntry[] entries2;
            KtStringTemplateEntry[] ktStringTemplateEntryArray = $this$isSurroundedByLineBreaks.getEntries();
            Intrinsics.checkNotNullExpressionValue(ktStringTemplateEntryArray, "getEntries(...)");
            KtStringTemplateEntry[] $this$takeWhile$iv = entries2 = ktStringTemplateEntryArray;
            boolean $i$f$takeWhile = false;
            Object list$iv = new ArrayList();
            int n = $this$takeWhile$iv.length;
            for (int j = 0; j < n; ++j) {
                KtStringTemplateEntry item$iv;
                KtStringTemplateEntry it3 = item$iv = $this$takeWhile$iv[j];
                boolean bl = false;
                Intrinsics.checkNotNull(it3);
                if (!MultilineRawStringIndentationKt.isBlankOrLineBreak(it3)) break;
                ((ArrayList)list$iv).add(item$iv);
            }
            $this$any$iv = (List)list$iv;
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            list$iv = $this$any$iv.iterator();
            do {
                if (!list$iv.hasNext()) return false;
                Object element$iv = list$iv.next();
                it2 = (KtStringTemplateEntry)element$iv;
                boolean bl = false;
            } while (!Intrinsics.areEqual(it2.getText(), "\n"));
            boolean bl = true;
            if (!bl) return false;
            KtStringTemplateEntry[] $this$takeLastWhile$iv = entries2;
            boolean $i$f$takeLastWhile = false;
            for (int index$iv = ArraysKt.getLastIndex($this$takeLastWhile$iv); -1 < index$iv; --index$iv) {
                KtStringTemplateEntry it4 = $this$takeLastWhile$iv[index$iv];
                boolean bl2 = false;
                Intrinsics.checkNotNull(it4);
                if (MultilineRawStringIndentationKt.isBlankOrLineBreak(it4)) continue;
                list = ArraysKt.drop($this$takeLastWhile$iv, index$iv + 1);
                break block6;
            }
            list = ArraysKt.toList($this$takeLastWhile$iv);
        }
        $this$any$iv = list;
        $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            it = (KtStringTemplateEntry)element$iv;
            boolean bl = false;
        } while (!Intrinsics.areEqual(it.getText(), "\n"));
        return true;
    }

    private static final boolean isBlankOrLineBreak(KtStringTemplateEntry $this$isBlankOrLineBreak) {
        boolean bl;
        Object text;
        block3: {
            Object object;
            KtStringTemplateEntry $this$safeAs$iv = $this$isBlankOrLineBreak;
            boolean $i$f$safeAs = false;
            KtStringTemplateEntry ktStringTemplateEntry = $this$safeAs$iv;
            if (!(ktStringTemplateEntry instanceof KtLiteralStringTemplateEntry)) {
                ktStringTemplateEntry = null;
            }
            if ((object = (KtLiteralStringTemplateEntry)ktStringTemplateEntry) == null || (object = ((KtLiteralStringTemplateEntry)object).getText()) == null) {
                return false;
            }
            text = object;
            CharSequence $this$all$iv = (CharSequence)text;
            boolean $i$f$all = false;
            for (int j = 0; j < $this$all$iv.length(); ++j) {
                char element$iv;
                char it = element$iv = $this$all$iv.charAt(j);
                boolean bl2 = false;
                if (MultilineRawStringIndentationKt.isTabChar(it)) continue;
                bl = false;
                break block3;
            }
            bl = true;
        }
        return bl || Intrinsics.areEqual(text, "\n");
    }

    private static final boolean isTabChar(char $this$isTabChar) {
        return $this$isTabChar == ' ' || $this$isTabChar == '\t';
    }

    /*
     * WARNING - void declaration
     */
    private static final int countIndent(String $this$countIndent) {
        String string2;
        block1: {
            void var1_1;
            String $this$takeWhile$iv = $this$countIndent;
            boolean $i$f$takeWhile = false;
            int n = $this$takeWhile$iv.length();
            for (int index$iv = 0; index$iv < n; ++index$iv) {
                char it = $this$takeWhile$iv.charAt(index$iv);
                boolean bl = false;
                if (MultilineRawStringIndentationKt.isTabChar(it)) continue;
                String string3 = $this$takeWhile$iv;
                int n2 = 0;
                String string4 = string3.substring(n2, index$iv);
                string2 = string4;
                Intrinsics.checkNotNullExpressionValue(string4, "substring(...)");
                break block1;
            }
            string2 = var1_1;
        }
        return ((CharSequence)string2).length();
    }

    private static final String getLine(PsiFile $this$getLine, int line) {
        String string2 = $this$getLine.getText();
        Intrinsics.checkNotNullExpressionValue(string2, "getText(...)");
        return SequencesKt.first(SequencesKt.drop(StringsKt.lineSequence(string2), line - 1));
    }

    private static final Location getLocation(PsiFile $this$getLocation, SourceLocation start, SourceLocation end) {
        String string2 = $this$getLocation.getText();
        Intrinsics.checkNotNullExpressionValue(string2, "getText(...)");
        List<String> lines = StringsKt.lines(string2);
        int startOffset = 0;
        int n = start.getLine();
        for (int i2 = 1; i2 < n; ++i2) {
            startOffset += lines.get(i2 - 1).length() + 1;
        }
        int endOffset = startOffset;
        int n2 = end.getLine();
        for (int i3 = start.getLine(); i3 < n2; ++i3) {
            endOffset += lines.get(i3 - 1).length() + 1;
        }
        String string3 = $this$getLocation.getText();
        Intrinsics.checkNotNullExpressionValue(string3, "getText(...)");
        StringsKt.lines(string3);
        return new Location(start, end, new TextLocation(startOffset + start.getColumn() - 1, endOffset + end.getColumn() - 1), KtFilesKt.toFilePath($this$getLocation));
    }

    public static final /* synthetic */ boolean access$isSurroundedByLineBreaks(KtStringTemplateExpression $receiver) {
        return MultilineRawStringIndentationKt.isSurroundedByLineBreaks($receiver);
    }

    public static final /* synthetic */ int access$countIndent(String $receiver) {
        return MultilineRawStringIndentationKt.countIndent($receiver);
    }

    public static final /* synthetic */ String access$getLine(PsiFile $receiver, int line) {
        return MultilineRawStringIndentationKt.getLine($receiver, line);
    }

    public static final /* synthetic */ Location access$getLocation(PsiFile $receiver, SourceLocation start, SourceLocation end) {
        return MultilineRawStringIndentationKt.getLocation($receiver, start, end);
    }

    public static final /* synthetic */ void access$report(Rule $receiver, KtElement element, Location location, String message) {
        MultilineRawStringIndentationKt.report($receiver, element, location, message);
    }

    public static final /* synthetic */ String access$message(int desiredIntent, int currentIndent) {
        return MultilineRawStringIndentationKt.message(desiredIntent, currentIndent);
    }
}

