/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.RequiresTypeResolution;
import io.gitlab.arturbosch.detekt.rules.KtLambdaExpressionKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtParameter;

@RequiresTypeResolution
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\f\u0010\u0010\u001a\u00020\u0011*\u00020\u000fH\u0002J\f\u0010\u0012\u001a\u00020\u0011*\u00020\u000fH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/MultilineLambdaItParameter;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "getConfig", "()Lio/gitlab/arturbosch/detekt/api/Config;", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitLambdaExpression", "", "lambdaExpression", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "isMultiline", "", "isUsingImplicitParameter", "detekt-rules-style"})
@SourceDebugExtension(value={"SMAP\nMultilineLambdaItParameter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultilineLambdaItParameter.kt\nio/gitlab/arturbosch/detekt/rules/style/MultilineLambdaItParameter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,118:1\n1557#2:119\n1628#2,3:120\n*S KotlinDebug\n*F\n+ 1 MultilineLambdaItParameter.kt\nio/gitlab/arturbosch/detekt/rules/style/MultilineLambdaItParameter\n*L\n80#1:119\n80#1:120,3\n*E\n"})
public final class MultilineLambdaItParameter
extends Rule {
    @NotNull
    private final Config config;
    @NotNull
    private final Issue issue;

    public MultilineLambdaItParameter(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        this.config = config;
        String string2 = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue(string2, "getSimpleName(...)");
        this.issue = new Issue(string2, Severity.Style, "Multiline lambdas should not use `it` as a parameter name.", Debt.Companion.getFIVE_MINS());
    }

    @NotNull
    public final Config getConfig() {
        return this.config;
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitLambdaExpression(@NotNull KtLambdaExpression lambdaExpression) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(lambdaExpression, "lambdaExpression");
        super.visitLambdaExpression(lambdaExpression);
        if (!this.isMultiline(lambdaExpression)) {
            return;
        }
        List<KtParameter> list = lambdaExpression.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list, "getValueParameters(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KtParameter ktParameter = (KtParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        List parameterNames = (List)destination$iv$iv;
        if (parameterNames.contains("it")) {
            this.report(new CodeSmell(this.getIssue(), Entity.Companion.from$default(Entity.Companion, lambdaExpression, 0, 2, null), "The parameter name in a multiline lambda should not be an explicit `it`. Consider giving your parameter a readable and descriptive name.", null, null, 24, null));
        } else if (parameterNames.isEmpty() && this.isUsingImplicitParameter(lambdaExpression)) {
            this.report(new CodeSmell(this.getIssue(), Entity.Companion.from$default(Entity.Companion, lambdaExpression, 0, 2, null), "The implicit `it` should not be used in a multiline lambda. Consider giving your parameter a readable and descriptive name.", null, null, 24, null));
        }
    }

    private final boolean isMultiline(KtLambdaExpression $this$isMultiline) {
        boolean bl;
        Object object = $this$isMultiline.getBodyExpression();
        if (object == null || (object = ((KtBlockExpression)object).getStatements()) == null) {
            return false;
        }
        Object statements = object;
        switch (statements.size()) {
            case 0: {
                bl = false;
                break;
            }
            case 1: {
                bl = ((KtExpression)CollectionsKt.single(statements)).textContains('\n');
                break;
            }
            default: {
                bl = true;
            }
        }
        return bl;
    }

    private final boolean isUsingImplicitParameter(KtLambdaExpression $this$isUsingImplicitParameter) {
        ValueParameterDescriptor valueParameterDescriptor = KtLambdaExpressionKt.implicitParameter($this$isUsingImplicitParameter, this.getBindingContext());
        if (valueParameterDescriptor == null) {
            return false;
        }
        ValueParameterDescriptor implicitParameter = valueParameterDescriptor;
        return KtLambdaExpressionKt.hasImplicitParameterReference($this$isUsingImplicitParameter, implicitParameter, this.getBindingContext());
    }
}

