/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.rules.KtModifierListKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\u0017H\u0016J\f\u0010\"\u001a\u00020\u0016*\u00020\u0017H\u0002J\f\u0010#\u001a\u00020\u0016*\u00020\u0017H\u0002J\f\u0010$\u001a\u00020\u0016*\u00020\u0017H\u0002J\f\u0010%\u001a\u00020\u0016*\u00020\u0017H\u0002J\f\u0010&\u001a\u00020\u0016*\u00020'H\u0002J\u0010\u0010(\u001a\u00020\u00162\u0006\u0010)\u001a\u00020'H\u0002J\u0010\u0010*\u001a\u00020\u00162\u0006\u0010)\u001a\u00020'H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001e\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\u00110\u0010j\b\u0012\u0004\u0012\u00020\u0011`\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0013\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\f0\u0010j\n\u0012\u0006\u0012\u0004\u0018\u00010\f`\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0014\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\f0\u0010j\n\u0012\u0006\u0012\u0004\u0018\u00010\f`\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0015\u001a\u00020\u0016*\u00020\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0018\u00a8\u0006+"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/MayBeConst;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "defaultRuleIdAliases", "", "", "getDefaultRuleIdAliases", "()Ljava/util/Set;", "binaryTokens", "Ljava/util/HashSet;", "Lorg/jetbrains/kotlin/lexer/KtSingleValueToken;", "Lkotlin/collections/HashSet;", "topLevelConstants", "companionObjectConstants", "isActual", "", "Lorg/jetbrains/kotlin/psi/KtProperty;", "(Lorg/jetbrains/kotlin/psi/KtProperty;)Z", "visitKtFile", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "visitObjectDeclaration", "declaration", "Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "visitProperty", "property", "canBeConst", "isJvmField", "cannotBeConstant", "isInObject", "isConstantExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "isParenthesizedExpression", "expression", "isBinaryExpression", "detekt-rules-style"})
@SourceDebugExtension(value={"SMAP\nMayBeConst.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MayBeConst.kt\nio/gitlab/arturbosch/detekt/rules/style/MayBeConst\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,147:1\n808#2,11:148\n774#2:159\n865#2,2:160\n1611#2,9:162\n1863#2:171\n1864#2:173\n1620#2:174\n808#2,11:175\n774#2:186\n865#2,2:187\n1611#2,9:189\n1863#2:198\n1864#2:200\n1620#2:201\n1755#2,3:202\n1#3:172\n1#3:199\n*S KotlinDebug\n*F\n+ 1 MayBeConst.kt\nio/gitlab/arturbosch/detekt/rules/style/MayBeConst\n*L\n66#1:148,11\n67#1:159\n67#1:160,2\n68#1:162,9\n68#1:171\n68#1:173\n68#1:174\n78#1:175,11\n79#1:186\n79#1:187,2\n80#1:189,9\n80#1:198\n80#1:200\n80#1:201\n108#1:202,3\n68#1:172\n80#1:199\n*E\n"})
public final class MayBeConst
extends Rule {
    @NotNull
    private final Issue issue;
    @NotNull
    private final Set<String> defaultRuleIdAliases;
    @NotNull
    private final HashSet<KtSingleValueToken> binaryTokens;
    @NotNull
    private final HashSet<String> topLevelConstants;
    @NotNull
    private final HashSet<String> companionObjectConstants;

    public MayBeConst(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        String string2 = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue(string2, "getSimpleName(...)");
        this.issue = new Issue(string2, Severity.Style, "Usage of `vals` that can be `const val` detected.", Debt.Companion.getFIVE_MINS());
        this.defaultRuleIdAliases = SetsKt.setOf("MayBeConstant");
        KtSingleValueToken[] ktSingleValueTokenArray = new KtSingleValueToken[]{KtTokens.PLUS, KtTokens.MINUS, KtTokens.MUL, KtTokens.DIV, KtTokens.PERC};
        this.binaryTokens = SetsKt.hashSetOf(ktSingleValueTokenArray);
        this.topLevelConstants = new HashSet();
        this.companionObjectConstants = new HashSet();
    }

    public /* synthetic */ MayBeConst(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    @Override
    @NotNull
    public Set<String> getDefaultRuleIdAliases() {
        return this.defaultRuleIdAliases;
    }

    private final boolean isActual(KtProperty $this$isActual) {
        return $this$isActual.hasModifier(KtTokens.ACTUAL_KEYWORD);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitKtFile(@NotNull KtFile file2) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter(file2, "file");
        this.topLevelConstants.clear();
        Iterable $this$filterIsInstance$iv = file2.getDeclarations();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof KtProperty)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KtProperty it = (KtProperty)element$iv$iv;
            boolean bl = false;
            if (!(it.isTopLevel() && KtModifierListKt.isConstant(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            KtProperty it = (KtProperty)element$iv$iv;
            boolean bl2 = false;
            if (it.getName() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List topLevelProperties = (List)destination$iv$iv;
        this.topLevelConstants.addAll(topLevelProperties);
        super.visitKtFile(file2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitObjectDeclaration(@NotNull KtObjectDeclaration declaration) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        if (declaration.isObjectLiteral()) {
            return;
        }
        Iterable $this$filterIsInstance$iv = declaration.getDeclarations();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof KtProperty)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KtProperty it = (KtProperty)element$iv$iv;
            boolean bl = false;
            if (!KtModifierListKt.isConstant(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            KtProperty it = (KtProperty)element$iv$iv;
            boolean bl2 = false;
            if (it.getName() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List constProperties = (List)destination$iv$iv;
        this.companionObjectConstants.addAll(constProperties);
        super.visitObjectDeclaration(declaration);
        this.companionObjectConstants.removeAll(constProperties);
    }

    @Override
    public void visitProperty(@NotNull KtProperty property) {
        Intrinsics.checkNotNullParameter(property, "property");
        super.visitProperty(property);
        if (this.canBeConst(property)) {
            this.report(new CodeSmell(this.getIssue(), Entity.Companion.atName(property), property.getNameAsSafeName() + " can be a `const val`.", null, null, 24, null));
        }
    }

    private final boolean canBeConst(KtProperty $this$canBeConst) {
        if (this.cannotBeConstant($this$canBeConst) || this.isInObject($this$canBeConst) || this.isJvmField($this$canBeConst)) {
            return false;
        }
        KtExpression ktExpression = $this$canBeConst.getInitializer();
        return ktExpression != null ? this.isConstantExpression(ktExpression) : false;
    }

    private final boolean isJvmField(KtProperty $this$isJvmField) {
        boolean bl;
        block3: {
            List<KtAnnotationEntry> list = $this$isJvmField.getAnnotationEntries();
            Intrinsics.checkNotNullExpressionValue(list, "getAnnotationEntries(...)");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KtAnnotationEntry it = (KtAnnotationEntry)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual(it.getText(), "@JvmField")) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        boolean isJvmField = bl;
        List<KtAnnotationEntry> list = $this$isJvmField.getAnnotationEntries();
        Intrinsics.checkNotNullExpressionValue(list, "getAnnotationEntries(...)");
        return !((Collection)list).isEmpty() && !isJvmField;
    }

    private final boolean cannotBeConstant(KtProperty $this$cannotBeConstant) {
        return $this$cannotBeConstant.isLocal() || $this$cannotBeConstant.isVar() || this.isActual($this$cannotBeConstant) || $this$cannotBeConstant.getGetter() != null || KtModifierListKt.isConstant($this$cannotBeConstant) || KtModifierListKt.isOverride($this$cannotBeConstant);
    }

    private final boolean isInObject(KtProperty $this$isInObject) {
        return !$this$isInObject.isTopLevel() && !(KtPsiUtilKt.getContainingClassOrObject($this$isInObject) instanceof KtObjectDeclaration);
    }

    private final boolean isConstantExpression(KtExpression $this$isConstantExpression) {
        return $this$isConstantExpression instanceof KtStringTemplateExpression && !((KtStringTemplateExpression)$this$isConstantExpression).hasInterpolation() || Intrinsics.areEqual($this$isConstantExpression.getNode().getElementType(), KtNodeTypes.BOOLEAN_CONSTANT) || Intrinsics.areEqual($this$isConstantExpression.getNode().getElementType(), KtNodeTypes.INTEGER_CONSTANT) || Intrinsics.areEqual($this$isConstantExpression.getNode().getElementType(), KtNodeTypes.CHARACTER_CONSTANT) || Intrinsics.areEqual($this$isConstantExpression.getNode().getElementType(), KtNodeTypes.FLOAT_CONSTANT) || this.topLevelConstants.contains($this$isConstantExpression.getText()) || this.companionObjectConstants.contains($this$isConstantExpression.getText()) || this.isBinaryExpression($this$isConstantExpression) || this.isParenthesizedExpression($this$isConstantExpression);
    }

    private final boolean isParenthesizedExpression(KtExpression expression2) {
        KtExpression ktExpression = expression2 instanceof KtParenthesizedExpression ? (KtParenthesizedExpression)expression2 : null;
        return ktExpression != null && (ktExpression = ktExpression.getExpression()) != null ? this.isConstantExpression(ktExpression) : false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isBinaryExpression(KtExpression expression2) {
        if (!(expression2 instanceof KtBinaryExpression)) return false;
        if (!Intrinsics.areEqual(((KtBinaryExpression)expression2).getNode().getElementType(), KtNodeTypes.BINARY_EXPRESSION)) return false;
        if (!CollectionsKt.contains((Iterable)this.binaryTokens, ((KtBinaryExpression)expression2).getOperationToken())) return false;
        KtExpression ktExpression = ((KtBinaryExpression)expression2).getLeft();
        if (ktExpression == null) return false;
        if (!this.isConstantExpression(ktExpression)) return false;
        boolean bl = true;
        if (!bl) return false;
        KtExpression ktExpression2 = ((KtBinaryExpression)expression2).getRight();
        if (ktExpression2 == null) return false;
        if (!this.isConstantExpression(ktExpression2)) return false;
        return true;
    }

    public MayBeConst() {
        this((Config)null, 1, (DefaultConstructorMarker)null);
    }
}

