/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.api.internal.RequiresTypeResolution;
import io.gitlab.arturbosch.detekt.rules.style.MaxChainedCallsOnSameLine$getReceiverEndPosition$;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;

@RequiresTypeResolution
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\f\u0010\u0016\u001a\u00020\u000b*\u00020\u0017H\u0002J\f\u0010\u0018\u001a\u00020\u0019*\u00020\u0017H\u0002J\f\u0010\u001a\u001a\u00020\u0019*\u00020\u0015H\u0002J\u0010\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u0017H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR!\u0010\n\u001a\u00020\u000b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\u0011\u0012\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001d"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/MaxChainedCallsOnSameLine;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "maxChainedCalls", "", "getMaxChainedCalls$annotations", "()V", "getMaxChainedCalls", "()I", "maxChainedCalls$delegate", "Lkotlin/properties/ReadOnlyProperty;", "visitQualifiedExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;", "countChainedCalls", "Lorg/jetbrains/kotlin/psi/KtExpression;", "isReferenceToPackageOrClass", "", "callOnNewLine", "getReceiverEndPosition", "receiver", "detekt-rules-style"})
@SourceDebugExtension(value={"SMAP\nMaxChainedCallsOnSameLine.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MaxChainedCallsOnSameLine.kt\nio/gitlab/arturbosch/detekt/rules/style/MaxChainedCallsOnSameLine\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,122:1\n280#2,7:123\n299#2:130\n*S KotlinDebug\n*F\n+ 1 MaxChainedCallsOnSameLine.kt\nio/gitlab/arturbosch/detekt/rules/style/MaxChainedCallsOnSameLine\n*L\n107#1:123,7\n107#1:130\n*E\n"})
public final class MaxChainedCallsOnSameLine
extends Rule {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty maxChainedCalls$delegate;

    public MaxChainedCallsOnSameLine(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        String string2 = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue(string2, "getSimpleName(...)");
        this.issue = new Issue(string2, Severity.Style, "Chained calls beyond the maximum should be wrapped to a new line.", Debt.Companion.getFIVE_MINS());
        this.maxChainedCalls$delegate = ConfigPropertyKt.config(5);
    }

    public /* synthetic */ MaxChainedCallsOnSameLine(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final int getMaxChainedCalls() {
        return ((Number)this.maxChainedCalls$delegate.getValue(this, $$delegatedProperties[0])).intValue();
    }

    @Configuration(description="maximum chained calls allowed on a single line")
    private static /* synthetic */ void getMaxChainedCalls$annotations() {
    }

    @Override
    public void visitQualifiedExpression(@NotNull KtQualifiedExpression expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        super.visitQualifiedExpression(expression2);
        PsiElement parent2 = expression2.getParent();
        if (parent2 instanceof KtQualifiedExpression && !this.callOnNewLine((KtQualifiedExpression)parent2)) {
            return;
        }
        if (parent2 instanceof KtImportDirective || parent2 instanceof KtPackageDirective) {
            return;
        }
        int chainedCalls = this.countChainedCalls(expression2) + 1;
        if (chainedCalls > this.getMaxChainedCalls()) {
            this.report(new CodeSmell(this.getIssue(), Entity.Companion.from$default(Entity.Companion, expression2, 0, 2, null), chainedCalls + " chained calls on a single line; more than " + this.getMaxChainedCalls() + " calls should be wrapped to a new line.", null, null, 24, null));
        }
    }

    private final int countChainedCalls(KtExpression $this$countChainedCalls) {
        int n;
        KtExpression ktExpression = $this$countChainedCalls;
        if (ktExpression instanceof KtQualifiedExpression) {
            n = this.isReferenceToPackageOrClass(((KtQualifiedExpression)$this$countChainedCalls).getReceiverExpression()) || this.callOnNewLine((KtQualifiedExpression)$this$countChainedCalls) ? 0 : this.countChainedCalls(((KtQualifiedExpression)$this$countChainedCalls).getReceiverExpression()) + 1;
        } else if (ktExpression instanceof KtUnaryExpression) {
            KtExpression ktExpression2 = ((KtUnaryExpression)$this$countChainedCalls).getBaseExpression();
            n = ktExpression2 != null ? this.countChainedCalls(ktExpression2) : 0;
        } else {
            n = 0;
        }
        return n;
    }

    private final boolean isReferenceToPackageOrClass(KtExpression $this$isReferenceToPackageOrClass) {
        KtExpression selectorOrThis;
        KtExpression ktExpression = $this$isReferenceToPackageOrClass instanceof KtQualifiedExpression ? (KtQualifiedExpression)$this$isReferenceToPackageOrClass : null;
        if (ktExpression == null || (ktExpression = ktExpression.getSelectorExpression()) == null) {
            ktExpression = $this$isReferenceToPackageOrClass;
        }
        if (!((selectorOrThis = ktExpression) instanceof KtReferenceExpression)) {
            return false;
        }
        DeclarationDescriptor descriptor2 = (DeclarationDescriptor)this.getBindingContext().get(BindingContext.REFERENCE_TARGET, selectorOrThis);
        return descriptor2 instanceof PackageViewDescriptor || descriptor2 instanceof ClassDescriptor;
    }

    private final boolean callOnNewLine(KtQualifiedExpression $this$callOnNewLine) {
        KtExpression receiver = $this$callOnNewLine.getReceiverExpression();
        KtExpression ktExpression = $this$callOnNewLine.getSelectorExpression();
        if (ktExpression == null) {
            return false;
        }
        KtExpression selector = ktExpression;
        int receiverEnd = this.getReceiverEndPosition(receiver);
        int selectorStart = selector.getStartOffsetInParent();
        return StringsKt.contains$default($this$callOnNewLine.getText().subSequence(receiverEnd, selectorStart + 1), '\n', false, 2, null);
    }

    private final int getReceiverEndPosition(KtExpression receiver) {
        int n;
        Ref.BooleanRef receiverDotQualifiedExpressionPassed = new Ref.BooleanRef();
        PsiElement $this$findDescendantOfType_u24default$iv = receiver;
        Function1 predicate$iv = getReceiverEndPosition$$inlined$findDescendantOfType$default$1.INSTANCE;
        boolean $i$f$findDescendantOfType = false;
        PsiUtilsKt.checkDecompiledText($this$findDescendantOfType_u24default$iv);
        Ref.ObjectRef result$iv = new Ref.ObjectRef();
        $this$findDescendantOfType_u24default$iv.accept(new PsiRecursiveElementWalkingVisitor(predicate$iv, result$iv, receiver, receiverDotQualifiedExpressionPassed){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Ref.ObjectRef $result;
            final /* synthetic */ KtExpression $receiver$inlined;
            final /* synthetic */ Ref.BooleanRef $receiverDotQualifiedExpressionPassed$inlined;
            {
                this.$predicate = $predicate;
                this.$result = $result;
                this.$receiver$inlined = ktExpression;
                this.$receiverDotQualifiedExpressionPassed$inlined = booleanRef;
            }

            public void visitElement(PsiElement element) {
                boolean canGoInside;
                Intrinsics.checkNotNullParameter(element, "element");
                if (element instanceof KtCallExpression && ((Boolean)this.$predicate.invoke(element)).booleanValue()) {
                    this.$result.element = element;
                    this.stopWalking();
                    return;
                }
                PsiElement it = element;
                boolean bl = false;
                boolean bl2 = canGoInside = Intrinsics.areEqual(it, this.$receiver$inlined) || !this.$receiverDotQualifiedExpressionPassed$inlined.element || !(it instanceof KtDotQualifiedExpression);
                if (it instanceof KtDotQualifiedExpression) {
                    this.$receiverDotQualifiedExpressionPassed$inlined.element = true;
                }
                if (canGoInside) {
                    super.visitElement(element);
                }
            }
        });
        KtCallExpression callExpression = (KtCallExpression)((PsiElement)result$iv.element);
        KtExpression ktExpression = callExpression;
        if (ktExpression != null && (ktExpression = ((KtCallExpression)ktExpression).getCalleeExpression()) != null) {
            KtExpression it = ktExpression;
            boolean bl = false;
            PsiElement psiElement = it;
            PsiElement psiElement2 = receiver.getParent();
            Intrinsics.checkNotNullExpressionValue(psiElement2, "getParent(...)");
            n = PsiUtilsKt.getStartOffsetIn(psiElement, psiElement2) + it.getTextLength() - 1;
        } else {
            n = MaxChainedCallsOnSameLine.getReceiverEndPosition$indexOfReceiverEnd(receiver);
        }
        return n;
    }

    private static final int getReceiverEndPosition$indexOfReceiverEnd(KtExpression $receiver) {
        return $receiver.getStartOffsetInParent() + $receiver.getTextLength() - 1;
    }

    public MaxChainedCallsOnSameLine() {
        this((Config)null, 1, (DefaultConstructorMarker)null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(MaxChainedCallsOnSameLine.class, "maxChainedCalls", "getMaxChainedCalls()I", 0))};
        $$delegatedProperties = kPropertyArray;
    }
}

