/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.SplitPatternKt;
import io.gitlab.arturbosch.detekt.api.ValueWithReason;
import io.gitlab.arturbosch.detekt.api.ValuesWithReason;
import io.gitlab.arturbosch.detekt.api.ValuesWithReasonKt;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.rules.style.Forbidden;
import io.gitlab.arturbosch.detekt.rules.style.ForbiddenImport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtImportDirective;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eH\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001eH\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR'\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0011\u0010\u0012\u0012\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R!\u0010\u0013\u001a\u00020\u00148BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0018\u0010\u0012\u0012\u0004\b\u0015\u0010\u000e\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006#"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/ForbiddenImport;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "imports", "", "Lio/gitlab/arturbosch/detekt/rules/style/Forbidden;", "getImports$annotations", "()V", "getImports", "()Ljava/util/List;", "imports$delegate", "Lkotlin/properties/ReadOnlyProperty;", "forbiddenPatterns", "Lkotlin/text/Regex;", "getForbiddenPatterns$annotations", "getForbiddenPatterns", "()Lkotlin/text/Regex;", "forbiddenPatterns$delegate", "visitImportDirective", "", "importDirective", "Lorg/jetbrains/kotlin/psi/KtImportDirective;", "defaultReason", "", "forbiddenImport", "containsForbiddenPattern", "", "import", "detekt-rules-style"})
@SourceDebugExtension(value={"SMAP\nForbiddenImport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ForbiddenImport.kt\nio/gitlab/arturbosch/detekt/rules/style/ForbiddenImport\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,75:1\n1#2:76\n1557#3:77\n1628#3,3:78\n*S KotlinDebug\n*F\n+ 1 ForbiddenImport.kt\nio/gitlab/arturbosch/detekt/rules/style/ForbiddenImport\n*L\n39#1:77\n39#1:78,3\n*E\n"})
public final class ForbiddenImport
extends Rule {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty imports$delegate;
    @NotNull
    private final ReadOnlyProperty forbiddenPatterns$delegate;

    public ForbiddenImport(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        String string2 = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue(string2, "getSimpleName(...)");
        this.issue = new Issue(string2, Severity.Style, "Mark forbidden imports. A forbidden import could be an import for an unstable / experimental api and hence you might want to mark it as forbidden in order to get warned about the usage.", Debt.Companion.getTEN_MINS());
        this.imports$delegate = ConfigPropertyKt.config(ValuesWithReasonKt.valuesWithReason(new Pair[0]), ForbiddenImport::imports_delegate$lambda$1);
        this.forbiddenPatterns$delegate = ConfigPropertyKt.config("", forbiddenPatterns.2.INSTANCE);
    }

    public /* synthetic */ ForbiddenImport(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final List<Forbidden> getImports() {
        return (List)this.imports$delegate.getValue(this, $$delegatedProperties[0]);
    }

    @Configuration(description="imports which should not be used")
    private static /* synthetic */ void getImports$annotations() {
    }

    private final Regex getForbiddenPatterns() {
        return (Regex)this.forbiddenPatterns$delegate.getValue(this, $$delegatedProperties[1]);
    }

    @Configuration(description="reports imports which match the specified regular expression. For example `net.*R`.")
    private static /* synthetic */ void getForbiddenPatterns$annotations() {
    }

    @Override
    public void visitImportDirective(@NotNull KtImportDirective importDirective) {
        String reason;
        Object v2;
        String string2;
        block3: {
            Intrinsics.checkNotNullParameter(importDirective, "importDirective");
            super.visitImportDirective(importDirective);
            FqName fqName = importDirective.getImportedFqName();
            String string3 = fqName != null ? fqName.asString() : null;
            if (string3 == null) {
                string3 = "";
            }
            string2 = string3;
            Iterable iterable = this.getImports();
            for (Object t : iterable) {
                Forbidden it = (Forbidden)t;
                boolean bl = false;
                if (!it.getImport().matches(string2)) continue;
                v2 = t;
                break block3;
            }
            v2 = null;
        }
        Forbidden forbidden = v2;
        String string4 = forbidden != null ? (forbidden.getReason() != null ? "The import `" + string2 + "` has been forbidden: " + forbidden.getReason() : this.defaultReason(string2)) : (reason = this.containsForbiddenPattern(string2) ? this.defaultReason(string2) : null);
        if (reason != null) {
            this.report(new CodeSmell(this.getIssue(), Entity.Companion.from$default(Entity.Companion, importDirective, 0, 2, null), reason, null, null, 24, null));
        }
    }

    private final String defaultReason(String forbiddenImport) {
        return "The import `" + forbiddenImport + "` has been forbidden in the detekt config.";
    }

    private final boolean containsForbiddenPattern(String string2) {
        return ((CharSequence)this.getForbiddenPatterns().getPattern()).length() > 0 && this.getForbiddenPatterns().containsMatchIn(string2);
    }

    /*
     * WARNING - void declaration
     */
    private static final List imports_delegate$lambda$1(ValuesWithReason list) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(list, "list");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ValueWithReason valueWithReason = (ValueWithReason)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Forbidden(SplitPatternKt.simplePatternToRegex(it.getValue()), it.getReason()));
        }
        return (List)destination$iv$iv;
    }

    public ForbiddenImport() {
        this((Config)null, 1, (DefaultConstructorMarker)null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(ForbiddenImport.class, "imports", "getImports()Ljava/util/List;", 0)), Reflection.property1(new PropertyReference1Impl(ForbiddenImport.class, "forbiddenPatterns", "getForbiddenPatterns()Lkotlin/text/Regex;", 0))};
        $$delegatedProperties = kPropertyArray;
    }
}

