/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.ValueWithReason;
import io.gitlab.arturbosch.detekt.api.ValuesWithReason;
import io.gitlab.arturbosch.detekt.api.ValuesWithReasonKt;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.rules.style.ForbiddenComment;
import io.gitlab.arturbosch.detekt.rules.style.ForbiddenComment$visitKtFile$;
import io.gitlab.arturbosch.detekt.rules.style.ForbiddenCommentKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiComment;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiRecursiveElementVisitor;
import org.jetbrains.kotlin.kdoc.psi.impl.KDocSection;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 32\u00020\u0001:\u000223B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020$2\u0006\u0010(\u001a\u00020)H\u0016J\u0018\u0010*\u001a\u00020$2\u0006\u0010+\u001a\u00020\f2\u0006\u0010%\u001a\u00020,H\u0002J\u0018\u0010-\u001a\u00020$2\u0006\u0010%\u001a\u00020,2\u0006\u0010.\u001a\u00020\fH\u0002J\f\u0010/\u001a\u00020\f*\u00020&H\u0002J\u0010\u00100\u001a\u00020\f2\u0006\u0010%\u001a\u00020\u0014H\u0002J\u0010\u00100\u001a\u00020\f2\u0006\u00101\u001a\u00020\fH\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR'\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0011\u0010\u0012\u0012\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R'\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u000b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0017\u0010\u0012\u0012\u0004\b\u0015\u0010\u000e\u001a\u0004\b\u0016\u0010\u0010R!\u0010\u0018\u001a\u00020\u00198BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u001d\u0010\u0012\u0012\u0004\b\u001a\u0010\u000e\u001a\u0004\b\u001b\u0010\u001cR!\u0010\u001e\u001a\u00020\f8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\"\u0010\u0012\u0012\u0004\b\u001f\u0010\u000e\u001a\u0004\b \u0010!\u00a8\u00064"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/ForbiddenComment;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "values", "", "", "getValues$annotations", "()V", "getValues", "()Ljava/util/List;", "values$delegate", "Lkotlin/properties/ReadOnlyProperty;", "comments", "Lio/gitlab/arturbosch/detekt/rules/style/ForbiddenComment$Comment;", "getComments$annotations", "getComments", "comments$delegate", "allowedPatterns", "Lkotlin/text/Regex;", "getAllowedPatterns$annotations", "getAllowedPatterns", "()Lkotlin/text/Regex;", "allowedPatterns$delegate", "customMessage", "getCustomMessage$annotations", "getCustomMessage", "()Ljava/lang/String;", "customMessage$delegate", "visitComment", "", "comment", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiComment;", "visitKtFile", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "checkForbiddenComment", "text", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "reportIssue", "msg", "getContent", "getErrorMessage", "value", "Comment", "Companion", "detekt-rules-style"})
@SourceDebugExtension(value={"SMAP\nForbiddenComment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ForbiddenComment.kt\nio/gitlab/arturbosch/detekt/rules/style/ForbiddenComment\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,223:1\n309#2,15:224\n229#2,2:239\n241#2:241\n328#2:242\n1863#3,2:243\n1863#3,2:245\n1863#3,2:247\n1557#3:250\n1628#3,3:251\n1#4:249\n*S KotlinDebug\n*F\n+ 1 ForbiddenComment.kt\nio/gitlab/arturbosch/detekt/rules/style/ForbiddenComment\n*L\n130#1:224,15\n130#1:239,2\n130#1:241\n130#1:242\n130#1:243,2\n140#1:245,2\n146#1:247,2\n112#1:250\n112#1:251,3\n*E\n"})
public final class ForbiddenComment
extends Rule {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty values$delegate;
    @NotNull
    private final ReadOnlyProperty comments$delegate;
    @NotNull
    private final ReadOnlyProperty allowedPatterns$delegate;
    @NotNull
    private final ReadOnlyProperty customMessage$delegate;
    @NotNull
    public static final String DEFAULT_ERROR_MESSAGE = "This comment contains '%s' that has been defined as forbidden.";

    public ForbiddenComment(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        String string2 = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue(string2, "getSimpleName(...)");
        this.issue = new Issue(string2, Severity.Style, "Flags a forbidden comment.", Debt.Companion.getTEN_MINS());
        this.values$delegate = ConfigPropertyKt.config(CollectionsKt.emptyList());
        Pair[] pairArray = new Pair[]{TuplesKt.to("FIXME:", "Forbidden FIXME todo marker in comment, please fix the problem."), TuplesKt.to("STOPSHIP:", "Forbidden STOPSHIP todo marker in comment, please address the problem before shipping the code."), TuplesKt.to("TODO:", "Forbidden TODO todo marker in comment, please do the changes.")};
        this.comments$delegate = ConfigPropertyKt.config(ValuesWithReasonKt.valuesWithReason(pairArray), ForbiddenComment::comments_delegate$lambda$1);
        this.allowedPatterns$delegate = ConfigPropertyKt.config("", allowedPatterns.2.INSTANCE);
        this.customMessage$delegate = ConfigPropertyKt.config("");
    }

    public /* synthetic */ ForbiddenComment(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final List<String> getValues() {
        return (List)this.values$delegate.getValue(this, $$delegatedProperties[0]);
    }

    @Configuration(description="forbidden comment strings")
    @Deprecated(message="Use `comments` instead, make sure you escape your text for Regular Expressions.")
    private static /* synthetic */ void getValues$annotations() {
    }

    private final List<Comment> getComments() {
        return (List)this.comments$delegate.getValue(this, $$delegatedProperties[1]);
    }

    @Configuration(description="forbidden comment string patterns")
    private static /* synthetic */ void getComments$annotations() {
    }

    private final Regex getAllowedPatterns() {
        return (Regex)this.allowedPatterns$delegate.getValue(this, $$delegatedProperties[2]);
    }

    @Configuration(description="ignores comments which match the specified regular expression. For example `Ticket|Task`.")
    private static /* synthetic */ void getAllowedPatterns$annotations() {
    }

    private final String getCustomMessage() {
        return (String)this.customMessage$delegate.getValue(this, $$delegatedProperties[3]);
    }

    @Configuration(description="error message which overrides the default one")
    @Deprecated(message="Use `comments` and provide `reason` against each `value`.")
    private static /* synthetic */ void getCustomMessage$annotations() {
    }

    @Override
    public void visitComment(@NotNull PsiComment comment) {
        Intrinsics.checkNotNullParameter(comment, "comment");
        super.visitComment(comment);
        String text = this.getContent(comment);
        this.checkForbiddenComment(text, comment);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitKtFile(@NotNull KtFile file2) {
        void $this$forEachDescendantOfType$iv$iv$iv$iv;
        void $this$collectDescendantsOfTypeTo$iv$iv$iv;
        Intrinsics.checkNotNullParameter(file2, "file");
        super.visitKtFile(file2);
        PsiElement $this$collectDescendantsOfType_u24default$iv = file2;
        Function1 predicate$iv = visitKtFile$$inlined$collectDescendantsOfType$default$1.INSTANCE;
        boolean $i$f$collectDescendantsOfType = false;
        PsiElement $this$collectDescendantsOfType$iv$iv = $this$collectDescendantsOfType_u24default$iv;
        boolean $i$f$collectDescendantsOfType2 = false;
        PsiElement psiElement = $this$collectDescendantsOfType$iv$iv;
        Collection to$iv$iv$iv = new ArrayList();
        boolean $i$f$collectDescendantsOfTypeTo = false;
        void var10_14 = $this$collectDescendantsOfTypeTo$iv$iv$iv;
        Function1 action$iv$iv$iv$iv = new Function1<KDocSection, Unit>(predicate$iv, to$iv$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Collection $to;
            {
                this.$predicate = $predicate;
                this.$to = $to;
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final void invoke(PsiElement it) {
                Intrinsics.checkNotNullParameter(it, "it");
                if (((Boolean)this.$predicate.invoke(it)).booleanValue()) {
                    this.$to.add(it);
                }
            }
        };
        boolean $i$f$forEachDescendantOfType = false;
        PsiUtilsKt.checkDecompiledText((PsiElement)$this$forEachDescendantOfType$iv$iv$iv$iv);
        $this$forEachDescendantOfType$iv$iv$iv$iv.accept(new PsiRecursiveElementVisitor(action$iv$iv$iv$iv){
            final /* synthetic */ Function1 $action;
            {
                this.$action = $action;
            }

            public void visitElement(PsiElement element) {
                Intrinsics.checkNotNullParameter(element, "element");
                PsiElement it = element;
                boolean bl = false;
                super.visitElement(element);
                if (element instanceof KDocSection) {
                    this.$action.invoke(element);
                }
            }
        });
        Iterable $this$forEach$iv = (List)to$iv$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KDocSection comment = (KDocSection)element$iv;
            boolean bl = false;
            String text = comment.getContent();
            this.checkForbiddenComment(text, comment);
        }
    }

    private final void checkForbiddenComment(String text, PsiElement comment) {
        Object it;
        if (((CharSequence)this.getAllowedPatterns().getPattern()).length() > 0 && this.getAllowedPatterns().containsMatchIn(text)) {
            return;
        }
        Iterable $this$forEach$iv = this.getValues();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl = false;
            if (!StringsKt.contains((CharSequence)text, (CharSequence)it, true)) continue;
            this.reportIssue(comment, this.getErrorMessage((String)it));
        }
        $this$forEach$iv = this.getComments();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Comment)element$iv;
            boolean bl = false;
            if (!((Comment)it).getValue().containsMatchIn(text)) continue;
            this.reportIssue(comment, this.getErrorMessage((Comment)it));
        }
    }

    private final void reportIssue(PsiElement comment, String msg) {
        this.report(new CodeSmell(this.getIssue(), Entity.Companion.from$default(Entity.Companion, comment, 0, 2, null), msg, null, null, 24, null));
    }

    private final String getContent(PsiComment $this$getContent) {
        String string2 = $this$getContent.getText();
        Intrinsics.checkNotNullExpressionValue(string2, "getText(...)");
        return ForbiddenCommentKt.getCommentContent(string2);
    }

    private final String getErrorMessage(Comment comment) {
        String string2 = comment.getReason();
        if (string2 == null) {
            String string3 = DEFAULT_ERROR_MESSAGE;
            Object[] objectArray = new Object[]{comment.getValue().getPattern()};
            String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
            string2 = string4;
            Intrinsics.checkNotNullExpressionValue(string4, "format(...)");
        }
        return string2;
    }

    private final String getErrorMessage(String value2) {
        String string2;
        String it = string2 = this.getCustomMessage();
        boolean bl = false;
        String string3 = !(((CharSequence)it).length() == 0) ? string2 : null;
        if (string3 == null) {
            String string4 = DEFAULT_ERROR_MESSAGE;
            Object[] objectArray = new Object[]{value2};
            String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
            string3 = string5;
            Intrinsics.checkNotNullExpressionValue(string5, "format(...)");
        }
        return string3;
    }

    /*
     * WARNING - void declaration
     */
    private static final List comments_delegate$lambda$1(ValuesWithReason list) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(list, "list");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ValueWithReason valueWithReason = (ValueWithReason)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string2 = it.getValue();
            Object object = new RegexOption[]{RegexOption.DOT_MATCHES_ALL, RegexOption.MULTILINE};
            object = SetsKt.setOf(object);
            collection.add(new Comment(new Regex(string2, (Set<? extends RegexOption>)object), it.getReason()));
        }
        return (List)destination$iv$iv;
    }

    public ForbiddenComment() {
        this((Config)null, 1, (DefaultConstructorMarker)null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(ForbiddenComment.class, "values", "getValues()Ljava/util/List;", 0)), Reflection.property1(new PropertyReference1Impl(ForbiddenComment.class, "comments", "getComments()Ljava/util/List;", 0)), Reflection.property1(new PropertyReference1Impl(ForbiddenComment.class, "allowedPatterns", "getAllowedPatterns()Lkotlin/text/Regex;", 0)), Reflection.property1(new PropertyReference1Impl(ForbiddenComment.class, "customMessage", "getCustomMessage()Ljava/lang/String;", 0))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/ForbiddenComment$Comment;", "", "value", "Lkotlin/text/Regex;", "reason", "", "<init>", "(Lkotlin/text/Regex;Ljava/lang/String;)V", "getValue", "()Lkotlin/text/Regex;", "getReason", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "detekt-rules-style"})
    private static final class Comment {
        @NotNull
        private final Regex value;
        @Nullable
        private final String reason;

        public Comment(@NotNull Regex value2, @Nullable String reason) {
            Intrinsics.checkNotNullParameter(value2, "value");
            this.value = value2;
            this.reason = reason;
        }

        @NotNull
        public final Regex getValue() {
            return this.value;
        }

        @Nullable
        public final String getReason() {
            return this.reason;
        }

        @NotNull
        public final Regex component1() {
            return this.value;
        }

        @Nullable
        public final String component2() {
            return this.reason;
        }

        @NotNull
        public final Comment copy(@NotNull Regex value2, @Nullable String reason) {
            Intrinsics.checkNotNullParameter(value2, "value");
            return new Comment(value2, reason);
        }

        public static /* synthetic */ Comment copy$default(Comment comment, Regex regex, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                regex = comment.value;
            }
            if ((n & 2) != 0) {
                string2 = comment.reason;
            }
            return comment.copy(regex, string2);
        }

        @NotNull
        public String toString() {
            return "Comment(value=" + this.value + ", reason=" + this.reason + ')';
        }

        public int hashCode() {
            int result2 = this.value.hashCode();
            result2 = result2 * 31 + (this.reason == null ? 0 : this.reason.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Comment)) {
                return false;
            }
            Comment comment = (Comment)other;
            if (!Intrinsics.areEqual(this.value, comment.value)) {
                return false;
            }
            return Intrinsics.areEqual(this.reason, comment.reason);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/ForbiddenComment$Companion;", "", "<init>", "()V", "DEFAULT_ERROR_MESSAGE", "", "detekt-rules-style"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

