/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0010"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/EqualsNullCall;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitCallExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "hasNullParameter", "", "detekt-rules-style"})
public final class EqualsNullCall
extends Rule {
    @NotNull
    private final Issue issue;

    public EqualsNullCall(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        this.issue = new Issue("EqualsNullCall", Severity.Style, "Equals() method is called with null as parameter. Consider using == to compare to null.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ EqualsNullCall(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    @Override
    public void visitCallExpression(@NotNull KtCallExpression expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        KtExpression ktExpression = expression2.getCalleeExpression();
        if (Intrinsics.areEqual(ktExpression != null ? ktExpression.getText() : null, "equals") && this.hasNullParameter(expression2)) {
            this.report(new CodeSmell(this.getIssue(), Entity.Companion.from$default(Entity.Companion, expression2, 0, 2, null), this.getIssue().getDescription(), null, null, 24, null));
        } else {
            super.visitCallExpression(expression2);
        }
    }

    private final boolean hasNullParameter(KtCallExpression expression2) {
        List<KtValueArgument> list = expression2.getValueArguments();
        Intrinsics.checkNotNullExpressionValue(list, "getValueArguments(...)");
        KtValueArgument ktValueArgument = CollectionsKt.singleOrNull(list);
        return Intrinsics.areEqual(ktValueArgument != null ? ktValueArgument.getText() : null, "null");
    }

    public EqualsNullCall() {
        this((Config)null, 1, (DefaultConstructorMarker)null);
    }
}

