/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR!\u0010\n\u001a\u00020\u000b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\u0011\u0012\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0016"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/DestructuringDeclarationWithTooManyEntries;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "maxDestructuringEntries", "", "getMaxDestructuringEntries$annotations", "()V", "getMaxDestructuringEntries", "()I", "maxDestructuringEntries$delegate", "Lkotlin/properties/ReadOnlyProperty;", "visitDestructuringDeclaration", "", "destructuringDeclaration", "Lorg/jetbrains/kotlin/psi/KtDestructuringDeclaration;", "detekt-rules-style"})
public final class DestructuringDeclarationWithTooManyEntries
extends Rule {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty maxDestructuringEntries$delegate;

    public DestructuringDeclarationWithTooManyEntries(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        String string2 = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue(string2, "getSimpleName(...)");
        this.issue = new Issue(string2, Severity.Style, "Too many entries in a destructuring declaration make the code hard to understand.", Debt.Companion.getTEN_MINS());
        this.maxDestructuringEntries$delegate = ConfigPropertyKt.config(3);
    }

    public /* synthetic */ DestructuringDeclarationWithTooManyEntries(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final int getMaxDestructuringEntries() {
        return ((Number)this.maxDestructuringEntries$delegate.getValue(this, $$delegatedProperties[0])).intValue();
    }

    @Configuration(description="maximum allowed elements in a destructuring declaration")
    private static /* synthetic */ void getMaxDestructuringEntries$annotations() {
    }

    @Override
    public void visitDestructuringDeclaration(@NotNull KtDestructuringDeclaration destructuringDeclaration) {
        Intrinsics.checkNotNullParameter(destructuringDeclaration, "destructuringDeclaration");
        if (destructuringDeclaration.getEntries().size() > this.getMaxDestructuringEntries()) {
            String message = "The destructuring declaration contains " + destructuringDeclaration.getEntries().size() + " but only " + this.getMaxDestructuringEntries() + " are allowed.";
            this.report(new CodeSmell(this.getIssue(), Entity.Companion.from$default(Entity.Companion, destructuringDeclaration, 0, 2, null), message, null, null, 24, null));
        }
        super.visitDestructuringDeclaration(destructuringDeclaration);
    }

    public DestructuringDeclarationWithTooManyEntries() {
        this((Config)null, 1, (DefaultConstructorMarker)null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(DestructuringDeclarationWithTooManyEntries.class, "maxDestructuringEntries", "getMaxDestructuringEntries()I", 0))};
        $$delegatedProperties = kPropertyArray;
    }
}

