/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtNamedDeclarationStub;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J$\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0014"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/DataClassShouldBeImmutable;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitClass", "", "klass", "Lorg/jetbrains/kotlin/psi/KtClass;", "report", "element", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "className", "", "propertyName", "detekt-rules-style"})
@SourceDebugExtension(value={"SMAP\nDataClassShouldBeImmutable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataClassShouldBeImmutable.kt\nio/gitlab/arturbosch/detekt/rules/style/DataClassShouldBeImmutable\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,66:1\n774#2:67\n865#2,2:68\n1863#2,2:70\n774#2:72\n865#2,2:73\n1863#2,2:75\n*S KotlinDebug\n*F\n+ 1 DataClassShouldBeImmutable.kt\nio/gitlab/arturbosch/detekt/rules/style/DataClassShouldBeImmutable\n*L\n45#1:67\n45#1:68,2\n46#1:70,2\n49#1:72\n49#1:73,2\n50#1:75,2\n*E\n"})
public final class DataClassShouldBeImmutable
extends Rule {
    @NotNull
    private final Issue issue;

    public DataClassShouldBeImmutable(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        this.issue = new Issue("DataClassShouldBeImmutable", Severity.Style, "Data classes should mainly be immutable and should not have any side effects (To copy an object altering some of its properties use the copy function).", Debt.Companion.getTWENTY_MINS());
    }

    public /* synthetic */ DataClassShouldBeImmutable(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    @Override
    public void visitClass(@NotNull KtClass klass) {
        Intrinsics.checkNotNullParameter(klass, "klass");
        if (klass.isData()) {
            KtNamedDeclarationStub it;
            Object element$iv$iv;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv = klass.getPrimaryConstructorParameters();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator iterator2 = $this$filterTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                element$iv$iv = iterator2.next();
                it = (KtParameter)element$iv$iv;
                boolean bl = false;
                if (!((KtParameter)it).isMutable()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KtParameter it2 = (KtParameter)element$iv;
                boolean bl = false;
                this.report(it2, klass.getName(), it2.getName());
            }
            $this$filter$iv = klass.getProperties();
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            Iterator bl = $this$filterTo$iv$iv.iterator();
            while (bl.hasNext()) {
                element$iv$iv = bl.next();
                it = (KtProperty)element$iv$iv;
                boolean bl2 = false;
                if (!((KtProperty)it).isVar()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$forEach$iv = (List)destination$iv$iv;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KtProperty it3 = (KtProperty)element$iv;
                boolean bl3 = false;
                this.report(it3, klass.getName(), it3.getName());
            }
        }
        super.visitClass(klass);
    }

    private final void report(PsiElement element, String className, String propertyName) {
        this.report(new CodeSmell(this.getIssue(), Entity.Companion.from$default(Entity.Companion, element, 0, 2, null), "The data class " + className + " contains a mutable property. The offending property is called " + propertyName, null, null, 24, null));
    }

    public DataClassShouldBeImmutable() {
        this((Config)null, 1, (DefaultConstructorMarker)null);
    }
}

