/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.psi.KtContainerNodeForControlStructureBody;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002J\u000e\u0010\u0011\u001a\u00020\u000f*\u0004\u0018\u00010\u0012H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0013"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/CollapsibleIfStatements;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitIfExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "isNotElseIfOrElse", "", "hasOneKtIfExpression", "isLoneIfExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "detekt-rules-style"})
@SourceDebugExtension(value={"SMAP\nCollapsibleIfStatements.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CollapsibleIfStatements.kt\nio/gitlab/arturbosch/detekt/rules/style/CollapsibleIfStatements\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,62:1\n158#2:63\n*S KotlinDebug\n*F\n+ 1 CollapsibleIfStatements.kt\nio/gitlab/arturbosch/detekt/rules/style/CollapsibleIfStatements\n*L\n58#1:63\n*E\n"})
public final class CollapsibleIfStatements
extends Rule {
    @NotNull
    private final Issue issue;

    public CollapsibleIfStatements(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        this.issue = new Issue("CollapsibleIfStatements", Severity.Style, "Two if statements which could be collapsed were detected. These statements can be merged to improve readability.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ CollapsibleIfStatements(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    @Override
    public void visitIfExpression(@NotNull KtIfExpression expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        if (this.isNotElseIfOrElse(expression2) && this.hasOneKtIfExpression(expression2)) {
            this.report(new CodeSmell(this.getIssue(), Entity.Companion.from$default(Entity.Companion, expression2, 0, 2, null), this.getIssue().getDescription(), null, null, 24, null));
        }
        super.visitIfExpression(expression2);
    }

    private final boolean isNotElseIfOrElse(KtIfExpression expression2) {
        return expression2.getElse() == null && !(expression2.getParent() instanceof KtContainerNodeForControlStructureBody);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final boolean hasOneKtIfExpression(KtIfExpression expression2) {
        KtExpression ktExpression;
        KtExpression[] ktExpressionArray = expression2.getThen();
        if (ktExpressionArray != null) {
            PsiElement $this$getChildrenOfType$iv = (PsiElement)ktExpressionArray;
            boolean $i$f$getChildrenOfType = false;
            PsiElement[] psiElementArray = PsiTreeUtil.getChildrenOfType((PsiElement)$this$getChildrenOfType$iv, KtExpression.class);
            if (psiElementArray == null) {
                psiElementArray = new KtExpression[0];
            }
            if ((ktExpressionArray = (KtExpression[])psiElementArray) != null) {
                ktExpression = ArraysKt.singleOrNull(ktExpressionArray);
                return this.isLoneIfExpression(ktExpression);
            }
        }
        ktExpression = null;
        return this.isLoneIfExpression(ktExpression);
    }

    private final boolean isLoneIfExpression(KtExpression $this$isLoneIfExpression) {
        return $this$isLoneIfExpression instanceof KtIfExpression && ((KtIfExpression)$this$isLoneIfExpression).getElse() == null;
    }

    public CollapsibleIfStatements() {
        this((Config)null, 1, (DefaultConstructorMarker)null);
    }
}

