/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.github.detekt.psi.KtFilesKt;
import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Location;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.SourceLocation;
import io.gitlab.arturbosch.detekt.api.TextLocation;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadOnlyProperty;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0017H\u0016J\u001a\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0019H\u0002J\f\u0010\u001b\u001a\u00020\u000b*\u00020\u0019H\u0002J\f\u0010\u001c\u001a\u00020\u000b*\u00020\u0019H\u0002J\f\u0010\u001d\u001a\u00020\u001e*\u00020\u0019H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR!\u0010\n\u001a\u00020\u000b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\u0011\u0012\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001f"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/CascadingCallWrapping;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "includeElvis", "", "getIncludeElvis$annotations", "()V", "getIncludeElvis", "()Z", "includeElvis$delegate", "Lkotlin/properties/ReadOnlyProperty;", "visitQualifiedExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;", "visitBinaryExpression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "checkExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "callExpression", "containsNewline", "receiverContainsNewline", "toErrorReportEntity", "Lio/gitlab/arturbosch/detekt/api/Entity;", "detekt-rules-style"})
@SourceDebugExtension(value={"SMAP\nCascadingCallWrapping.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CascadingCallWrapping.kt\nio/gitlab/arturbosch/detekt/rules/style/CascadingCallWrapping\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,132:1\n1#2:133\n1755#3,3:134\n*S KotlinDebug\n*F\n+ 1 CascadingCallWrapping.kt\nio/gitlab/arturbosch/detekt/rules/style/CascadingCallWrapping\n*L\n98#1:134,3\n*E\n"})
public final class CascadingCallWrapping
extends Rule {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty includeElvis$delegate;

    public CascadingCallWrapping(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        String string2 = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue(string2, "getSimpleName(...)");
        this.issue = new Issue(string2, Severity.Style, "If a chained call is wrapped to a new line, subsequent chained calls should be as well.", Debt.Companion.getFIVE_MINS());
        this.includeElvis$delegate = ConfigPropertyKt.config(true);
    }

    public /* synthetic */ CascadingCallWrapping(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final boolean getIncludeElvis() {
        return (Boolean)this.includeElvis$delegate.getValue(this, $$delegatedProperties[0]);
    }

    @Configuration(description="require trailing elvis expressions to be wrapped on a new line")
    private static /* synthetic */ void getIncludeElvis$annotations() {
    }

    @Override
    public void visitQualifiedExpression(@NotNull KtQualifiedExpression expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        super.visitQualifiedExpression(expression2);
        this.checkExpression(expression2, expression2.getSelectorExpression());
    }

    @Override
    public void visitBinaryExpression(@NotNull KtBinaryExpression expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        super.visitBinaryExpression(expression2);
        if (this.getIncludeElvis() && Intrinsics.areEqual(expression2.getOperationToken(), KtTokens.ELVIS)) {
            this.checkExpression(expression2, expression2.getRight());
        }
    }

    private final void checkExpression(KtExpression expression2, KtExpression callExpression) {
        if (!this.containsNewline(expression2) && this.receiverContainsNewline(expression2)) {
            String string2;
            String string3;
            Object object = callExpression;
            if (object != null && (object = object.getText()) != null) {
                Object it = object;
                boolean bl = false;
                string3 = " `" + (String)it + '`';
            } else {
                string3 = string2 = null;
            }
            if (string3 == null) {
                string2 = "";
            }
            String callTextOrEmpty = string2;
            this.report(new CodeSmell(this.getIssue(), this.toErrorReportEntity(expression2), "Chained call" + callTextOrEmpty + " should be wrapped to a new line since preceding calls were.", null, null, 24, null));
        }
    }

    private final boolean containsNewline(KtExpression $this$containsNewline) {
        boolean bl;
        block11: {
            KtExpression lhs = null;
            KtExpression rhs = null;
            KtExpression ktExpression = $this$containsNewline;
            if (ktExpression instanceof KtQualifiedExpression) {
                lhs = ((KtQualifiedExpression)$this$containsNewline).getReceiverExpression();
                KtExpression ktExpression2 = ((KtQualifiedExpression)$this$containsNewline).getSelectorExpression();
                if (ktExpression2 == null) {
                    return false;
                }
                rhs = ktExpression2;
            } else if (ktExpression instanceof KtBinaryExpression) {
                if (!Intrinsics.areEqual(((KtBinaryExpression)$this$containsNewline).getOperationToken(), KtTokens.ELVIS)) {
                    return false;
                }
                KtExpression ktExpression3 = ((KtBinaryExpression)$this$containsNewline).getLeft();
                if (ktExpression3 == null) {
                    return false;
                }
                lhs = ktExpression3;
                KtExpression ktExpression4 = ((KtBinaryExpression)$this$containsNewline).getRight();
                if (ktExpression4 == null) {
                    return false;
                }
                rhs = ktExpression4;
            } else {
                return false;
            }
            int receiverEnd = lhs.getStartOffsetInParent() + lhs.getTextLength();
            int selectorStart = rhs.getStartOffsetInParent();
            Iterable $this$any$iv = RangesKt.until(receiverEnd, selectorStart);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                Iterator iterator2 = $this$any$iv.iterator();
                while (iterator2.hasNext()) {
                    int element$iv;
                    int it = element$iv = ((IntIterator)iterator2).nextInt();
                    boolean bl2 = false;
                    if (!($this$containsNewline.getText().charAt(it) == '\n')) continue;
                    bl = true;
                    break block11;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean receiverContainsNewline(KtExpression $this$receiverContainsNewline) {
        boolean bl;
        KtExpression lhs;
        KtExpression ktExpression;
        KtExpression ktExpression2 = $this$receiverContainsNewline;
        if (ktExpression2 instanceof KtQualifiedExpression) {
            ktExpression = ((KtQualifiedExpression)$this$receiverContainsNewline).getReceiverExpression();
        } else if (ktExpression2 instanceof KtBinaryExpression) {
            ktExpression = ((KtBinaryExpression)$this$receiverContainsNewline).getLeft();
            if (ktExpression == null) {
                return false;
            }
        } else {
            return false;
        }
        ktExpression2 = lhs = ktExpression;
        if (ktExpression2 instanceof KtQualifiedExpression) {
            bl = this.containsNewline(lhs);
        } else if (ktExpression2 instanceof KtUnaryExpression) {
            KtExpression ktExpression3 = ((KtUnaryExpression)lhs).getBaseExpression();
            KtQualifiedExpression ktQualifiedExpression = ktExpression3 instanceof KtQualifiedExpression ? (KtQualifiedExpression)ktExpression3 : null;
            bl = ktQualifiedExpression != null ? this.containsNewline(ktQualifiedExpression) : false;
        } else {
            bl = false;
        }
        return bl;
    }

    private final Entity toErrorReportEntity(KtExpression $this$toErrorReportEntity) {
        Entity entity;
        KtExpression ktExpression = $this$toErrorReportEntity;
        if (ktExpression instanceof KtQualifiedExpression) {
            KtExpression ktExpression2 = ((KtQualifiedExpression)$this$toErrorReportEntity).getSelectorExpression();
            if (ktExpression2 == null) {
                ktExpression2 = $this$toErrorReportEntity;
            }
            entity = Entity.Companion.from$default(Entity.Companion, ktExpression2, 0, 2, null);
        } else if (ktExpression instanceof KtBinaryExpression) {
            KtExpression ktExpression3 = ((KtBinaryExpression)$this$toErrorReportEntity).getRight();
            if (ktExpression3 == null) {
                return Entity.Companion.from$default(Entity.Companion, $this$toErrorReportEntity, 0, 2, null);
            }
            KtExpression rhs = ktExpression3;
            KtOperationReferenceExpression ktOperationReferenceExpression = ((KtBinaryExpression)$this$toErrorReportEntity).getOperationReference();
            Intrinsics.checkNotNullExpressionValue(ktOperationReferenceExpression, "getOperationReference(...)");
            SourceLocation operationSourceLocation = Location.Companion.from$default(Location.Companion, ktOperationReferenceExpression, 0, 2, null).getSource();
            SourceLocation rhsSourceLocation = Location.Companion.from$default(Location.Companion, rhs, 0, 2, null).getEndSource();
            KtOperationReferenceExpression ktOperationReferenceExpression2 = ((KtBinaryExpression)$this$toErrorReportEntity).getOperationReference();
            Intrinsics.checkNotNullExpressionValue(ktOperationReferenceExpression2, "getOperationReference(...)");
            TextLocation textLocation = new TextLocation(PsiUtilsKt.getStartOffset(ktOperationReferenceExpression2), PsiUtilsKt.getEndOffset(rhs));
            PsiElement psiElement = $this$toErrorReportEntity;
            PsiFile psiFile = ((KtBinaryExpression)$this$toErrorReportEntity).getContainingFile();
            Intrinsics.checkNotNullExpressionValue(psiFile, "getContainingFile(...)");
            entity = Entity.Companion.from(psiElement, new Location(operationSourceLocation, rhsSourceLocation, textLocation, KtFilesKt.toFilePath(psiFile)));
        } else {
            entity = Entity.Companion.from$default(Entity.Companion, $this$toErrorReportEntity, 0, 2, null);
        }
        return entity;
    }

    public CascadingCallWrapping() {
        this((Config)null, 1, (DefaultConstructorMarker)null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(CascadingCallWrapping.class, "includeElvis", "getIncludeElvis()Z", 0))};
        $$delegatedProperties = kPropertyArray;
    }
}

