/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.performance;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi2ir.KotlinUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0013H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lio/gitlab/arturbosch/detekt/rules/performance/ForEachOnRange;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "rangeOperators", "", "", "visitCallExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "isRangeOperatorsChainCall", "", "Lorg/jetbrains/kotlin/psi/KtElement;", "isRangeOperator", "detekt-rules-performance"})
public final class ForEachOnRange
extends Rule {
    @NotNull
    private final Issue issue;
    @NotNull
    private final Set<String> rangeOperators;

    public ForEachOnRange(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        this.issue = new Issue("ForEachOnRange", Severity.Performance, "Using the forEach method on ranges has a heavy performance cost. Prefer using simple for loops.", Debt.Companion.getFIVE_MINS());
        String[] stringArray = new String[]{"..", "rangeTo", "downTo", "until", "..<"};
        this.rangeOperators = SetsKt.setOf(stringArray);
    }

    public /* synthetic */ ForEachOnRange(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    @Override
    public void visitCallExpression(@NotNull KtCallExpression expression2) {
        block2: {
            KtElement forExpression;
            Intrinsics.checkNotNullParameter(expression2, "expression");
            super.visitCallExpression(expression2);
            KtSimpleNameExpression ktSimpleNameExpression = KtPsiUtilKt.getCallNameExpression(expression2);
            if (ktSimpleNameExpression == null) break block2;
            KtSimpleNameExpression it = ktSimpleNameExpression;
            boolean bl = false;
            if (!it.textMatches("forEach")) {
                return;
            }
            KtExpression ktExpression = KtPsiUtilKt.getReceiverExpression(it);
            KtElement ktElement = forExpression = ktExpression != null ? KotlinUtilsKt.deparenthesize(ktExpression) : null;
            if (forExpression != null && this.isRangeOperatorsChainCall(forExpression)) {
                this.report(new CodeSmell(this.getIssue(), Entity.Companion.from$default(Entity.Companion, forExpression, 0, 2, null), this.getIssue().getDescription(), null, null, 24, null));
            }
        }
    }

    private final boolean isRangeOperatorsChainCall(KtElement expression2) {
        boolean bl;
        if (this.isRangeOperator(expression2)) {
            bl = true;
        } else {
            KtElement ktElement = expression2;
            if (ktElement instanceof KtBinaryExpression) {
                KtElement ktElement2 = ((KtBinaryExpression)expression2).getLeft();
                if (ktElement2 == null || (ktElement2 = KotlinUtilsKt.deparenthesize(ktElement2)) == null) {
                    return false;
                }
                KtElement receiverExpression = ktElement2;
                bl = this.isRangeOperatorsChainCall(receiverExpression);
            } else if (ktElement instanceof KtDotQualifiedExpression) {
                KtElement receiverExpression = KotlinUtilsKt.deparenthesize(((KtDotQualifiedExpression)expression2).getReceiverExpression());
                bl = this.isRangeOperatorsChainCall(receiverExpression);
            } else {
                bl = false;
            }
        }
        return bl;
    }

    private final boolean isRangeOperator(KtElement expression2) {
        KtExpression ktExpression;
        KtExpression ktExpression2;
        KtElement ktElement = expression2;
        String string2 = ktElement instanceof KtBinaryExpression ? ((KtBinaryExpression)expression2).getOperationReference().getText() : (ktElement instanceof KtDotQualifiedExpression ? ((ktExpression2 = (ktExpression = ((KtDotQualifiedExpression)expression2).getSelectorExpression()) instanceof KtCallExpression ? (KtCallExpression)ktExpression : null) != null && (ktExpression2 = ((KtCallExpression)ktExpression2).getCalleeExpression()) != null ? ktExpression2.getText() : null) : null);
        String operator = string2;
        return CollectionsKt.contains((Iterable)this.rangeOperators, operator);
    }

    public ForEachOnRange() {
        this((Config)null, 1, (DefaultConstructorMarker)null);
    }
}

