/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.naming;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.RequiresTypeResolution;
import io.gitlab.arturbosch.detekt.rules.KtLambdaExpressionKt;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;

@RequiresTypeResolution
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\f\u0010\u001a\u001a\u00020\u001b*\u00020\u0019H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001c"}, d2={"Lio/gitlab/arturbosch/detekt/rules/naming/NoNameShadowing;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitProperty", "", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "visitDestructuringDeclarationEntry", "multiDeclarationEntry", "Lorg/jetbrains/kotlin/psi/KtDestructuringDeclarationEntry;", "visitParameter", "parameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "checkNameShadowing", "declaration", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "visitLambdaExpression", "lambdaExpression", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "hasParentImplicitParameterLambda", "", "detekt-rules-naming"})
@SourceDebugExtension(value={"SMAP\nNoNameShadowing.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NoNameShadowing.kt\nio/gitlab/arturbosch/detekt/rules/naming/NoNameShadowing\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,102:1\n1755#2,3:103\n142#3:106\n*S KotlinDebug\n*F\n+ 1 NoNameShadowing.kt\nio/gitlab/arturbosch/detekt/rules/naming/NoNameShadowing\n*L\n78#1:103,3\n100#1:106\n*E\n"})
public final class NoNameShadowing
extends Rule {
    @NotNull
    private final Issue issue;

    public NoNameShadowing(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        String string2 = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue(string2, "getSimpleName(...)");
        this.issue = new Issue(string2, Severity.Defect, "Disallow shadowing variable declarations.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ NoNameShadowing(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    @Override
    public void visitProperty(@NotNull KtProperty property) {
        Intrinsics.checkNotNullParameter(property, "property");
        super.visitProperty(property);
        this.checkNameShadowing(property);
    }

    @Override
    public void visitDestructuringDeclarationEntry(@NotNull KtDestructuringDeclarationEntry multiDeclarationEntry) {
        Intrinsics.checkNotNullParameter(multiDeclarationEntry, "multiDeclarationEntry");
        super.visitDestructuringDeclarationEntry(multiDeclarationEntry);
        this.checkNameShadowing(multiDeclarationEntry);
    }

    @Override
    public void visitParameter(@NotNull KtParameter parameter) {
        Intrinsics.checkNotNullParameter(parameter, "parameter");
        super.visitParameter(parameter);
        this.checkNameShadowing(parameter);
    }

    private final void checkNameShadowing(KtNamedDeclaration declaration) {
        boolean bl;
        PsiElement nameIdentifier;
        block5: {
            PsiElement psiElement = declaration.getNameIdentifier();
            if (psiElement == null) {
                return;
            }
            nameIdentifier = psiElement;
            Iterable $this$any$iv = this.getBindingContext().getDiagnostics().forElement(declaration);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Diagnostic it = (Diagnostic)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual(it.getFactory(), Errors.NAME_SHADOWING)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (bl) {
            this.report(new CodeSmell(this.getIssue(), Entity.Companion.from$default(Entity.Companion, nameIdentifier, 0, 2, null), "Name shadowed: " + nameIdentifier.getText(), null, null, 24, null));
        }
    }

    @Override
    public void visitLambdaExpression(@NotNull KtLambdaExpression lambdaExpression) {
        Intrinsics.checkNotNullParameter(lambdaExpression, "lambdaExpression");
        super.visitLambdaExpression(lambdaExpression);
        ValueParameterDescriptor valueParameterDescriptor = KtLambdaExpressionKt.implicitParameter(lambdaExpression, this.getBindingContext());
        if (valueParameterDescriptor == null) {
            return;
        }
        ValueParameterDescriptor implicitParameter = valueParameterDescriptor;
        if (KtLambdaExpressionKt.hasImplicitParameterReference(lambdaExpression, implicitParameter, this.getBindingContext()) && this.hasParentImplicitParameterLambda(lambdaExpression)) {
            this.report(new CodeSmell(this.getIssue(), Entity.Companion.from$default(Entity.Companion, lambdaExpression, 0, 2, null), "Name shadowed: implicit lambda parameter 'it'", null, null, 24, null));
        }
    }

    private final boolean hasParentImplicitParameterLambda(KtLambdaExpression $this$hasParentImplicitParameterLambda) {
        PsiElement $this$getStrictParentOfType$iv = $this$hasParentImplicitParameterLambda;
        boolean $i$f$getStrictParentOfType = false;
        KtLambdaExpression ktLambdaExpression = PsiTreeUtil.getParentOfType($this$getStrictParentOfType$iv, KtLambdaExpression.class, true);
        return (ktLambdaExpression != null ? KtLambdaExpressionKt.implicitParameter(ktLambdaExpression, this.getBindingContext()) : null) != null;
    }

    public NoNameShadowing() {
        this((Config)null, 1, (DefaultConstructorMarker)null);
    }
}

