/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.naming;

import io.github.detekt.psi.KtFilesKt;
import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.rules.naming.MatchingDeclarationName$visitKtFile$;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR!\u0010\n\u001a\u00020\u000b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\u0011\u0012\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000fR'\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00138BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0018\u0010\u0011\u0012\u0004\b\u0015\u0010\r\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001e"}, d2={"Lio/gitlab/arturbosch/detekt/rules/naming/MatchingDeclarationName;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "mustBeFirst", "", "getMustBeFirst$annotations", "()V", "getMustBeFirst", "()Z", "mustBeFirst$delegate", "Lkotlin/properties/ReadOnlyProperty;", "multiplatformTargets", "", "", "getMultiplatformTargets$annotations", "getMultiplatformTargets", "()Ljava/util/List;", "multiplatformTargets$delegate", "visitKtFile", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "Companion", "detekt-rules-naming"})
@SourceDebugExtension(value={"SMAP\nMatchingDeclarationName.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MatchingDeclarationName.kt\nio/gitlab/arturbosch/detekt/rules/naming/MatchingDeclarationName\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,114:1\n477#2:115\n808#3,11:116\n1734#3,3:127\n*S KotlinDebug\n*F\n+ 1 MatchingDeclarationName.kt\nio/gitlab/arturbosch/detekt/rules/naming/MatchingDeclarationName\n*L\n70#1:115\n78#1:116,11\n78#1:127,3\n*E\n"})
public final class MatchingDeclarationName
extends Rule {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty mustBeFirst$delegate;
    @NotNull
    private final ReadOnlyProperty multiplatformTargets$delegate;
    @NotNull
    private static final List<String> COMMON_KOTLIN_KMP_PLATFORM_TARGET_SUFFIXES;

    public MatchingDeclarationName(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        String string2 = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue(string2, "getSimpleName(...)");
        this.issue = new Issue(string2, Severity.Style, "If a source file contains only a single non-private top-level class or object, the file name should reflect the case-sensitive name plus the .kt extension.", Debt.Companion.getFIVE_MINS());
        this.mustBeFirst$delegate = ConfigPropertyKt.config(true);
        this.multiplatformTargets$delegate = ConfigPropertyKt.config(COMMON_KOTLIN_KMP_PLATFORM_TARGET_SUFFIXES);
    }

    public /* synthetic */ MatchingDeclarationName(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final boolean getMustBeFirst() {
        return (Boolean)this.mustBeFirst$delegate.getValue(this, $$delegatedProperties[0]);
    }

    @Configuration(description="name should only be checked if the file starts with a class or object")
    private static /* synthetic */ void getMustBeFirst$annotations() {
    }

    private final List<String> getMultiplatformTargets() {
        return (List)this.multiplatformTargets$delegate.getValue(this, $$delegatedProperties[1]);
    }

    @Configuration(description="kotlin multiplatform targets, used to allow file names like `MyClass.jvm.kt`")
    private static /* synthetic */ void getMultiplatformTargets$annotations() {
    }

    @Override
    public void visitKtFile(@NotNull KtFile file2) {
        String filename;
        KtClassOrObject declaration;
        String declarationName;
        Intrinsics.checkNotNullParameter(file2, "file");
        Sequence $this$filterIsInstance$iv = CollectionsKt.asSequence((Iterable)file2.getDeclarations());
        boolean $i$f$filterIsInstance = false;
        Sequence sequence2 = SequencesKt.filter($this$filterIsInstance$iv, visitKtFile$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull(sequence2, "null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        List<KtClassOrObject> declarations2 = SequencesKt.toList(SequencesKt.filterNot(sequence2, MatchingDeclarationName::visitKtFile$lambda$0));
        if (declarations2.size() == 1 && MatchingDeclarationName.visitKtFile$matchesFirstClassOrObjectCondition(this, declarations2, file2) && !Intrinsics.areEqual(declarationName = (declaration = CollectionsKt.first(declarations2)).getName(), filename = KtFilesKt.fileNameWithoutSuffix(file2, this.getMultiplatformTargets())) && MatchingDeclarationName.visitKtFile$hasNoMatchingTypeAlias(file2, filename)) {
            Entity entity = Entity.copy$default(Entity.Companion.atName(declaration), null, null, null, file2, 7, null);
            this.report(new CodeSmell(this.getIssue(), entity, "The file name '" + filename + "' does not match the name of the single top-level declaration '" + declarationName + "'.", null, null, 24, null));
        }
    }

    private static final boolean visitKtFile$lambda$0(KtClassOrObject it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return KtPsiUtilKt.isPrivate(it);
    }

    private static final boolean visitKtFile$matchesFirstClassOrObjectCondition(MatchingDeclarationName this$0, List<? extends KtClassOrObject> declarations2, KtFile $file) {
        return !this$0.getMustBeFirst() || this$0.getMustBeFirst() && CollectionsKt.first(declarations2) == CollectionsKt.first($file.getDeclarations());
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean visitKtFile$hasNoMatchingTypeAlias(KtFile $file, String filename) {
        boolean bl;
        block4: {
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv = $file.getDeclarations();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof KtTypeAlias)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$all$iv = (List)destination$iv$iv;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    KtTypeAlias it = (KtTypeAlias)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual(it.getName(), filename)) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        return bl;
    }

    public MatchingDeclarationName() {
        this((Config)null, 1, (DefaultConstructorMarker)null);
    }

    static {
        Object[] objectArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(MatchingDeclarationName.class, "mustBeFirst", "getMustBeFirst()Z", 0)), Reflection.property1(new PropertyReference1Impl(MatchingDeclarationName.class, "multiplatformTargets", "getMultiplatformTargets()Ljava/util/List;", 0))};
        $$delegatedProperties = objectArray;
        Companion = new Companion(null);
        objectArray = new String[]{"ios", "android", "js", "jvm", "native", "iosArm64", "iosX64", "macosX64", "mingwX64", "linuxX64"};
        COMMON_KOTLIN_KMP_PLATFORM_TARGET_SUFFIXES = CollectionsKt.listOf(objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lio/gitlab/arturbosch/detekt/rules/naming/MatchingDeclarationName$Companion;", "", "<init>", "()V", "COMMON_KOTLIN_KMP_PLATFORM_TARGET_SUFFIXES", "", "", "detekt-rules-naming"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

