/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.naming;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.rules.naming.LambdaParameterNaming;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0012\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017*\u00020\u0019H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR!\u0010\n\u001a\u00020\u000b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\u0011\u0012\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lio/gitlab/arturbosch/detekt/rules/naming/LambdaParameterNaming;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "parameterPattern", "Lkotlin/text/Regex;", "getParameterPattern$annotations", "()V", "getParameterPattern", "()Lkotlin/text/Regex;", "parameterPattern$delegate", "Lkotlin/properties/ReadOnlyProperty;", "visitLambdaExpression", "", "lambdaExpression", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "getNamedDeclarations", "", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "Lorg/jetbrains/kotlin/psi/KtParameter;", "detekt-rules-naming"})
@SourceDebugExtension(value={"SMAP\nLambdaParameterNaming.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LambdaParameterNaming.kt\nio/gitlab/arturbosch/detekt/rules/naming/LambdaParameterNaming\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,54:1\n1368#2:55\n1454#2,5:56\n1611#2,9:61\n1863#2:70\n1864#2:72\n1620#2:73\n1863#2,2:74\n1#3:71\n*S KotlinDebug\n*F\n+ 1 LambdaParameterNaming.kt\nio/gitlab/arturbosch/detekt/rules/naming/LambdaParameterNaming\n*L\n34#1:55\n34#1:56,5\n35#1:61,9\n35#1:70\n35#1:72\n35#1:73\n36#1:74,2\n35#1:71\n*E\n"})
public final class LambdaParameterNaming
extends Rule {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty parameterPattern$delegate;

    public LambdaParameterNaming(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        String string2 = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue(string2, "getSimpleName(...)");
        this.issue = new Issue(string2, Severity.Style, "Lambda parameter names should follow the naming convention set in the projects configuration.", Debt.Companion.getFIVE_MINS());
        this.parameterPattern$delegate = ConfigPropertyKt.config("[a-z][A-Za-z0-9]*|_", parameterPattern.2.INSTANCE);
    }

    public /* synthetic */ LambdaParameterNaming(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final Regex getParameterPattern() {
        return (Regex)this.parameterPattern$delegate.getValue(this, $$delegatedProperties[0]);
    }

    @Configuration(description="naming pattern")
    private static /* synthetic */ void getParameterPattern$annotations() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitLambdaExpression(@NotNull KtLambdaExpression lambdaExpression) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(lambdaExpression, "lambdaExpression");
        super.visitLambdaExpression(lambdaExpression);
        List<KtParameter> list = lambdaExpression.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list, "getValueParameters(...)");
        Iterable $this$flatMap$iv = list;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            KtParameter it = (KtParameter)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(it);
            Iterable list$iv$iv = this.getNamedDeclarations(it);
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$flatMapTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Object object = $this$forEach$iv$iv$iv.iterator();
        while (object.hasNext()) {
            PsiElement it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = object.next();
            boolean bl = false;
            KtNamedDeclaration it = (KtNamedDeclaration)element$iv$iv;
            boolean bl2 = false;
            if (it.getNameIdentifier() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            PsiElement it = (PsiElement)element$iv;
            boolean bl = false;
            String identifier = it.getText();
            Intrinsics.checkNotNull(identifier);
            object = identifier;
            if (this.getParameterPattern().matches((CharSequence)object)) continue;
            this.report(new CodeSmell(this.getIssue(), Entity.Companion.from$default(Entity.Companion, it, 0, 2, null), "Lambda parameter names should match the pattern: " + this.getParameterPattern(), null, null, 24, null));
        }
    }

    private final List<KtNamedDeclaration> getNamedDeclarations(KtParameter $this$getNamedDeclarations) {
        Object object = $this$getNamedDeclarations.getDestructuringDeclaration();
        if (object == null || (object = ((KtDestructuringDeclaration)object).getEntries()) == null) {
            object = CollectionsKt.listOf($this$getNamedDeclarations);
        }
        return object;
    }

    public LambdaParameterNaming() {
        this((Config)null, 1, (DefaultConstructorMarker)null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(LambdaParameterNaming.class, "parameterPattern", "getParameterPattern()Lkotlin/text/Regex;", 0))};
        $$delegatedProperties = kPropertyArray;
    }
}

