/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.naming;

import io.github.detekt.psi.KtFilesKt;
import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPackageDirective;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0014\u0010 \u001a\u00020\u001d*\u00020!2\u0006\u0010\"\u001a\u00020\bH\u0002J\u0018\u0010#\u001a\u00020\b\"\u0004\b\u0000\u0010$*\b\u0012\u0004\u0012\u0002H$0%H\u0002J\u001a\u0010&\u001a\b\u0012\u0004\u0012\u00020\b0'*\u00020(2\u0006\u0010)\u001a\u00020(H\u0002R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR!\u0010\u000f\u001a\u00020\b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0014\u0010\u0015\u0012\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013R!\u0010\u0016\u001a\u00020\u00178BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u001b\u0010\u0015\u0012\u0004\b\u0018\u0010\u0011\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006*"}, d2={"Lio/gitlab/arturbosch/detekt/rules/naming/InvalidPackageDeclaration;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "defaultRuleIdAliases", "", "", "getDefaultRuleIdAliases", "()Ljava/util/Set;", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "rootPackage", "getRootPackage$annotations", "()V", "getRootPackage", "()Ljava/lang/String;", "rootPackage$delegate", "Lkotlin/properties/ReadOnlyProperty;", "requireRootInDeclaration", "", "getRequireRootInDeclaration$annotations", "getRequireRootInDeclaration", "()Z", "requireRootInDeclaration$delegate", "visitPackageDirective", "", "directive", "Lorg/jetbrains/kotlin/psi/KtPackageDirective;", "reportInvalidPackageDeclaration", "Lorg/jetbrains/kotlin/psi/KtElement;", "message", "toNormalizedForm", "T", "", "withoutPrefix", "", "Lorg/jetbrains/kotlin/name/FqName;", "prefix", "detekt-rules-naming"})
@SourceDebugExtension(value={"SMAP\nInvalidPackageDeclaration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InvalidPackageDeclaration.kt\nio/gitlab/arturbosch/detekt/rules/naming/InvalidPackageDeclaration\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,74:1\n1557#2:75\n1628#2,3:76\n*S KotlinDebug\n*F\n+ 1 InvalidPackageDeclaration.kt\nio/gitlab/arturbosch/detekt/rules/naming/InvalidPackageDeclaration\n*L\n71#1:75\n71#1:76,3\n*E\n"})
public final class InvalidPackageDeclaration
extends Rule {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Set<String> defaultRuleIdAliases;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty rootPackage$delegate;
    @NotNull
    private final ReadOnlyProperty requireRootInDeclaration$delegate;

    public InvalidPackageDeclaration(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        this.defaultRuleIdAliases = SetsKt.setOf("PackageDirectoryMismatch");
        String string2 = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue(string2, "getSimpleName(...)");
        this.issue = new Issue(string2, Severity.Maintainability, "Kotlin source files should be stored in the directory corresponding to its package statement.", Debt.Companion.getFIVE_MINS());
        this.rootPackage$delegate = ConfigPropertyKt.config("");
        this.requireRootInDeclaration$delegate = ConfigPropertyKt.config(false);
    }

    public /* synthetic */ InvalidPackageDeclaration(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @Override
    @NotNull
    public Set<String> getDefaultRuleIdAliases() {
        return this.defaultRuleIdAliases;
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final String getRootPackage() {
        return (String)this.rootPackage$delegate.getValue(this, $$delegatedProperties[0]);
    }

    @Configuration(description="if specified this part of the package structure is ignored")
    private static /* synthetic */ void getRootPackage$annotations() {
    }

    private final boolean getRequireRootInDeclaration() {
        return (Boolean)this.requireRootInDeclaration$delegate.getValue(this, $$delegatedProperties[1]);
    }

    @Configuration(description="requires the declaration to start with the specified rootPackage")
    private static /* synthetic */ void getRequireRootInDeclaration$annotations() {
    }

    @Override
    public void visitPackageDirective(@NotNull KtPackageDirective directive) {
        Intrinsics.checkNotNullParameter(directive, "directive");
        super.visitPackageDirective(directive);
        FqName fqName = directive.getFqName();
        Intrinsics.checkNotNullExpressionValue(fqName, "getFqName(...)");
        FqName packageName2 = fqName;
        if (!packageName2.isRoot()) {
            boolean isInRootPackage;
            FqName rootPackageName = new FqName(this.getRootPackage());
            if (this.getRequireRootInDeclaration() && !packageName2.startsWith(rootPackageName)) {
                this.reportInvalidPackageDeclaration(directive, "The package declaration is missing the root package");
                return;
            }
            KtFile ktFile = directive.getContainingKtFile();
            Intrinsics.checkNotNullExpressionValue(ktFile, "getContainingKtFile(...)");
            Path path = KtFilesKt.absolutePath(ktFile).getParent();
            Intrinsics.checkNotNullExpressionValue(path, "getParent(...)");
            String normalizedFilePath = this.toNormalizedForm(path);
            String expectedPath = this.toNormalizedForm((Iterable)this.withoutPrefix(packageName2, rootPackageName));
            boolean bl = isInRootPackage = ((CharSequence)expectedPath).length() == 0;
            if (!isInRootPackage && !StringsKt.endsWith$default(normalizedFilePath, '|' + expectedPath, false, 2, null)) {
                this.reportInvalidPackageDeclaration(directive, "The package declaration does not match the actual file location.");
            }
        }
    }

    private final void reportInvalidPackageDeclaration(KtElement $this$reportInvalidPackageDeclaration, String message) {
        this.report(new CodeSmell(this.getIssue(), Entity.Companion.from$default(Entity.Companion, $this$reportInvalidPackageDeclaration, 0, 2, null), message, null, null, 24, null));
    }

    private final <T> String toNormalizedForm(Iterable<? extends T> $this$toNormalizedForm) {
        return CollectionsKt.joinToString$default($this$toNormalizedForm, "|", null, null, 0, null, null, 62, null);
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> withoutPrefix(FqName $this$withoutPrefix, FqName prefix) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        int dropCount = $this$withoutPrefix.startsWith(prefix) ? prefix.pathSegments().size() : 0;
        List<Name> list = $this$withoutPrefix.pathSegments();
        Intrinsics.checkNotNullExpressionValue(list, "pathSegments(...)");
        Iterable iterable = CollectionsKt.drop((Iterable)list, dropCount);
        boolean $i$f$map = false;
        void var6_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void segmentName;
            Name name2 = (Name)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(segmentName.asString());
        }
        return (List)destination$iv$iv;
    }

    public InvalidPackageDeclaration() {
        this((Config)null, 1, (DefaultConstructorMarker)null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(InvalidPackageDeclaration.class, "rootPackage", "getRootPackage()Ljava/lang/String;", 0)), Reflection.property1(new PropertyReference1Impl(InvalidPackageDeclaration.class, "requireRootInDeclaration", "getRequireRootInDeclaration()Z", 0))};
        $$delegatedProperties = kPropertyArray;
    }
}

