/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.naming;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtClassOrObject;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR'\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0011\u0010\u0012\u0012\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0017"}, d2={"Lio/gitlab/arturbosch/detekt/rules/naming/ForbiddenClassName;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "forbiddenName", "", "", "getForbiddenName$annotations", "()V", "getForbiddenName", "()Ljava/util/List;", "forbiddenName$delegate", "Lkotlin/properties/ReadOnlyProperty;", "visitClassOrObject", "", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "detekt-rules-naming"})
@SourceDebugExtension(value={"SMAP\nForbiddenClassName.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ForbiddenClassName.kt\nio/gitlab/arturbosch/detekt/rules/naming/ForbiddenClassName\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,44:1\n774#2:45\n865#2,2:46\n1557#2:48\n1628#2,3:49\n*S KotlinDebug\n*F\n+ 1 ForbiddenClassName.kt\nio/gitlab/arturbosch/detekt/rules/naming/ForbiddenClassName\n*L\n34#1:45\n34#1:46,2\n29#1:48\n29#1:49,3\n*E\n"})
public final class ForbiddenClassName
extends Rule {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty forbiddenName$delegate;

    public ForbiddenClassName(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        String string2 = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue(string2, "getSimpleName(...)");
        this.issue = new Issue(string2, Severity.Style, "Forbidden class name as per configuration detected.", Debt.Companion.getFIVE_MINS());
        this.forbiddenName$delegate = ConfigPropertyKt.config(CollectionsKt.emptyList(), ForbiddenClassName::forbiddenName_delegate$lambda$1);
    }

    public /* synthetic */ ForbiddenClassName(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final List<String> getForbiddenName() {
        return (List)this.forbiddenName$delegate.getValue(this, $$delegatedProperties[0]);
    }

    @Configuration(description="forbidden class names")
    private static /* synthetic */ void getForbiddenName$annotations() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitClassOrObject(@NotNull KtClassOrObject classOrObject) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(classOrObject, "classOrObject");
        String string2 = classOrObject.getName();
        if (string2 == null) {
            return;
        }
        String name2 = string2;
        Iterable $this$filter$iv = this.getForbiddenName();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.contains((CharSequence)name2, it, true)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List forbiddenEntries = (List)destination$iv$iv;
        if (forbiddenEntries.isEmpty()) {
            return;
        }
        String message = "Class name " + name2 + " is forbidden as it contains: " + CollectionsKt.joinToString$default(forbiddenEntries, ", ", null, null, 0, null, null, 62, null);
        this.report(new CodeSmell(this.getIssue(), Entity.Companion.atName(classOrObject), message, null, null, 24, null));
    }

    /*
     * WARNING - void declaration
     */
    private static final List forbiddenName_delegate$lambda$1(List names) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(names, "names");
        Iterable $this$map$iv = names;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(StringsKt.removeSuffix(StringsKt.removePrefix((String)it, (CharSequence)"*"), (CharSequence)"*"));
        }
        return (List)destination$iv$iv;
    }

    public ForbiddenClassName() {
        this((Config)null, 1, (DefaultConstructorMarker)null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(ForbiddenClassName.class, "forbiddenName", "getForbiddenName()Ljava/util/List;", 0))};
        $$delegatedProperties = kPropertyArray;
    }
}

