/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.exceptions;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtCallExpression;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR'\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0011\u0010\u0012\u0012\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0017"}, d2={"Lio/gitlab/arturbosch/detekt/rules/exceptions/ThrowingExceptionsWithoutMessageOrCause;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "exceptions", "", "", "getExceptions$annotations", "()V", "getExceptions", "()Ljava/util/List;", "exceptions$delegate", "Lkotlin/properties/ReadOnlyProperty;", "visitCallExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "detekt-rules-exceptions"})
@SourceDebugExtension(value={"SMAP\nThrowingExceptionsWithoutMessageOrCause.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThrowingExceptionsWithoutMessageOrCause.kt\nio/gitlab/arturbosch/detekt/rules/exceptions/ThrowingExceptionsWithoutMessageOrCause\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,75:1\n1755#2,3:76\n*S KotlinDebug\n*F\n+ 1 ThrowingExceptionsWithoutMessageOrCause.kt\nio/gitlab/arturbosch/detekt/rules/exceptions/ThrowingExceptionsWithoutMessageOrCause\n*L\n70#1:76,3\n*E\n"})
public final class ThrowingExceptionsWithoutMessageOrCause
extends Rule {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty exceptions$delegate;

    public ThrowingExceptionsWithoutMessageOrCause(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        this.issue = new Issue("ThrowingExceptionsWithoutMessageOrCause", Severity.Warning, "A call to the default constructor of an exception was detected. Instead one of the constructor overloads should be called. This allows to provide more meaningful exceptions.", Debt.Companion.getFIVE_MINS());
        String[] stringArray = new String[]{"ArrayIndexOutOfBoundsException", "Exception", "IllegalArgumentException", "IllegalMonitorStateException", "IllegalStateException", "IndexOutOfBoundsException", "NullPointerException", "RuntimeException", "Throwable"};
        this.exceptions$delegate = ConfigPropertyKt.config(CollectionsKt.listOf(stringArray));
    }

    public /* synthetic */ ThrowingExceptionsWithoutMessageOrCause(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final List<String> getExceptions() {
        return (List)this.exceptions$delegate.getValue(this, $$delegatedProperties[0]);
    }

    @Configuration(description="exceptions which should not be thrown without message or cause")
    private static /* synthetic */ void getExceptions$annotations() {
    }

    @Override
    public void visitCallExpression(@NotNull KtCallExpression expression2) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            super.visitCallExpression(expression2);
            Object object = expression2.getCalleeExpression();
            if (object == null || (object = object.getText()) == null) {
                return;
            }
            Object calleeExpressionText = object;
            Iterable $this$any$iv = this.getExceptions();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual(calleeExpressionText, it)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (bl && expression2.getValueArguments().isEmpty()) {
            this.report(new CodeSmell(this.getIssue(), Entity.Companion.from$default(Entity.Companion, expression2, 0, 2, null), this.getIssue().getDescription(), null, null, 24, null));
        }
    }

    public ThrowingExceptionsWithoutMessageOrCause() {
        this((Config)null, 1, (DefaultConstructorMarker)null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(ThrowingExceptionsWithoutMessageOrCause.class, "exceptions", "getExceptions()Ljava/util/List;", 0))};
        $$delegatedProperties = kPropertyArray;
    }
}

