/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.exceptions;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.rules.MethodSignatureKt;
import io.gitlab.arturbosch.detekt.rules.exceptions.ThrowingExceptionInMain$containsThrowExpression$;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtThrowExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0010"}, d2={"Lio/gitlab/arturbosch/detekt/rules/exceptions/ThrowingExceptionInMain;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitNamedFunction", "", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "containsThrowExpression", "", "detekt-rules-exceptions"})
@SourceDebugExtension(value={"SMAP\nThrowingExceptionInMain.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThrowingExceptionInMain.kt\nio/gitlab/arturbosch/detekt/rules/exceptions/ThrowingExceptionInMain\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,44:1\n265#2,2:45\n277#2,10:47\n299#2:57\n*S KotlinDebug\n*F\n+ 1 ThrowingExceptionInMain.kt\nio/gitlab/arturbosch/detekt/rules/exceptions/ThrowingExceptionInMain\n*L\n42#1:45,2\n42#1:47,10\n42#1:57\n*E\n"})
public final class ThrowingExceptionInMain
extends Rule {
    @NotNull
    private final Issue issue;

    public ThrowingExceptionInMain(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        this.issue = new Issue("ThrowingExceptionInMain", Severity.CodeSmell, "The main method should not throw an exception.", Debt.Companion.getTWENTY_MINS());
    }

    public /* synthetic */ ThrowingExceptionInMain(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    @Override
    public void visitNamedFunction(@NotNull KtNamedFunction function2) {
        Intrinsics.checkNotNullParameter(function2, "function");
        if (MethodSignatureKt.isMainFunction(function2) && this.containsThrowExpression(function2)) {
            this.report(new CodeSmell(this.getIssue(), Entity.Companion.atName(function2), this.getIssue().getDescription(), null, null, 24, null));
        }
    }

    private final boolean containsThrowExpression(KtNamedFunction function2) {
        boolean bl;
        KtExpression ktExpression = function2.getBodyExpression();
        if (ktExpression != null) {
            PsiElement $this$anyDescendantOfType_u24default$iv = ktExpression;
            Function1 predicate$iv = containsThrowExpression$$inlined$anyDescendantOfType$default$1.INSTANCE;
            boolean $i$f$anyDescendantOfType = false;
            PsiElement $this$findDescendantOfType$iv$iv = $this$anyDescendantOfType_u24default$iv;
            boolean $i$f$findDescendantOfType = false;
            PsiElement $this$findDescendantOfType$iv$iv$iv = $this$findDescendantOfType$iv$iv;
            boolean $i$f$findDescendantOfType2 = false;
            PsiUtilsKt.checkDecompiledText($this$findDescendantOfType$iv$iv$iv);
            Ref.ObjectRef result$iv$iv$iv = new Ref.ObjectRef();
            $this$findDescendantOfType$iv$iv$iv.accept(new PsiRecursiveElementWalkingVisitor(predicate$iv, result$iv$iv$iv){
                final /* synthetic */ Function1 $predicate;
                final /* synthetic */ Ref.ObjectRef $result;
                {
                    this.$predicate = $predicate;
                    this.$result = $result;
                }

                public void visitElement(PsiElement element) {
                    Intrinsics.checkNotNullParameter(element, "element");
                    if (element instanceof KtThrowExpression && ((Boolean)this.$predicate.invoke(element)).booleanValue()) {
                        this.$result.element = element;
                        this.stopWalking();
                        return;
                    }
                    PsiElement it = element;
                    boolean bl = false;
                    super.visitElement(element);
                }
            });
            bl = (PsiElement)result$iv$iv$iv.element != null;
        } else {
            bl = false;
        }
        return bl;
    }

    public ThrowingExceptionInMain() {
        this((Config)null, 1, (DefaultConstructorMarker)null);
    }
}

