/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.exceptions;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.psi.KtCatchClause;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtThrowExpression;
import org.jetbrains.kotlin.psi.KtTryExpression;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Lio/gitlab/arturbosch/detekt/rules/exceptions/RethrowCaughtException;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitTryExpression", "", "tryExpr", "Lorg/jetbrains/kotlin/psi/KtTryExpression;", "violatingThrowExpressionFrom", "Lorg/jetbrains/kotlin/psi/KtThrowExpression;", "catchClause", "Lorg/jetbrains/kotlin/psi/KtCatchClause;", "detekt-rules-exceptions"})
@SourceDebugExtension(value={"SMAP\nRethrowCaughtException.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RethrowCaughtException.kt\nio/gitlab/arturbosch/detekt/rules/exceptions/RethrowCaughtException\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,93:1\n158#2:94\n11165#3:95\n11500#3,3:96\n944#4,15:99\n1863#4,2:114\n*S KotlinDebug\n*F\n+ 1 RethrowCaughtException.kt\nio/gitlab/arturbosch/detekt/rules/exceptions/RethrowCaughtException\n*L\n73#1:94\n74#1:95\n74#1:96,3\n75#1:99,15\n76#1:114,2\n*E\n"})
public final class RethrowCaughtException
extends Rule {
    @NotNull
    private final Issue issue;

    public RethrowCaughtException(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        this.issue = new Issue("RethrowCaughtException", Severity.CodeSmell, "Do not rethrow a caught exception of the same type.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ RethrowCaughtException(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitTryExpression(@NotNull KtTryExpression tryExpr) {
        List list;
        block9: {
            void $this$mapTo$iv$iv;
            KtCatchClause[] catchClauses;
            Intrinsics.checkNotNullParameter(tryExpr, "tryExpr");
            PsiElement $this$getChildrenOfType$iv = tryExpr;
            boolean $i$f$getChildrenOfType = false;
            PsiElement[] psiElementArray = PsiTreeUtil.getChildrenOfType((PsiElement)$this$getChildrenOfType$iv, KtCatchClause.class);
            if (psiElementArray == null) {
                psiElementArray = new KtCatchClause[0];
            }
            KtCatchClause[] $this$map$iv = catchClauses = (KtCatchClause[])psiElementArray;
            boolean $i$f$map = false;
            KtCatchClause[] ktCatchClauseArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int j = 0; j < n; ++j) {
                void it;
                void item$iv$iv;
                void var11_15 = item$iv$iv = $this$mapTo$iv$iv[j];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.violatingThrowExpressionFrom((KtCatchClause)it));
            }
            List $this$takeLastWhile$iv = (List)destination$iv$iv;
            boolean $i$f$takeLastWhile = false;
            if ($this$takeLastWhile$iv.isEmpty()) {
                list = CollectionsKt.emptyList();
            } else {
                ListIterator iterator$iv = $this$takeLastWhile$iv.listIterator($this$takeLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    KtThrowExpression it = (KtThrowExpression)iterator$iv.previous();
                    boolean bl = false;
                    if (it != null) continue;
                    iterator$iv.next();
                    int expectedSize$iv = $this$takeLastWhile$iv.size() - iterator$iv.nextIndex();
                    if (expectedSize$iv == 0) {
                        list = CollectionsKt.emptyList();
                    } else {
                        ArrayList arrayList;
                        ArrayList $this$takeLastWhile_u24lambda_u248$iv = arrayList = new ArrayList(expectedSize$iv);
                        boolean bl2 = false;
                        while (iterator$iv.hasNext()) {
                            $this$takeLastWhile_u24lambda_u248$iv.add(iterator$iv.next());
                        }
                        list = arrayList;
                    }
                    break block9;
                }
                list = CollectionsKt.toList($this$takeLastWhile$iv);
            }
        }
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtThrowExpression it;
            KtThrowExpression violation = (KtThrowExpression)element$iv;
            boolean bl = false;
            if (violation == null) continue;
            boolean bl3 = false;
            this.report(new CodeSmell(this.getIssue(), Entity.Companion.from$default(Entity.Companion, it, 0, 2, null), this.getIssue().getDescription(), null, null, 24, null));
        }
        super.visitTryExpression(tryExpr);
    }

    private final KtThrowExpression violatingThrowExpressionFrom(KtCatchClause catchClause) {
        KtParameter ktParameter = catchClause.getCatchParameter();
        String exceptionName = ktParameter != null ? ktParameter.getName() : null;
        PsiElement[] psiElementArray = catchClause.getCatchBody();
        PsiElement psiElement = psiElementArray != null && (psiElementArray = psiElementArray.getChildren()) != null ? ArraysKt.firstOrNull(psiElementArray) : null;
        KtThrowExpression throwExpression = psiElement instanceof KtThrowExpression ? (KtThrowExpression)psiElement : null;
        KtExpression ktExpression = throwExpression;
        if (Intrinsics.areEqual(ktExpression != null && (ktExpression = ((KtThrowExpression)ktExpression).getThrownExpression()) != null ? ktExpression.getText() : null, exceptionName)) {
            return throwExpression;
        }
        return null;
    }

    public RethrowCaughtException() {
        this((Config)null, 1, (DefaultConstructorMarker)null);
    }
}

