/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.exceptions;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiRecursiveElementVisitor;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCatchClause;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\u0013H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0014"}, d2={"Lio/gitlab/arturbosch/detekt/rules/exceptions/PrintStackTrace;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitCallExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "visitCatchSection", "catchClause", "Lorg/jetbrains/kotlin/psi/KtCatchClause;", "hasPrintStacktraceCallExpression", "", "Lorg/jetbrains/kotlin/psi/KtNameReferenceExpression;", "detekt-rules-exceptions"})
@SourceDebugExtension(value={"SMAP\nPrintStackTrace.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PrintStackTrace.kt\nio/gitlab/arturbosch/detekt/rules/exceptions/PrintStackTrace\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,81:1\n222#2,9:82\n241#2:91\n*S KotlinDebug\n*F\n+ 1 PrintStackTrace.kt\nio/gitlab/arturbosch/detekt/rules/exceptions/PrintStackTrace\n*L\n69#1:82,9\n69#1:91\n*E\n"})
public final class PrintStackTrace
extends Rule {
    @NotNull
    private final Issue issue;

    public PrintStackTrace(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        this.issue = new Issue("PrintStackTrace", Severity.CodeSmell, "Do not print a stack trace. These debug statements should be removed or replaced with a logger.", Debt.Companion.getTWENTY_MINS());
    }

    public /* synthetic */ PrintStackTrace(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    @Override
    public void visitCallExpression(@NotNull KtCallExpression expression2) {
        KtSimpleNameExpression callNameExpression;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        KtSimpleNameExpression ktSimpleNameExpression = callNameExpression = KtPsiUtilKt.getCallNameExpression(expression2);
        if (Intrinsics.areEqual(ktSimpleNameExpression != null ? ktSimpleNameExpression.getText() : null, "dumpStack")) {
            KtExpression ktExpression = KtPsiUtilKt.getReceiverExpression(callNameExpression);
            if (Intrinsics.areEqual(ktExpression != null ? ktExpression.getText() : null, "Thread")) {
                this.report(new CodeSmell(this.getIssue(), Entity.Companion.from$default(Entity.Companion, expression2, 0, 2, null), this.getIssue().getDescription(), null, null, 24, null));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitCatchSection(@NotNull KtCatchClause catchClause) {
        block0: {
            void $this$forEachDescendantOfType$iv;
            Intrinsics.checkNotNullParameter(catchClause, "catchClause");
            KtExpression ktExpression = catchClause.getCatchBody();
            if (ktExpression == null) break block0;
            PsiElement psiElement = ktExpression;
            Function1<KtNameReferenceExpression, Unit> action$iv = arg_0 -> PrintStackTrace.visitCatchSection$lambda$0(catchClause, this, arg_0);
            boolean $i$f$forEachDescendantOfType = false;
            void $this$forEachDescendantOfType$iv$iv = $this$forEachDescendantOfType$iv;
            boolean $i$f$forEachDescendantOfType2 = false;
            PsiUtilsKt.checkDecompiledText((PsiElement)$this$forEachDescendantOfType$iv$iv);
            $this$forEachDescendantOfType$iv$iv.accept(new PsiRecursiveElementVisitor(action$iv){
                final /* synthetic */ Function1 $action;
                {
                    this.$action = $action;
                }

                public void visitElement(PsiElement element) {
                    Intrinsics.checkNotNullParameter(element, "element");
                    PsiElement it = element;
                    boolean bl = false;
                    super.visitElement(element);
                    if (element instanceof KtNameReferenceExpression) {
                        this.$action.invoke(element);
                    }
                }
            });
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasPrintStacktraceCallExpression(KtNameReferenceExpression expression2) {
        PsiElement psiElement = expression2.getNextSibling();
        PsiElement methodCall = psiElement != null ? psiElement.getNextSibling() : null;
        if (!(methodCall instanceof KtCallExpression)) return false;
        String string2 = ((KtCallExpression)methodCall).getText();
        Intrinsics.checkNotNullExpressionValue(string2, "getText(...)");
        if (!StringsKt.startsWith$default(string2, "printStackTrace(", false, 2, null)) return false;
        return true;
    }

    private static final Unit visitCatchSection$lambda$0(KtCatchClause $catchClause, PrintStackTrace this$0, KtNameReferenceExpression it) {
        Intrinsics.checkNotNullParameter(it, "it");
        KtParameter ktParameter = $catchClause.getCatchParameter();
        if (Intrinsics.areEqual(it.getText(), ktParameter != null ? ktParameter.getName() : null) && this$0.hasPrintStacktraceCallExpression(it)) {
            this$0.report(new CodeSmell(this$0.getIssue(), Entity.Companion.from$default(Entity.Companion, it, 0, 2, null), this$0.getIssue().getDescription(), null, null, 24, null));
        }
        return Unit.INSTANCE;
    }

    public PrintStackTrace() {
        this((Config)null, 1, (DefaultConstructorMarker)null);
    }
}

