/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.documentation;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.rules.KtModifierListKt;
import io.gitlab.arturbosch.detekt.rules.TraversingKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclarationStub;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0016\u0010\u001c\u001a\u00020\u000b*\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002J\u0014\u0010 \u001a\u00020\u000b*\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\f\u0010!\u001a\u00020\u000b*\u00020\u0018H\u0002J\f\u0010\"\u001a\u00020\u000b*\u00020\u0018H\u0002J\u0010\u0010#\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u001dH\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR!\u0010\n\u001a\u00020\u000b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\u0011\u0012\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006$"}, d2={"Lio/gitlab/arturbosch/detekt/rules/documentation/UndocumentedPublicProperty;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "searchProtectedProperty", "", "getSearchProtectedProperty$annotations", "()V", "getSearchProtectedProperty", "()Z", "searchProtectedProperty$delegate", "Lkotlin/properties/ReadOnlyProperty;", "visitPrimaryConstructor", "", "constructor", "Lorg/jetbrains/kotlin/psi/KtPrimaryConstructor;", "visitProperty", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "visitEnumEntry", "enumEntry", "Lorg/jetbrains/kotlin/psi/KtEnumEntry;", "isUndocumented", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "comment", "", "isNotReferenced", "shouldBeDocumented", "isTopLevelOrInPublicClass", "report", "detekt-rules-documentation"})
@SourceDebugExtension(value={"SMAP\nUndocumentedPublicProperty.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UndocumentedPublicProperty.kt\nio/gitlab/arturbosch/detekt/rules/documentation/UndocumentedPublicProperty\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,90:1\n774#2:91\n865#2,2:92\n774#2:94\n865#2,2:95\n1863#2,2:97\n*S KotlinDebug\n*F\n+ 1 UndocumentedPublicProperty.kt\nio/gitlab/arturbosch/detekt/rules/documentation/UndocumentedPublicProperty\n*L\n43#1:91\n43#1:92,2\n44#1:94\n44#1:95,2\n45#1:97,2\n*E\n"})
public final class UndocumentedPublicProperty
extends Rule {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty searchProtectedProperty$delegate;

    public UndocumentedPublicProperty(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        String string2 = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue(string2, "getSimpleName(...)");
        this.issue = new Issue(string2, Severity.Maintainability, "Public properties require documentation.", Debt.Companion.getTWENTY_MINS());
        this.searchProtectedProperty$delegate = ConfigPropertyKt.config(false);
    }

    public /* synthetic */ UndocumentedPublicProperty(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final boolean getSearchProtectedProperty() {
        return (Boolean)this.searchProtectedProperty$delegate.getValue(this, $$delegatedProperties[0]);
    }

    @Configuration(description="if protected functions should be searched")
    private static /* synthetic */ void getSearchProtectedProperty$annotations() {
    }

    @Override
    public void visitPrimaryConstructor(@NotNull KtPrimaryConstructor constructor) {
        Intrinsics.checkNotNullParameter(constructor, "constructor");
        if (TraversingKt.isPublicInherited(constructor)) {
            KtParameter it;
            Iterable $this$filterTo$iv$iv;
            PsiElement psiElement = KtPsiUtilKt.getContainingClassOrObject(constructor);
            String comment = psiElement != null && (psiElement = ((KtDeclarationStub)psiElement).getDocComment()) != null ? psiElement.getText() : null;
            Iterable $this$filter$iv = constructor.getValueParameters();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (KtParameter)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull(it);
                if (!(KtModifierListKt.isPublicNotOverridden(it) && it.hasValOrVar())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (KtParameter)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull(it);
                if (!(this.isUndocumented(it, comment) && it.getDocComment() == null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KtParameter it2 = (KtParameter)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull(it2);
                this.report(it2);
            }
        }
        super.visitPrimaryConstructor(constructor);
    }

    @Override
    public void visitProperty(@NotNull KtProperty property) {
        Intrinsics.checkNotNullParameter(property, "property");
        if (TraversingKt.isPublicInherited(property, this.getSearchProtectedProperty()) && !property.isLocal() && this.shouldBeDocumented(property)) {
            this.report(property);
        }
        super.visitProperty(property);
    }

    @Override
    public void visitEnumEntry(@NotNull KtEnumEntry enumEntry) {
        Intrinsics.checkNotNullParameter(enumEntry, "enumEntry");
        super.visitEnumEntry(enumEntry);
        if (TraversingKt.isPublicInherited(enumEntry, this.getSearchProtectedProperty()) && enumEntry.getDocComment() == null) {
            this.report(enumEntry);
        }
    }

    private final boolean isUndocumented(KtNamedDeclaration $this$isUndocumented, String comment) {
        return comment == null || this.isNotReferenced($this$isUndocumented, comment);
    }

    private final boolean isNotReferenced(KtNamedDeclaration $this$isNotReferenced, String comment) {
        Name name2 = $this$isNotReferenced.getNameAsSafeName();
        Intrinsics.checkNotNullExpressionValue(name2, "getNameAsSafeName(...)");
        Name name3 = name2;
        return !StringsKt.contains$default((CharSequence)comment, "" + '[' + name3 + ']', false, 2, null) && !StringsKt.contains$default((CharSequence)comment, "@property " + name3, false, 2, null) && !StringsKt.contains$default((CharSequence)comment, "@param " + name3, false, 2, null);
    }

    private final boolean shouldBeDocumented(KtProperty $this$shouldBeDocumented) {
        PsiElement psiElement;
        return $this$shouldBeDocumented.getDocComment() == null && this.isTopLevelOrInPublicClass($this$shouldBeDocumented) && KtModifierListKt.isPublicNotOverridden($this$shouldBeDocumented, this.getSearchProtectedProperty()) && this.isUndocumented($this$shouldBeDocumented, (psiElement = KtPsiUtilKt.getContainingClassOrObject($this$shouldBeDocumented)) != null && (psiElement = ((KtDeclarationStub)psiElement).getDocComment()) != null ? psiElement.getText() : null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isTopLevelOrInPublicClass(KtProperty $this$isTopLevelOrInPublicClass) {
        if ($this$isTopLevelOrInPublicClass.isTopLevel()) return true;
        KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject($this$isTopLevelOrInPublicClass);
        if (ktClassOrObject == null) return false;
        if (!KtPsiUtilKt.isPublic(ktClassOrObject)) return false;
        return true;
    }

    private final void report(KtNamedDeclaration property) {
        this.report(new CodeSmell(this.getIssue(), Entity.Companion.atName(property), "The property " + property.getNameAsSafeName() + " is missing documentation.", null, null, 24, null));
    }

    public UndocumentedPublicProperty() {
        this((Config)null, 1, (DefaultConstructorMarker)null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(UndocumentedPublicProperty.class, "searchProtectedProperty", "getSearchProtectedProperty()Z", 0))};
        $$delegatedProperties = kPropertyArray;
    }
}

