/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.documentation;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.rules.KtModifierListKt;
import io.gitlab.arturbosch.detekt.rules.documentation.UndocumentedPublicFunction$shouldBeDocumented$;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\f\u0010\u0016\u001a\u00020\u000b*\u00020\u0015H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR!\u0010\n\u001a\u00020\u000b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\u0011\u0012\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0017"}, d2={"Lio/gitlab/arturbosch/detekt/rules/documentation/UndocumentedPublicFunction;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "searchProtectedFunction", "", "getSearchProtectedFunction$annotations", "()V", "getSearchProtectedFunction", "()Z", "searchProtectedFunction$delegate", "Lkotlin/properties/ReadOnlyProperty;", "visitNamedFunction", "", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "shouldBeDocumented", "detekt-rules-documentation"})
@SourceDebugExtension(value={"SMAP\nUndocumentedPublicFunction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UndocumentedPublicFunction.kt\nio/gitlab/arturbosch/detekt/rules/documentation/UndocumentedPublicFunction\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,57:1\n477#2:58\n1228#2,2:59\n477#2:61\n1228#2,2:62\n*S KotlinDebug\n*F\n+ 1 UndocumentedPublicFunction.kt\nio/gitlab/arturbosch/detekt/rules/documentation/UndocumentedPublicFunction\n*L\n52#1:58\n52#1:59,2\n54#1:61\n54#1:62,2\n*E\n"})
public final class UndocumentedPublicFunction
extends Rule {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty searchProtectedFunction$delegate;

    public UndocumentedPublicFunction(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        String string2 = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue(string2, "getSimpleName(...)");
        this.issue = new Issue(string2, Severity.Maintainability, "Public functions require documentation.", Debt.Companion.getTWENTY_MINS());
        this.searchProtectedFunction$delegate = ConfigPropertyKt.config(false);
    }

    public /* synthetic */ UndocumentedPublicFunction(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final boolean getSearchProtectedFunction() {
        return (Boolean)this.searchProtectedFunction$delegate.getValue(this, $$delegatedProperties[0]);
    }

    @Configuration(description="if protected functions should be searched")
    private static /* synthetic */ void getSearchProtectedFunction$annotations() {
    }

    @Override
    public void visitNamedFunction(@NotNull KtNamedFunction function2) {
        Intrinsics.checkNotNullParameter(function2, "function");
        if (function2.getFunKeyword() == null && function2.isLocal()) {
            return;
        }
        if (function2.getDocComment() == null && this.shouldBeDocumented(function2)) {
            this.report(new CodeSmell(this.getIssue(), Entity.Companion.atName(function2), "The function " + function2.getNameAsSafeName() + " is missing documentation.", null, null, 24, null));
        }
    }

    private final boolean shouldBeDocumented(KtNamedFunction $this$shouldBeDocumented) {
        boolean bl;
        block4: {
            if (this.getSearchProtectedFunction()) {
                Sequence<PsiElement> $this$filterIsInstance$iv = PsiUtilsKt.getParents($this$shouldBeDocumented);
                boolean $i$f$filterIsInstance = false;
                Sequence<PsiElement> sequence2 = SequencesKt.filter($this$filterIsInstance$iv, shouldBeDocumented$$inlined$filterIsInstance$1.INSTANCE);
                Intrinsics.checkNotNull(sequence2, "null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
                Sequence<PsiElement> $this$all$iv = sequence2;
                boolean $i$f$all = false;
                Iterator<PsiElement> iterator2 = $this$all$iv.iterator();
                while (iterator2.hasNext()) {
                    PsiElement element$iv = iterator2.next();
                    KtClassOrObject it = (KtClassOrObject)element$iv;
                    boolean bl2 = false;
                    if (KtPsiUtilKt.isPublic(it) || KtModifierListKt.isProtected(it)) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            } else {
                Sequence<PsiElement> $this$filterIsInstance$iv = PsiUtilsKt.getParents($this$shouldBeDocumented);
                boolean $i$f$filterIsInstance = false;
                Sequence<PsiElement> sequence3 = SequencesKt.filter($this$filterIsInstance$iv, shouldBeDocumented$$inlined$filterIsInstance$2.INSTANCE);
                Intrinsics.checkNotNull(sequence3, "null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
                Sequence<PsiElement> $this$all$iv = sequence3;
                boolean $i$f$all = false;
                Iterator<PsiElement> iterator3 = $this$all$iv.iterator();
                while (iterator3.hasNext()) {
                    PsiElement element$iv = iterator3.next();
                    KtClassOrObject it = (KtClassOrObject)element$iv;
                    boolean bl3 = false;
                    if (KtPsiUtilKt.isPublic(it)) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        return bl && KtModifierListKt.isPublicNotOverridden($this$shouldBeDocumented, this.getSearchProtectedFunction());
    }

    public UndocumentedPublicFunction() {
        this((Config)null, 1, (DefaultConstructorMarker)null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(UndocumentedPublicFunction.class, "searchProtectedFunction", "getSearchProtectedFunction()Z", 0))};
        $$delegatedProperties = kPropertyArray;
    }
}

