/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.documentation;

import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Detektion;
import io.gitlab.arturbosch.detekt.api.FileProcessListener;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.SetupContext;
import io.gitlab.arturbosch.detekt.api.SingleAssign;
import io.gitlab.arturbosch.detekt.rules.documentation.AbsentOrWrongFileLicense;
import io.gitlab.arturbosch.detekt.rules.documentation.LicenceHeaderLoaderExtensionKt;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.BindingContext;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001e\u0010\u0013\u001a\u00020\u00102\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R+\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00058B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u000b\u0010\f\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lio/gitlab/arturbosch/detekt/rules/documentation/LicenceHeaderLoaderExtension;", "Lio/gitlab/arturbosch/detekt/api/FileProcessListener;", "<init>", "()V", "<set-?>", "Lio/gitlab/arturbosch/detekt/api/Config;", "config", "getConfig", "()Lio/gitlab/arturbosch/detekt/api/Config;", "setConfig", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "config$delegate", "Lio/gitlab/arturbosch/detekt/api/SingleAssign;", "configPath", "Ljava/nio/file/Path;", "init", "", "context", "Lio/gitlab/arturbosch/detekt/api/SetupContext;", "onStart", "files", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "detekt-rules-documentation"})
public final class LicenceHeaderLoaderExtension
implements FileProcessListener {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final SingleAssign config$delegate = new SingleAssign();
    @Nullable
    private Path configPath;

    private final Config getConfig() {
        return (Config)this.config$delegate.getValue(this, $$delegatedProperties[0]);
    }

    private final void setConfig(Config config) {
        this.config$delegate.setValue(this, $$delegatedProperties[0], config);
    }

    @Override
    public void init(@NotNull SetupContext context) {
        Path path;
        Intrinsics.checkNotNullParameter(context, "context");
        this.setConfig(context.getConfig());
        URI uRI = (URI)CollectionsKt.lastOrNull((Iterable)context.getConfigUris());
        if (uRI != null) {
            Path path2 = Paths.get(uRI);
            path = path2;
            Intrinsics.checkNotNullExpressionValue(path2, "get(...)");
        } else {
            path = null;
        }
        this.configPath = path;
    }

    @Override
    public void onStart(@NotNull List<? extends KtFile> files2, @NotNull BindingContext bindingContext) {
        Intrinsics.checkNotNullParameter(files2, "files");
        Intrinsics.checkNotNullParameter(bindingContext, "bindingContext");
        if (this.configPath != null && LicenceHeaderLoaderExtension.onStart$shouldRuleRun(this)) {
            Path path = this.configPath;
            if (path == null || (path = path.getParent()) == null) {
                return;
            }
            Path configDir = path;
            LicenceHeaderLoaderExtension.onStart$cacheLicence(files2, this, configDir, LicenceHeaderLoaderExtension.onStart$isRegexTemplate(this));
        }
    }

    @Override
    @Deprecated(message="Use alternative with a binding context.", replaceWith=@ReplaceWith(expression="onStart(files, bindingContext)", imports={}))
    public void onStart(@NotNull List<? extends KtFile> files2) {
        FileProcessListener.DefaultImpls.onStart(this, files2);
    }

    @Override
    @Deprecated(message="Use alternative with a binding context.", replaceWith=@ReplaceWith(expression="onProcess(file, bindingContext)", imports={}))
    public void onProcess(@NotNull KtFile file2) {
        FileProcessListener.DefaultImpls.onProcess(this, file2);
    }

    @Override
    public void onProcess(@NotNull KtFile file2, @NotNull BindingContext bindingContext) {
        FileProcessListener.DefaultImpls.onProcess(this, file2, bindingContext);
    }

    @Override
    @Deprecated(message="Use alternative with a binding context.", replaceWith=@ReplaceWith(expression="onProcessComplete(file, findings, bindingContext)", imports={}))
    public void onProcessComplete(@NotNull KtFile file2, @NotNull Map<String, ? extends List<? extends Finding>> findings) {
        FileProcessListener.DefaultImpls.onProcessComplete(this, file2, findings);
    }

    @Override
    public void onProcessComplete(@NotNull KtFile file2, @NotNull Map<String, ? extends List<? extends Finding>> findings, @NotNull BindingContext bindingContext) {
        FileProcessListener.DefaultImpls.onProcessComplete(this, file2, findings, bindingContext);
    }

    @Override
    @Deprecated(message="Use alternative with a binding context.", replaceWith=@ReplaceWith(expression="onFinish(files, result, bindingContext)", imports={}))
    public void onFinish(@NotNull List<? extends KtFile> files2, @NotNull Detektion result2) {
        FileProcessListener.DefaultImpls.onFinish(this, files2, result2);
    }

    @Override
    public void onFinish(@NotNull List<? extends KtFile> files2, @NotNull Detektion result2, @NotNull BindingContext bindingContext) {
        FileProcessListener.DefaultImpls.onFinish(this, files2, result2, bindingContext);
    }

    @Override
    public void init(@NotNull Config config) {
        FileProcessListener.DefaultImpls.init((FileProcessListener)this, config);
    }

    @Override
    @NotNull
    public String getId() {
        return FileProcessListener.DefaultImpls.getId(this);
    }

    @Override
    public int getPriority() {
        return FileProcessListener.DefaultImpls.getPriority(this);
    }

    private static final boolean onStart$isActive(Config $this$onStart_u24isActive) {
        return $this$onStart_u24isActive.valueOrDefault("active", false);
    }

    private static final boolean onStart$shouldRuleRun(LicenceHeaderLoaderExtension this$0) {
        Config comments = this$0.getConfig().subConfig("comments");
        Config ruleConfig = comments.subConfig(AbsentOrWrongFileLicense.Companion.getRULE_NAME());
        return LicenceHeaderLoaderExtension.onStart$isActive(comments) && LicenceHeaderLoaderExtension.onStart$isActive(ruleConfig);
    }

    private static final String onStart$getPathToTemplate(LicenceHeaderLoaderExtension this$0) {
        return this$0.getConfig().subConfig("comments").subConfig(AbsentOrWrongFileLicense.Companion.getRULE_NAME()).valueOrDefault("licenseTemplateFile", "license.template");
    }

    private static final boolean onStart$isRegexTemplate(LicenceHeaderLoaderExtension this$0) {
        return this$0.getConfig().subConfig("comments").subConfig(AbsentOrWrongFileLicense.Companion.getRULE_NAME()).valueOrDefault("licenseTemplateIsRegex", false);
    }

    private static final String onStart$loadLicence(LicenceHeaderLoaderExtension this$0, Path dir2) {
        Path templateFile = dir2.resolve(LicenceHeaderLoaderExtension.onStart$getPathToTemplate(this$0));
        Intrinsics.checkNotNull(templateFile);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(templateFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            boolean bl = false;
            StringBuilder stringBuilder = new StringBuilder().append("\n                    Rule '").append(AbsentOrWrongFileLicense.Companion.getRULE_NAME()).append("': License template file not found at `");
            Path path = templateFile.toAbsolutePath();
            Intrinsics.checkNotNullExpressionValue(path, "toAbsolutePath(...)");
            String string2 = StringsKt.trimIndent(stringBuilder.append(path).append("`.\n                    Create file license header file or check your running path.\n                ").toString());
            throw new IllegalArgumentException(string2.toString());
        }
        return LicenceHeaderLoaderExtensionKt.access$convertLineSeparators(PathsKt.readText$default(templateFile, null, 1, null));
    }

    private static final void onStart$cacheLicence(List<? extends KtFile> $files, LicenceHeaderLoaderExtension this$0, Path dir2, boolean isRegexTemplate) {
        String licenceHeader = LicenceHeaderLoaderExtension.onStart$loadLicence(this$0, dir2);
        if (!isRegexTemplate) {
            for (KtFile ktFile : $files) {
                ktFile.putUserData(LicenceHeaderLoaderExtensionKt.getLICENCE_KEY(), licenceHeader);
            }
            return;
        }
        Regex licenseHeaderRegex = new Regex(licenceHeader, RegexOption.MULTILINE);
        for (KtFile ktFile : $files) {
            ktFile.putUserData(LicenceHeaderLoaderExtensionKt.getLICENCE_REGEX_KEY(), licenseHeaderRegex);
        }
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1(new MutablePropertyReference1Impl(LicenceHeaderLoaderExtension.class, "config", "getConfig()Lio/gitlab/arturbosch/detekt/api/Config;", 0))};
        $$delegatedProperties = kPropertyArray;
    }
}

