/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.documentation;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.DetektVisitor;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\fH\u0016J\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u000eH\u0016J\u0014\u0010\u0015\u001a\u00020\u0011*\u00020\f2\u0006\u0010\u0014\u001a\u00020\u000eH\u0002J\f\u0010\u0016\u001a\u00020\u0017*\u00020\u0018H\u0002J\f\u0010\u0019\u001a\u00020\u001a*\u00020\u000eH\u0002J\u0010\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u000eH\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR \u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lio/gitlab/arturbosch/detekt/rules/documentation/KDocReferencesNonPublicProperty;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "publicPropertiesByClass", "", "Lorg/jetbrains/kotlin/psi/KtClass;", "", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "privatePropertiesByClass", "visitClass", "", "klass", "visitNamedDeclaration", "declaration", "registerProperty", "isNonPublicInherited", "", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "qualifiedName", "", "report", "property", "detekt-rules-documentation"})
@SourceDebugExtension(value={"SMAP\nKDocReferencesNonPublicProperty.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KDocReferencesNonPublicProperty.kt\nio/gitlab/arturbosch/detekt/rules/documentation/KDocReferencesNonPublicProperty\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,142:1\n1628#2,3:143\n150#3:146\n381#4,7:147\n381#4,7:154\n*S KotlinDebug\n*F\n+ 1 KDocReferencesNonPublicProperty.kt\nio/gitlab/arturbosch/detekt/rules/documentation/KDocReferencesNonPublicProperty\n*L\n78#1:143,3\n92#1:146\n100#1:147,7\n103#1:154,7\n*E\n"})
public final class KDocReferencesNonPublicProperty
extends Rule {
    @NotNull
    private final Issue issue;
    @NotNull
    private final Map<KtClass, Set<KtNamedDeclaration>> publicPropertiesByClass;
    @NotNull
    private final Map<KtClass, Set<KtNamedDeclaration>> privatePropertiesByClass;

    public KDocReferencesNonPublicProperty(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        String string2 = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue(string2, "getSimpleName(...)");
        this.issue = new Issue(string2, Severity.Maintainability, "KDoc comments should not refer to non-public properties.", Debt.Companion.getFIVE_MINS());
        this.publicPropertiesByClass = new LinkedHashMap();
        this.privatePropertiesByClass = new LinkedHashMap();
    }

    public /* synthetic */ KDocReferencesNonPublicProperty(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitClass(@NotNull KtClass klass) {
        Set<KtNamedDeclaration> set;
        Set publicPropertyNames;
        Set set2;
        Set set3;
        Intrinsics.checkNotNullParameter(klass, "klass");
        super.visitClass(klass);
        Object object = klass.getDocComment();
        if (object == null || (object = object.getText()) == null) {
            return;
        }
        Object comment = object;
        KtPrimaryConstructor ktPrimaryConstructor = klass.getPrimaryConstructor();
        if (ktPrimaryConstructor != null) {
            ktPrimaryConstructor.accept(new DetektVisitor(this, klass){
                final /* synthetic */ KDocReferencesNonPublicProperty this$0;
                final /* synthetic */ KtClass $klass;
                {
                    this.this$0 = $receiver;
                    this.$klass = $klass;
                }

                public void visitParameter(KtParameter parameter) {
                    Intrinsics.checkNotNullParameter(parameter, "parameter");
                    super.visitParameter(parameter);
                    KDocReferencesNonPublicProperty.access$registerProperty(this.this$0, this.$klass, parameter);
                }
            });
        }
        Set<KtNamedDeclaration> privateProperties = this.privatePropertiesByClass.remove(klass);
        Set<KtNamedDeclaration> set4 = this.publicPropertiesByClass.remove(klass);
        if (set4 != null) {
            void destination$iv;
            void $this$mapTo$iv;
            Iterable iterable = set4;
            Collection collection = new LinkedHashSet();
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it;
                KtNamedDeclaration ktNamedDeclaration = (KtNamedDeclaration)item$iv;
                void var13_12 = destination$iv;
                boolean bl = false;
                var13_12.add(this.qualifiedName((KtNamedDeclaration)it));
            }
            set3 = (Set)destination$iv;
        } else {
            set3 = set2 = null;
        }
        if (set3 == null) {
            set2 = publicPropertyNames = SetsKt.emptySet();
        }
        if ((set = privateProperties) == null) {
            set = SetsKt.emptySet();
        }
        for (KtNamedDeclaration privateProperty : set) {
            String qualifiedName = this.qualifiedName(privateProperty);
            boolean matchesPublicProperty = publicPropertyNames.contains(qualifiedName);
            if (matchesPublicProperty || !StringsKt.contains$default((CharSequence)comment, '[' + qualifiedName + ']', false, 2, null)) continue;
            this.report(privateProperty);
        }
    }

    @Override
    public void visitNamedDeclaration(@NotNull KtNamedDeclaration declaration) {
        block0: {
            Intrinsics.checkNotNullParameter(declaration, "declaration");
            super.visitNamedDeclaration(declaration);
            PsiElement $this$getTopmostParentOfType$iv = declaration;
            boolean $i$f$getTopmostParentOfType = false;
            KtClass ktClass = PsiTreeUtil.getTopmostParentOfType($this$getTopmostParentOfType$iv, KtClass.class);
            if (ktClass == null) break block0;
            this.registerProperty(ktClass, declaration);
        }
    }

    private final void registerProperty(KtClass $this$registerProperty, KtNamedDeclaration declaration) {
        if (this.isNonPublicInherited(declaration)) {
            if (declaration instanceof KtProperty) {
                Set set;
                Map<KtClass, Set<KtNamedDeclaration>> $this$getOrPut$iv = this.privatePropertiesByClass;
                boolean $i$f$getOrPut = false;
                Set value$iv = $this$getOrPut$iv.get($this$registerProperty);
                if (value$iv == null) {
                    boolean bl = false;
                    Set answer$iv = new LinkedHashSet();
                    $this$getOrPut$iv.put($this$registerProperty, answer$iv);
                    set = answer$iv;
                } else {
                    set = value$iv;
                }
                set.add((KtNamedDeclaration)declaration);
            }
        } else {
            Set set;
            Map<KtClass, Set<KtNamedDeclaration>> $this$getOrPut$iv = this.publicPropertiesByClass;
            boolean $i$f$getOrPut = false;
            Set value$iv = $this$getOrPut$iv.get($this$registerProperty);
            if (value$iv == null) {
                boolean bl = false;
                Set answer$iv = new LinkedHashSet();
                $this$getOrPut$iv.put($this$registerProperty, answer$iv);
                set = answer$iv;
            } else {
                set = value$iv;
            }
            set.add((KtNamedDeclaration)declaration);
        }
    }

    private final boolean isNonPublicInherited(KtDeclaration $this$isNonPublicInherited) {
        if (!KtPsiUtilKt.isPublic($this$isNonPublicInherited) && !KtPsiUtilKt.isProtected($this$isNonPublicInherited)) {
            return true;
        }
        KtClassOrObject classOrObject = KtPsiUtilKt.getContainingClassOrObject($this$isNonPublicInherited);
        while (classOrObject instanceof KtObjectDeclaration) {
            if (!KtPsiUtilKt.isPublic(classOrObject)) {
                return true;
            }
            classOrObject = KtPsiUtilKt.getContainingClassOrObject(classOrObject);
        }
        return false;
    }

    private final String qualifiedName(KtNamedDeclaration $this$qualifiedName) {
        String string2 = $this$qualifiedName.getNameAsSafeName().asString();
        Intrinsics.checkNotNullExpressionValue(string2, "asString(...)");
        String qualifiedName = string2;
        KtClassOrObject classOrObject = KtPsiUtilKt.getContainingClassOrObject($this$qualifiedName);
        while (classOrObject instanceof KtObjectDeclaration) {
            qualifiedName = ((KtObjectDeclaration)classOrObject).getNameAsSafeName().asString() + '.' + qualifiedName;
            classOrObject = KtPsiUtilKt.getContainingClassOrObject(classOrObject);
        }
        return qualifiedName;
    }

    private final void report(KtNamedDeclaration property) {
        this.report(new CodeSmell(this.getIssue(), Entity.Companion.atName(property), "The property " + property.getNameAsSafeName() + " is non-public and should not be referenced from KDoc comments.", null, null, 24, null));
    }

    public KDocReferencesNonPublicProperty() {
        this((Config)null, 1, (DefaultConstructorMarker)null);
    }

    public static final /* synthetic */ void access$registerProperty(KDocReferencesNonPublicProperty $this, KtClass $receiver, KtNamedDeclaration declaration) {
        $this.registerProperty($receiver, declaration);
    }
}

