/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.documentation;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.rules.StringExtensionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.kdoc.psi.api.KDoc;
import org.jetbrains.kotlin.psi.KtDeclaration;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\f\u0010\u0017\u001a\u00020\u0018*\u00020\u0019H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR!\u0010\n\u001a\u00020\u000b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\u0011\u0012\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0012\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lio/gitlab/arturbosch/detekt/rules/documentation/EndOfSentenceFormat;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "endOfSentenceFormat", "Lkotlin/text/Regex;", "getEndOfSentenceFormat$annotations", "()V", "getEndOfSentenceFormat", "()Lkotlin/text/Regex;", "endOfSentenceFormat$delegate", "Lkotlin/properties/ReadOnlyProperty;", "htmlTag", "visitDeclaration", "", "dcl", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "startsWithHtmlTag", "", "", "detekt-rules-documentation"})
public final class EndOfSentenceFormat
extends Rule {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty endOfSentenceFormat$delegate;
    @NotNull
    private final Regex htmlTag;

    public EndOfSentenceFormat(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        String string2 = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue(string2, "getSimpleName(...)");
        this.issue = new Issue(string2, Severity.Maintainability, "The first sentence in a KDoc comment should end with proper punctuation or with a correct URL.", Debt.Companion.getFIVE_MINS());
        this.endOfSentenceFormat$delegate = ConfigPropertyKt.config("([.?!][ \\t\\n\\r\\f<])|([.?!:]$)", EndOfSentenceFormat::endOfSentenceFormat_delegate$lambda$0);
        this.htmlTag = new Regex("^<.+>");
    }

    public /* synthetic */ EndOfSentenceFormat(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final Regex getEndOfSentenceFormat() {
        return (Regex)this.endOfSentenceFormat$delegate.getValue(this, $$delegatedProperties[0]);
    }

    @Configuration(description="regular expression which should match the end of the first sentence in the KDoc")
    private static /* synthetic */ void getEndOfSentenceFormat$annotations() {
    }

    @Override
    public void visitDeclaration(@NotNull KtDeclaration dcl) {
        block2: {
            Intrinsics.checkNotNullParameter(dcl, "dcl");
            super.visitDeclaration(dcl);
            KDoc kDoc = dcl.getDocComment();
            if (kDoc == null) break block2;
            KDoc it = kDoc;
            boolean bl = false;
            String text = it.getDefaultSection().getContent();
            if (((CharSequence)text).length() == 0 || this.startsWithHtmlTag(text)) {
                return;
            }
            if (!this.getEndOfSentenceFormat().containsMatchIn(text) && !StringExtensionsKt.lastArgumentMatchesUrl(text)) {
                this.report(new CodeSmell(this.getIssue(), Entity.Companion.from$default(Entity.Companion, it.getDefaultSection(), 0, 2, null), "The first sentence of this KDoc does not end with the correct punctuation.", null, null, 24, null));
            }
        }
    }

    private final boolean startsWithHtmlTag(String $this$startsWithHtmlTag) {
        CharSequence charSequence;
        return StringsKt.startsWith$default($this$startsWithHtmlTag, "<", false, 2, null) && this.htmlTag.containsMatchIn(charSequence = (CharSequence)$this$startsWithHtmlTag);
    }

    private static final Regex endOfSentenceFormat_delegate$lambda$0(String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return new Regex(it);
    }

    public EndOfSentenceFormat() {
        this((Config)null, 1, (DefaultConstructorMarker)null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(EndOfSentenceFormat.class, "endOfSentenceFormat", "getEndOfSentenceFormat()Lkotlin/text/Regex;", 0))};
        $$delegatedProperties = kPropertyArray;
    }
}

