/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.coroutines;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.RequiresTypeResolution;
import io.gitlab.arturbosch.detekt.rules.TypeUtilsKt;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;

@RequiresTypeResolution
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\f\u0010\u0014\u001a\u00020\u0015*\u00020\u0016H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0017"}, d2={"Lio/gitlab/arturbosch/detekt/rules/coroutines/SuspendFunWithCoroutineScopeReceiver;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "defaultRuleIdAliases", "", "", "getDefaultRuleIdAliases", "()Ljava/util/Set;", "visitNamedFunction", "", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "checkReceiver", "isCoroutineScope", "", "Lorg/jetbrains/kotlin/types/KotlinType;", "detekt-rules-coroutines"})
public final class SuspendFunWithCoroutineScopeReceiver
extends Rule {
    @NotNull
    private final Issue issue;
    @NotNull
    private final Set<String> defaultRuleIdAliases;

    public SuspendFunWithCoroutineScopeReceiver(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        this.issue = new Issue("SuspendFunWithCoroutineScopeReceiver", Severity.Minor, "The `suspend` modifier should not be used for functions that use a CoroutinesScope as receiver. You should use suspend functions without the receiver or use plain functions and use coroutineScope { } instead.", Debt.Companion.getTEN_MINS());
        this.defaultRuleIdAliases = SetsKt.setOf("SuspendFunctionOnCoroutineScope");
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    @Override
    @NotNull
    public Set<String> getDefaultRuleIdAliases() {
        return this.defaultRuleIdAliases;
    }

    @Override
    public void visitNamedFunction(@NotNull KtNamedFunction function2) {
        Intrinsics.checkNotNullParameter(function2, "function");
        this.checkReceiver(function2);
    }

    private final void checkReceiver(KtNamedFunction function2) {
        KotlinType kotlinType;
        ReceiverValue receiverValue;
        ReceiverParameterDescriptor receiverParameterDescriptor;
        PsiElement psiElement = function2.getModifierList();
        if (psiElement == null || (psiElement = psiElement.getModifier(KtTokens.SUSPEND_KEYWORD)) == null) {
            return;
        }
        PsiElement suspendModifier = psiElement;
        SimpleFunctionDescriptor simpleFunctionDescriptor = (SimpleFunctionDescriptor)this.getBindingContext().get(BindingContext.FUNCTION, function2);
        if (simpleFunctionDescriptor == null || (receiverParameterDescriptor = simpleFunctionDescriptor.getExtensionReceiverParameter()) == null || (receiverValue = receiverParameterDescriptor.getValue()) == null || (kotlinType = receiverValue.getType()) == null) {
            return;
        }
        KotlinType receiver = kotlinType;
        if (this.isCoroutineScope(receiver)) {
            this.report(new CodeSmell(this.getIssue(), Entity.Companion.from$default(Entity.Companion, suspendModifier, 0, 2, null), "`suspend` function uses CoroutineScope as receiver.", null, null, 24, null));
        }
    }

    private final boolean isCoroutineScope(KotlinType $this$isCoroutineScope) {
        return SequencesKt.contains(SequencesKt.mapNotNull(SequencesKt.sequence((Function2)new Function2<SequenceScope<? super KotlinType>, Continuation<? super Unit>, Object>($this$isCoroutineScope, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ KotlinType $this_isCoroutineScope;
            {
                this.$this_isCoroutineScope = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(var1_1);
                        $this$sequence = (SequenceScope)this.L$0;
                        this.L$0 = $this$sequence;
                        this.label = 1;
                        v0 = $this$sequence.yield(this.$this_isCoroutineScope, this);
                        if (v0 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl16
                    }
                    case 1: {
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v0 = $result;
lbl16:
                        // 2 sources

                        this.L$0 = null;
                        this.label = 2;
                        v1 = $this$sequence.yieldAll((Iterable)org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt.supertypes(this.$this_isCoroutineScope), (Continuation<Unit>)this);
                        if (v1 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl25
                    }
                    case 2: {
                        ResultKt.throwOnFailure($result);
                        v1 = $result;
lbl25:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                Function2<SequenceScope<? super KotlinType>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value2;
                return (Continuation)((Object)function2);
            }

            public final Object invoke(SequenceScope<? super KotlinType> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), SuspendFunWithCoroutineScopeReceiver::isCoroutineScope$lambda$0), "kotlinx.coroutines.CoroutineScope");
    }

    private static final String isCoroutineScope$lambda$0(KotlinType it) {
        Intrinsics.checkNotNullParameter(it, "it");
        FqName fqName = TypeUtilsKt.fqNameOrNull(it);
        return fqName != null ? fqName.asString() : null;
    }
}

