/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.coroutines;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.RequiresTypeResolution;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtOperationExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@RequiresTypeResolution
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\f\u0010\u0014\u001a\u00020\u000f*\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0018"}, d2={"Lio/gitlab/arturbosch/detekt/rules/coroutines/SuspendFunSwallowedCancellation;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitCallExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "shouldTraverseInside", "", "psiElement", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "hasSuspendCalls", "Lorg/jetbrains/kotlin/psi/KtExpression;", "report", "Companion", "detekt-rules-coroutines"})
@SourceDebugExtension(value={"SMAP\nSuspendFunSwallowedCancellation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SuspendFunSwallowedCancellation.kt\nio/gitlab/arturbosch/detekt/rules/coroutines/SuspendFunSwallowedCancellation\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 3 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,189:1\n273#2:190\n284#2,3:191\n299#2:194\n125#2:196\n275#3:195\n1755#4,3:197\n*S KotlinDebug\n*F\n+ 1 SuspendFunSwallowedCancellation.kt\nio/gitlab/arturbosch/detekt/rules/coroutines/SuspendFunSwallowedCancellation\n*L\n114#1:190\n114#1:191,3\n114#1:194\n130#1:196\n116#1:195\n148#1:197,3\n*E\n"})
public final class SuspendFunSwallowedCancellation
extends Rule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Issue issue;
    @NotNull
    private static final FqName RUN_CATCHING_FQ = new FqName("kotlin.runCatching");
    @NotNull
    private static final FqName COROUTINE_CONTEXT_FQ_NAME;

    public SuspendFunSwallowedCancellation(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        String string2 = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue(string2, "getSimpleName(...)");
        this.issue = new Issue(string2, Severity.Minor, "`runCatching` does not propagate `CancellationException`, don't use it with `suspend` lambda blocks.", Debt.Companion.getTEN_MINS());
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitCallExpression(@NotNull KtCallExpression expression2) {
        void $this$anyDescendantOfType$iv;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        super.visitCallExpression(expression2);
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(expression2, this.getBindingContext());
        if (resolvedCall2 == null || (resolvedCall2 = resolvedCall2.getResultingDescriptor()) == null) {
            return;
        }
        ResolvedCall<? extends CallableDescriptor> resultingDescriptor = resolvedCall2;
        if (!Intrinsics.areEqual(DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)((Object)resultingDescriptor)), RUN_CATCHING_FQ)) {
            return;
        }
        PsiElement psiElement = expression2;
        Function1<KtExpression, Boolean> predicate$iv = arg_0 -> SuspendFunSwallowedCancellation.visitCallExpression$lambda$0(this, arg_0);
        boolean $i$f$anyDescendantOfType = false;
        void $this$findDescendantOfType$iv$iv = $this$anyDescendantOfType$iv;
        boolean $i$f$findDescendantOfType = false;
        PsiUtilsKt.checkDecompiledText((PsiElement)$this$findDescendantOfType$iv$iv);
        Ref.ObjectRef result$iv$iv = new Ref.ObjectRef();
        $this$findDescendantOfType$iv$iv.accept(new PsiRecursiveElementWalkingVisitor(predicate$iv, result$iv$iv, expression2, this){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Ref.ObjectRef $result;
            final /* synthetic */ KtCallExpression $expression$inlined;
            final /* synthetic */ SuspendFunSwallowedCancellation this$0;
            {
                this.$predicate = $predicate;
                this.$result = $result;
                this.$expression$inlined = ktCallExpression;
                this.this$0 = suspendFunSwallowedCancellation;
            }

            public void visitElement(PsiElement element) {
                Intrinsics.checkNotNullParameter(element, "element");
                if (element instanceof KtExpression && ((Boolean)this.$predicate.invoke(element)).booleanValue()) {
                    this.$result.element = element;
                    this.stopWalking();
                    return;
                }
                PsiElement p0 = element;
                boolean $i$f$visitCallExpression$stub_for_inlining = false;
                boolean bl = false;
                if (SuspendFunSwallowedCancellation.access$visitCallExpression$shouldTraverseInside(this.$expression$inlined, this.this$0, p0)) {
                    super.visitElement(element);
                }
            }
        });
        boolean $this$ifTrue$iv = (PsiElement)result$iv$iv.element != null;
        boolean $i$f$ifTrue = false;
        if ($this$ifTrue$iv) {
            boolean bl = false;
            this.report(expression2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean shouldTraverseInside(PsiElement psiElement, BindingContext bindingContext) {
        boolean bl;
        PsiElement psiElement2 = psiElement;
        if (psiElement2 instanceof KtCallExpression) {
            ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall((KtElement)psiElement, bindingContext);
            CallableDescriptor callableDescriptor = resolvedCall2 != null ? resolvedCall2.getResultingDescriptor() : null;
            FunctionDescriptor functionDescriptor = callableDescriptor instanceof FunctionDescriptor ? (FunctionDescriptor)callableDescriptor : null;
            if (functionDescriptor == null) {
                return false;
            }
            FunctionDescriptor callableDescriptor2 = functionDescriptor;
            bl = !Intrinsics.areEqual(DescriptorUtilsKt.getFqNameSafe(callableDescriptor2), RUN_CATCHING_FQ) && callableDescriptor2.isInline();
        } else if (psiElement2 instanceof KtValueArgument) {
            void $this$getParentOfType$iv;
            PsiElement psiElement3 = psiElement;
            boolean strict$iv = true;
            boolean $i$f$getParentOfType = false;
            KtCallExpression callExpression = PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtCallExpression.class, strict$iv);
            Object object = callExpression;
            if (object == null || (object = CallUtilKt.getResolvedCall((KtElement)object, bindingContext)) == null || (object = CallUtilKt.getParameterForArgument(object, (ValueArgument)((Object)psiElement))) == null) {
                return false;
            }
            Object valueParameterDescriptor = object;
            bl = !valueParameterDescriptor.isCrossinline() && !valueParameterDescriptor.isNoinline();
        } else {
            bl = true;
        }
        return bl;
    }

    private final boolean hasSuspendCalls(KtExpression $this$hasSuspendCalls) {
        boolean bl;
        block11: {
            KtExpression ktExpression = $this$hasSuspendCalls;
            if (ktExpression instanceof KtForExpression) {
                ResolvedCall loopRangeIterator = (ResolvedCall)this.getBindingContext().get(BindingContext.LOOP_RANGE_ITERATOR_RESOLVED_CALL, ((KtForExpression)$this$hasSuspendCalls).getLoopRange());
                ResolvedCall loopRangeHasNext = (ResolvedCall)this.getBindingContext().get(BindingContext.LOOP_RANGE_HAS_NEXT_RESOLVED_CALL, ((KtForExpression)$this$hasSuspendCalls).getLoopRange());
                ResolvedCall loopRangeNext = (ResolvedCall)this.getBindingContext().get(BindingContext.LOOP_RANGE_NEXT_RESOLVED_CALL, ((KtForExpression)$this$hasSuspendCalls).getLoopRange());
                ResolvedCall[] resolvedCallArray = new ResolvedCall[]{loopRangeIterator, loopRangeHasNext, loopRangeNext};
                Iterable $this$any$iv = CollectionsKt.listOf(resolvedCallArray);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ResolvedCall it = (ResolvedCall)element$iv;
                        boolean bl2 = false;
                        Object object = it;
                        boolean bl3 = object != null && (object = (FunctionDescriptor)object.getResultingDescriptor()) != null ? object.isSuspend() : false;
                        if (!bl3) continue;
                        bl = true;
                        break block11;
                    }
                    bl = false;
                }
            } else if (ktExpression instanceof KtCallExpression || ktExpression instanceof KtOperationExpression) {
                ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall($this$hasSuspendCalls, this.getBindingContext());
                if (resolvedCall2 == null) {
                    return false;
                }
                ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
                CallableDescriptor callableDescriptor = resolvedCall3.getResultingDescriptor();
                FunctionDescriptor functionDescriptor = callableDescriptor instanceof FunctionDescriptor ? (FunctionDescriptor)callableDescriptor : null;
                bl = functionDescriptor != null ? functionDescriptor.isSuspend() : false;
            } else if (ktExpression instanceof KtNameReferenceExpression) {
                PropertyDescriptor propertyDescriptor;
                ResolvedCall<? extends CallableDescriptor> resolvedCall4 = CallUtilKt.getResolvedCall($this$hasSuspendCalls, this.getBindingContext());
                if (resolvedCall4 == null) {
                    return false;
                }
                ResolvedCall<? extends CallableDescriptor> resolvedCall5 = resolvedCall4;
                CallableDescriptor callableDescriptor = resolvedCall5.getResultingDescriptor();
                PropertyDescriptor propertyDescriptor2 = propertyDescriptor = callableDescriptor instanceof PropertyDescriptor ? (PropertyDescriptor)callableDescriptor : null;
                bl = Intrinsics.areEqual(propertyDescriptor2 != null ? DescriptorUtilsKt.getFqNameSafe(propertyDescriptor2) : null, COROUTINE_CONTEXT_FQ_NAME);
            } else {
                bl = false;
            }
        }
        return bl;
    }

    private final void report(KtCallExpression expression2) {
        Issue issue = this.getIssue();
        KtExpression ktExpression = expression2.getCalleeExpression();
        PsiElement psiElement = ktExpression instanceof PsiElement ? (PsiElement)ktExpression : null;
        if (psiElement == null) {
            psiElement = expression2;
        }
        this.report(new CodeSmell(issue, Entity.Companion.from$default(Entity.Companion, psiElement, 0, 2, null), "The `runCatching` has suspend call inside. You should either use specific `try-catch` only catching exception that you are expecting or rethrow the `CancellationException` if already caught.", null, null, 24, null));
    }

    private static final boolean visitCallExpression$shouldTraverseInside(KtCallExpression $expression, SuspendFunSwallowedCancellation this$0, PsiElement element) {
        return Intrinsics.areEqual($expression, element) || this$0.shouldTraverseInside(element, this$0.getBindingContext());
    }

    private static final boolean visitCallExpression$lambda$0(SuspendFunSwallowedCancellation this$0, KtExpression descendant) {
        Intrinsics.checkNotNullParameter(descendant, "descendant");
        return this$0.hasSuspendCalls(descendant);
    }

    public static final /* synthetic */ boolean access$visitCallExpression$shouldTraverseInside(KtCallExpression $expression, SuspendFunSwallowedCancellation this$0, PsiElement element) {
        return SuspendFunSwallowedCancellation.visitCallExpression$shouldTraverseInside($expression, this$0, element);
    }

    static {
        FqName fqName = StandardNames.COROUTINES_PACKAGE_FQ_NAME.child(Name.identifier("coroutineContext"));
        Intrinsics.checkNotNullExpressionValue(fqName, "child(...)");
        COROUTINE_CONTEXT_FQ_NAME = fqName;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lio/gitlab/arturbosch/detekt/rules/coroutines/SuspendFunSwallowedCancellation$Companion;", "", "<init>", "()V", "RUN_CATCHING_FQ", "Lorg/jetbrains/kotlin/name/FqName;", "COROUTINE_CONTEXT_FQ_NAME", "detekt-rules-coroutines"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

