/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.coroutines;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.api.internal.RequiresTypeResolution;
import io.gitlab.arturbosch.detekt.rules.TypeUtilsKt;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtClassOrObjectKt;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtConstructorDelegationCall;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.types.KotlinType;

@RequiresTypeResolution
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0007\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\f\u0010\u0017\u001a\u00020\u0018*\u00020\u0016H\u0002J\u001e\u0010\u0019\u001a\u00020\u0018*\u00020\u00162\u0006\u0010\u001a\u001a\u00020\b2\b\u0010\u001b\u001a\u0004\u0018\u00010\bH\u0002J\u001e\u0010\u001c\u001a\u00020\u0018*\u00020\u00162\u0006\u0010\u001a\u001a\u00020\b2\b\u0010\u001b\u001a\u0004\u0018\u00010\bH\u0002R'\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\r\u0010\u000e\u0012\u0004\b\t\u0010\n\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001e"}, d2={"Lio/gitlab/arturbosch/detekt/rules/coroutines/InjectDispatcher;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "dispatcherNames", "", "", "getDispatcherNames$annotations", "()V", "getDispatcherNames", "()Ljava/util/Set;", "dispatcherNames$delegate", "Lkotlin/properties/ReadOnlyProperty;", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitSimpleNameExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "isReceiverNotInjected", "", "isAClassPropertyOrConstructorParameter", "receiver", "receiverTypeFqn", "isAFunctionParameter", "Companion", "detekt-rules-coroutines"})
@SourceDebugExtension(value={"SMAP\nInjectDispatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InjectDispatcher.kt\nio/gitlab/arturbosch/detekt/rules/coroutines/InjectDispatcher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,129:1\n1755#2,3:130\n142#3:133\n142#3:134\n142#3:135\n142#3:137\n1#4:136\n*S KotlinDebug\n*F\n+ 1 InjectDispatcher.kt\nio/gitlab/arturbosch/detekt/rules/coroutines/InjectDispatcher\n*L\n67#1:130,3\n68#1:133\n69#1:134\n105#1:135\n120#1:137\n*E\n"})
public final class InjectDispatcher
extends Rule {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final ReadOnlyProperty dispatcherNames$delegate;
    @NotNull
    private final Issue issue;
    @NotNull
    private static final FqName COROUTINE_DISPATCHER_FQCN;

    public InjectDispatcher(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        String[] stringArray = new String[]{"IO", "Default", "Unconfined"};
        this.dispatcherNames$delegate = ConfigPropertyKt.config(CollectionsKt.listOf(stringArray), InjectDispatcher::dispatcherNames_delegate$lambda$0);
        this.issue = new Issue("InjectDispatcher", Severity.Defect, "Don't hardcode dispatchers when creating new coroutines or calling `withContext`. Use dependency injection for dispatchers to make testing easier.", Debt.Companion.getFIVE_MINS());
    }

    private final Set<String> getDispatcherNames() {
        return (Set)this.dispatcherNames$delegate.getValue(this, $$delegatedProperties[0]);
    }

    @Configuration(description="The names of dispatchers to detect by this rule")
    private static /* synthetic */ void getDispatcherNames$annotations() {
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression) {
        block11: {
            Intrinsics.checkNotNullParameter(expression, "expression");
            super.visitSimpleNameExpression(expression);
            if (!this.getDispatcherNames().contains(expression.getReferencedName())) {
                return;
            }
            v0 = CallUtilKt.getType(expression, this.getBindingContext());
            if (v0 == null) {
                return;
            }
            type = v0;
            if (Intrinsics.areEqual(TypeUtilsKt.fqNameOrNull(type), InjectDispatcher.COROUTINE_DISPATCHER_FQCN)) ** GOTO lbl-1000
            $this$any$iv = org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt.supertypes(type);
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v1 = false;
            } else {
                for (T element$iv : $this$any$iv) {
                    it = (KotlinType)element$iv;
                    $i$a$-any-InjectDispatcher$visitSimpleNameExpression$isCoroutineDispatcher$1 = false;
                    if (!Intrinsics.areEqual(TypeUtilsKt.fqNameOrNull(it), InjectDispatcher.COROUTINE_DISPATCHER_FQCN)) continue;
                    v1 = true;
                    break block11;
                }
                v1 = false;
            }
        }
        if (v1) lbl-1000:
        // 2 sources

        {
            v2 = true;
        } else {
            v2 = false;
        }
        isCoroutineDispatcher = v2;
        $this$getStrictParentOfType$iv = expression;
        $i$f$getStrictParentOfType = false;
        if (PsiTreeUtil.getParentOfType($this$getStrictParentOfType$iv, KtParameter.class, true) != null) ** GOTO lbl-1000
        $this$getStrictParentOfType$iv = expression;
        $i$f$getStrictParentOfType = false;
        if (PsiTreeUtil.getParentOfType($this$getStrictParentOfType$iv, KtConstructorDelegationCall.class, true) != null) lbl-1000:
        // 2 sources

        {
            v3 = true;
        } else {
            v3 = isUsedAsParameter = false;
        }
        if (isCoroutineDispatcher && !isUsedAsParameter) {
            if (this.isReceiverNotInjected(expression)) {
                return;
            }
            this.report(new CodeSmell(this.getIssue(), Entity.Companion.from$default(Entity.Companion, expression, 0, 2, null), "Dispatcher " + expression.getReferencedName() + " is used without dependency injection.", null, null, 24, null));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isReceiverNotInjected(KtSimpleNameExpression $this$isReceiverNotInjected) {
        KtExpression receiver = KtPsiUtilKt.getReceiverExpression($this$isReceiverNotInjected);
        if (receiver == null) return false;
        KotlinType kotlinType = CallUtilKt.getType(receiver, this.getBindingContext());
        if (kotlinType == null) return false;
        FqName fqName = TypeUtilsKt.fqNameOrNull(kotlinType);
        FqName receiverTypeFqn = fqName;
        if (receiverTypeFqn == null) return false;
        String string2 = receiver.getText();
        Intrinsics.checkNotNullExpressionValue(string2, "getText(...)");
        if (this.isAClassPropertyOrConstructorParameter($this$isReceiverNotInjected, string2, receiverTypeFqn.asString())) return true;
        String string3 = receiver.getText();
        Intrinsics.checkNotNullExpressionValue(string3, "getText(...)");
        if (!this.isAFunctionParameter($this$isReceiverNotInjected, string3, receiverTypeFqn.asString())) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isAClassPropertyOrConstructorParameter(KtSimpleNameExpression $this$isAClassPropertyOrConstructorParameter, String receiver, String receiverTypeFqn) {
        Object v6;
        KtParameter ktParameter;
        KtParameter property;
        KtClassOrObject enclosingClass;
        PsiElement $this$getStrictParentOfType$iv = $this$isAClassPropertyOrConstructorParameter;
        boolean $i$f$getStrictParentOfType22 = false;
        KtClassOrObject ktClassOrObject = enclosingClass = PsiTreeUtil.getParentOfType($this$getStrictParentOfType$iv, KtClassOrObject.class, true);
        KtNamedDeclaration $i$f$getStrictParentOfType22 = ktClassOrObject != null ? KtPsiUtilKt.findPropertyByName(ktClassOrObject, receiver) : null;
        KtParameter ktParameter2 = property = $i$f$getStrictParentOfType22 instanceof KtParameter ? (KtParameter)$i$f$getStrictParentOfType22 : null;
        if (property != null) {
            KtTypeReference ktTypeReference = property.getTypeReference();
            if (Intrinsics.areEqual(ktTypeReference != null ? ktTypeReference.getTypeText() : null, receiverTypeFqn)) {
                return true;
            }
        }
        KtClassOrObject ktClassOrObject2 = enclosingClass;
        Object object = ktClassOrObject2;
        if (ktClassOrObject2 == null) return false;
        List<KtConstructor<?>> list = KtClassOrObjectKt.getAllConstructors((KtClassOrObject)object);
        object = list;
        if (list == null) return false;
        Iterator iterator2 = ((Iterable)object).iterator();
        block0: do {
            if (!iterator2.hasNext()) return false;
            KtConstructor ctor = (KtConstructor)iterator2.next();
            boolean bl = false;
            Iterable iterable = ctor.getValueParameters();
            for (Object t : iterable) {
                KtParameter it = (KtParameter)t;
                boolean bl2 = false;
                if (!Intrinsics.areEqual(it.getName(), receiver)) continue;
                v6 = t;
                continue block0;
            }
            v6 = null;
        } while ((ktParameter = (KtParameter)v6) == null);
        KtParameter ktParameter3 = ktParameter;
        KtParameter ctor = ktParameter3;
        if (ctor == null) return false;
        KtTypeReference ktTypeReference = ctor.getTypeReference();
        if (!Intrinsics.areEqual(ktTypeReference != null ? ktTypeReference.getTypeText() : null, receiverTypeFqn)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isAFunctionParameter(KtSimpleNameExpression $this$isAFunctionParameter, String receiver, String receiverTypeFqn) {
        KtParameter ktParameter;
        PsiElement $this$getStrictParentOfType$iv = $this$isAFunctionParameter;
        boolean $i$f$getStrictParentOfType = false;
        KtNamedFunction enclosingFunction = PsiTreeUtil.getParentOfType($this$getStrictParentOfType$iv, KtNamedFunction.class, true);
        Object object = enclosingFunction;
        if (object != null && (object = ((KtNamedFunction)object).getValueParameters()) != null) {
            Object v1;
            block3: {
                Iterable iterable = (Iterable)object;
                for (Object t : iterable) {
                    KtParameter it = (KtParameter)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual(it.getName(), receiver)) continue;
                    v1 = t;
                    break block3;
                }
                v1 = null;
            }
            ktParameter = v1;
        } else {
            ktParameter = null;
        }
        KtParameter ktParameter2 = ktParameter;
        if (!(ktParameter2 instanceof KtParameter)) return false;
        KtParameter ktParameter3 = ktParameter2;
        KtParameter param2 = ktParameter3;
        if (param2 == null) return false;
        KtTypeReference ktTypeReference = param2.getTypeReference();
        if (!Intrinsics.areEqual(ktTypeReference != null ? ktTypeReference.getTypeText() : null, receiverTypeFqn)) return false;
        return true;
    }

    private static final Set dispatcherNames_delegate$lambda$0(List it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return CollectionsKt.toSet(it);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(InjectDispatcher.class, "dispatcherNames", "getDispatcherNames()Ljava/util/Set;", 0))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
        COROUTINE_DISPATCHER_FQCN = new FqName("kotlinx.coroutines.CoroutineDispatcher");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/gitlab/arturbosch/detekt/rules/coroutines/InjectDispatcher$Companion;", "", "<init>", "()V", "COROUTINE_DISPATCHER_FQCN", "Lorg/jetbrains/kotlin/name/FqName;", "detekt-rules-coroutines"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

