/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.complexity;

import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.DetektVisitor;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Metric;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.ThresholdedCodeSmell;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.rules.complexity.StringLiteralDuplication;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 '2\u00020\u0001:\u0002&'B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR!\u0010\n\u001a\u00020\u000b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\u0011\u0012\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000fR!\u0010\u0012\u001a\u00020\u00138BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0017\u0010\u0011\u0012\u0004\b\u0014\u0010\r\u001a\u0004\b\u0015\u0010\u0016R!\u0010\u0018\u001a\u00020\u00138BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u001b\u0010\u0011\u0012\u0004\b\u0019\u0010\r\u001a\u0004\b\u001a\u0010\u0016R!\u0010\u001c\u001a\u00020\u001d8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b!\u0010\u0011\u0012\u0004\b\u001e\u0010\r\u001a\u0004\b\u001f\u0010 \u00a8\u0006("}, d2={"Lio/gitlab/arturbosch/detekt/rules/complexity/StringLiteralDuplication;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "threshold", "", "getThreshold$annotations", "()V", "getThreshold", "()I", "threshold$delegate", "Lkotlin/properties/ReadOnlyProperty;", "ignoreAnnotation", "", "getIgnoreAnnotation$annotations", "getIgnoreAnnotation", "()Z", "ignoreAnnotation$delegate", "excludeStringsWithLessThan5Characters", "getExcludeStringsWithLessThan5Characters$annotations", "getExcludeStringsWithLessThan5Characters", "excludeStringsWithLessThan5Characters$delegate", "ignoreStringsRegex", "Lkotlin/text/Regex;", "getIgnoreStringsRegex$annotations", "getIgnoreStringsRegex", "()Lkotlin/text/Regex;", "ignoreStringsRegex$delegate", "visitKtFile", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "StringLiteralVisitor", "Companion", "detekt-rules-complexity"})
public final class StringLiteralDuplication
extends Rule {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty threshold$delegate;
    @NotNull
    private final ReadOnlyProperty ignoreAnnotation$delegate;
    @NotNull
    private final ReadOnlyProperty excludeStringsWithLessThan5Characters$delegate;
    @NotNull
    private final ReadOnlyProperty ignoreStringsRegex$delegate;
    private static final int STRING_EXCLUSION_LENGTH = 5;

    public StringLiteralDuplication(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        String string2 = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue(string2, "getSimpleName(...)");
        this.issue = new Issue(string2, Severity.Maintainability, "Multiple occurrences of the same string literal within a single file detected. Prefer extracting the string literal into a property or constant.", Debt.Companion.getFIVE_MINS());
        this.threshold$delegate = ConfigPropertyKt.config(3);
        this.ignoreAnnotation$delegate = ConfigPropertyKt.config(true);
        this.excludeStringsWithLessThan5Characters$delegate = ConfigPropertyKt.config(true);
        this.ignoreStringsRegex$delegate = ConfigPropertyKt.config("$^", ignoreStringsRegex.2.INSTANCE);
    }

    public /* synthetic */ StringLiteralDuplication(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final int getThreshold() {
        return ((Number)this.threshold$delegate.getValue(this, $$delegatedProperties[0])).intValue();
    }

    @Configuration(description="amount of duplications to trigger rule")
    private static /* synthetic */ void getThreshold$annotations() {
    }

    private final boolean getIgnoreAnnotation() {
        return (Boolean)this.ignoreAnnotation$delegate.getValue(this, $$delegatedProperties[1]);
    }

    @Configuration(description="if values in Annotations should be ignored")
    private static /* synthetic */ void getIgnoreAnnotation$annotations() {
    }

    private final boolean getExcludeStringsWithLessThan5Characters() {
        return (Boolean)this.excludeStringsWithLessThan5Characters$delegate.getValue(this, $$delegatedProperties[2]);
    }

    @Configuration(description="if short strings should be excluded")
    private static /* synthetic */ void getExcludeStringsWithLessThan5Characters$annotations() {
    }

    private final Regex getIgnoreStringsRegex() {
        return (Regex)this.ignoreStringsRegex$delegate.getValue(this, $$delegatedProperties[3]);
    }

    @Configuration(description="RegEx of Strings that should be ignored")
    private static /* synthetic */ void getIgnoreStringsRegex$annotations() {
    }

    @Override
    public void visitKtFile(@NotNull KtFile file2) {
        Intrinsics.checkNotNullParameter(file2, "file");
        StringLiteralVisitor visitor2 = new StringLiteralVisitor();
        file2.accept(visitor2);
        String type2 = "SIZE: ";
        for (Map.Entry<String, Integer> entry : visitor2.getLiteralsOverThreshold().entrySet()) {
            String name2 = entry.getKey();
            int value2 = ((Number)entry.getValue()).intValue();
            Pair<Entity, List<Entity>> pair = visitor2.entitiesForLiteral(name2);
            Entity main2 = pair.component1();
            List<Entity> references = pair.component2();
            this.report(new ThresholdedCodeSmell(this.getIssue(), main2, new Metric(type2 + name2, value2, this.getThreshold(), false, 0, 24, null), this.getIssue().getDescription(), references));
        }
    }

    public StringLiteralDuplication() {
        this((Config)null, 1, (DefaultConstructorMarker)null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(StringLiteralDuplication.class, "threshold", "getThreshold()I", 0)), Reflection.property1(new PropertyReference1Impl(StringLiteralDuplication.class, "ignoreAnnotation", "getIgnoreAnnotation()Z", 0)), Reflection.property1(new PropertyReference1Impl(StringLiteralDuplication.class, "excludeStringsWithLessThan5Characters", "getExcludeStringsWithLessThan5Characters()Z", 0)), Reflection.property1(new PropertyReference1Impl(StringLiteralDuplication.class, "ignoreStringsRegex", "getIgnoreStringsRegex()Lkotlin/text/Regex;", 0))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/gitlab/arturbosch/detekt/rules/complexity/StringLiteralDuplication$Companion;", "", "<init>", "()V", "STRING_EXCLUSION_LENGTH", "", "detekt-rules-complexity"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0006\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0010J \u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00140\u00122\u0006\u0010\u0015\u001a\u00020\u0006J\u0010\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u000bH\u0016J\u0010\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u000bH\u0002R*\u0010\u0004\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\t\u001a*\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\u0005j\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lio/gitlab/arturbosch/detekt/rules/complexity/StringLiteralDuplication$StringLiteralVisitor;", "Lio/gitlab/arturbosch/detekt/api/DetektVisitor;", "<init>", "(Lio/gitlab/arturbosch/detekt/rules/complexity/StringLiteralDuplication;)V", "literals", "Ljava/util/HashMap;", "", "", "Lkotlin/collections/HashMap;", "literalReferences", "", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "pass", "", "Lkotlin/Unit;", "getLiteralsOverThreshold", "", "entitiesForLiteral", "Lkotlin/Pair;", "Lio/gitlab/arturbosch/detekt/api/Entity;", "", "literal", "visitStringTemplateExpression", "expression", "add", "str", "detekt-rules-complexity"})
    @SourceDebugExtension(value={"SMAP\nStringLiteralDuplication.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StringLiteralDuplication.kt\nio/gitlab/arturbosch/detekt/rules/complexity/StringLiteralDuplication$StringLiteralVisitor\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 IsPartOfUtils.kt\nio/gitlab/arturbosch/detekt/rules/IsPartOfUtilsKt\n+ 5 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,127:1\n503#2,7:128\n1557#3:135\n1628#3,3:136\n10#4:139\n146#5:140\n*S KotlinDebug\n*F\n+ 1 StringLiteralDuplication.kt\nio/gitlab/arturbosch/detekt/rules/complexity/StringLiteralDuplication$StringLiteralVisitor\n*L\n92#1:128,7\n98#1:135\n98#1:136,3\n106#1:139\n106#1:140\n*E\n"})
    public final class StringLiteralVisitor
    extends DetektVisitor {
        @NotNull
        private final HashMap<String, Integer> literals = new HashMap();
        @NotNull
        private final HashMap<String, List<KtStringTemplateExpression>> literalReferences = new HashMap();
        @NotNull
        private final Unit pass = Unit.INSTANCE;

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Map<String, Integer> getLiteralsOverThreshold() {
            void $this$filterValues$iv;
            Map map2 = this.literals;
            StringLiteralDuplication stringLiteralDuplication = StringLiteralDuplication.this;
            boolean $i$f$filterValues = false;
            LinkedHashMap result$iv = new LinkedHashMap();
            for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
                int it = ((Number)entry$iv.getValue()).intValue();
                boolean bl = false;
                if (!(it >= stringLiteralDuplication.getThreshold())) continue;
                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
            }
            return result$iv;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Pair<Entity, List<Entity>> entitiesForLiteral(@NotNull String literal) {
            Intrinsics.checkNotNullParameter(literal, "literal");
            List<KtStringTemplateExpression> references = this.literalReferences.get(literal);
            if (references != null && !((Collection)references).isEmpty()) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                KtStringTemplateExpression mainEntity = references.get(0);
                List<KtStringTemplateExpression> referenceEntities = references.subList(1, references.size());
                Iterable iterable = referenceEntities;
                Entity entity = Entity.Companion.from$default(Entity.Companion, mainEntity, 0, 2, null);
                boolean $i$f$map = false;
                void var7_8 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    KtStringTemplateExpression ktStringTemplateExpression = (KtStringTemplateExpression)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(Entity.Companion.from$default(Entity.Companion, (PsiElement)it, 0, 2, null));
                }
                return TuplesKt.to(entity, (List)destination$iv$iv);
            }
            throw new IllegalStateException(("No KtElements for literal '" + literal + "' found!").toString());
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void visitStringTemplateExpression(@NotNull KtStringTemplateExpression expression2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            String text = KtPsiUtilKt.getPlainContent(expression2);
            if (StringLiteralDuplication.this.getIgnoreAnnotation()) {
                PsiElement $this$isPartOf$iv = expression2;
                boolean $i$f$isPartOf = false;
                PsiElement $this$getNonStrictParentOfType$iv$iv = $this$isPartOf$iv;
                boolean $i$f$getNonStrictParentOfType = false;
                if (PsiTreeUtil.getParentOfType($this$getNonStrictParentOfType$iv$iv, KtAnnotationEntry.class, false) != null) {
                    return;
                }
                boolean bl = false;
                if (bl) {
                    return;
                }
            }
            if (StringLiteralDuplication.this.getExcludeStringsWithLessThan5Characters() && text.length() < 5) {
                return;
            }
            CharSequence charSequence = text;
            if (StringLiteralDuplication.this.getIgnoreStringsRegex().matches(charSequence)) {
                return;
            }
            this.add(expression2);
        }

        private final void add(KtStringTemplateExpression str) {
            String text = KtPsiUtilKt.getPlainContent(str);
            this.literals.compute(text, (arg_0, arg_1) -> StringLiteralVisitor.add$lambda$3(StringLiteralVisitor::add$lambda$2, arg_0, arg_1));
            this.literalReferences.compute(text, (arg_0, arg_1) -> StringLiteralVisitor.add$lambda$5((arg_0, arg_1) -> StringLiteralVisitor.add$lambda$4(str, arg_0, arg_1), arg_0, arg_1));
        }

        private static final Integer add$lambda$2(String string2, Integer oldValue) {
            Intrinsics.checkNotNullParameter(string2, "<unused var>");
            Integer n = oldValue;
            return n != null ? n + 1 : 1;
        }

        private static final Integer add$lambda$3(Function2 $tmp0, Object p0, Object p1) {
            return (Integer)$tmp0.invoke(p0, p1);
        }

        private static final List add$lambda$4(KtStringTemplateExpression $str, String string2, List entries2) {
            List<KtStringTemplateExpression> list;
            Intrinsics.checkNotNullParameter(string2, "<unused var>");
            List<KtStringTemplateExpression> list2 = entries2;
            if (list2 != null) {
                list2.add($str);
            }
            if ((list = entries2) == null) {
                KtStringTemplateExpression[] ktStringTemplateExpressionArray = new KtStringTemplateExpression[]{$str};
                list = CollectionsKt.mutableListOf(ktStringTemplateExpressionArray);
            }
            return list;
        }

        private static final List add$lambda$5(Function2 $tmp0, Object p0, Object p1) {
            return (List)$tmp0.invoke(p0, p1);
        }
    }
}

