/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.complexity;

import io.github.detekt.metrics.LinesOfCodeKt;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Metric;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.ThresholdedCodeSmell;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedFunction;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0014J\u0010\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0014J\u0010\u0010 \u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\u0014H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR!\u0010\n\u001a\u00020\u000b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\u0011\u0012\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000fR*\u0010\u0012\u001a\u001e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u000b0\u0013j\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u000b`\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0016\u001a\u001e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u000b0\u0013j\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u000b`\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0017\u001a\u001e\u0012\u0004\u0012\u00020\u0014\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00140\u0019j\b\u0012\u0004\u0012\u00020\u0014`\u001a0\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lio/gitlab/arturbosch/detekt/rules/complexity/LongMethod;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "threshold", "", "getThreshold$annotations", "()V", "getThreshold", "()I", "threshold$delegate", "Lkotlin/properties/ReadOnlyProperty;", "functionToLinesCache", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "Lkotlin/collections/HashMap;", "functionToBodyLinesCache", "nestedFunctionTracking", "Ljava/util/IdentityHashMap;", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "preVisit", "", "root", "Lorg/jetbrains/kotlin/psi/KtFile;", "postVisit", "visitNamedFunction", "function", "detekt-rules-complexity"})
@SourceDebugExtension(value={"SMAP\nLongMethod.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LongMethod.kt\nio/gitlab/arturbosch/detekt/rules/complexity/LongMethod\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,91:1\n126#2:92\n153#2,2:93\n155#2:96\n142#3:95\n142#3:97\n1#4:98\n381#5,7:99\n1797#6,3:106\n*S KotlinDebug\n*F\n+ 1 LongMethod.kt\nio/gitlab/arturbosch/detekt/rules/complexity/LongMethod\n*L\n53#1:92\n53#1:93,2\n53#1:96\n54#1:95\n77#1:97\n82#1:99,7\n86#1:106,3\n*E\n"})
public final class LongMethod
extends Rule {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty threshold$delegate;
    @NotNull
    private final HashMap<KtNamedFunction, Integer> functionToLinesCache;
    @NotNull
    private final HashMap<KtNamedFunction, Integer> functionToBodyLinesCache;
    @NotNull
    private final IdentityHashMap<KtNamedFunction, HashSet<KtNamedFunction>> nestedFunctionTracking;

    public LongMethod(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        this.issue = new Issue("LongMethod", Severity.Maintainability, "One method should have one responsibility. Long methods tend to handle many things at once. Prefer smaller methods to make them easier to understand.", Debt.Companion.getTWENTY_MINS());
        this.threshold$delegate = ConfigPropertyKt.config(60);
        this.functionToLinesCache = new HashMap();
        this.functionToBodyLinesCache = new HashMap();
        this.nestedFunctionTracking = new IdentityHashMap();
    }

    public /* synthetic */ LongMethod(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final int getThreshold() {
        return ((Number)this.threshold$delegate.getValue(this, $$delegatedProperties[0])).intValue();
    }

    @Configuration(description="number of lines in a method to trigger the rule")
    private static /* synthetic */ void getThreshold$annotations() {
    }

    @Override
    protected void preVisit(@NotNull KtFile root) {
        Intrinsics.checkNotNullParameter(root, "root");
        this.functionToLinesCache.clear();
        this.functionToBodyLinesCache.clear();
        this.nestedFunctionTracking.clear();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void postVisit(@NotNull KtFile root) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(root, "root");
        HashMap functionToLines = new HashMap();
        Map $this$map$iv = this.functionToLinesCache;
        boolean $i$f$map = false;
        Map map2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Integer n;
            boolean isNested;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            KtNamedFunction function2 = (KtNamedFunction)entry.getKey();
            int lines = ((Number)entry.getValue()).intValue();
            PsiElement $this$getStrictParentOfType$iv = function2;
            boolean $i$f$getStrictParentOfType = false;
            boolean bl2 = isNested = PsiTreeUtil.getParentOfType($this$getStrictParentOfType$iv, KtNamedFunction.class, true) != null;
            if (isNested) {
                Map map3 = functionToLines;
                Integer n2 = this.functionToBodyLinesCache.get(function2);
                n = n2 != null ? n2 : 0;
                map3.put(function2, n);
            } else {
                n = lines;
                ((Map)functionToLines).put(function2, n);
            }
            collection.add(Unit.INSTANCE);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        for (Map.Entry entry : ((Map)functionToLines).entrySet()) {
            KtNamedFunction function3 = (KtNamedFunction)entry.getKey();
            int lines = ((Number)entry.getValue()).intValue();
            if (lines < this.getThreshold()) continue;
            this.report(new ThresholdedCodeSmell(this.getIssue(), Entity.Companion.atName(function3), new Metric("SIZE", lines, this.getThreshold(), false, 0, 24, null), "The function " + function3.getNameAsSafeName() + " is too long (" + lines + "). The maximum length is " + this.getThreshold() + '.', null, 16, null));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitNamedFunction(@NotNull KtNamedFunction function2) {
        block4: {
            void $this$fold$iv;
            Object it;
            Intrinsics.checkNotNullParameter(function2, "function");
            PsiElement $this$getStrictParentOfType$iv = function2;
            boolean $i$f$getStrictParentOfType = false;
            KtNamedFunction parentMethods = PsiTreeUtil.getParentOfType($this$getStrictParentOfType$iv, KtNamedFunction.class, true);
            KtBlockExpression ktBlockExpression = function2.getBodyBlockExpression();
            KtExpression bodyEntity = ktBlockExpression != null ? (KtExpression)ktBlockExpression : function2.getBodyExpression();
            KtExpression ktExpression = parentMethods != null ? (KtExpression)function2 : bodyEntity;
            int lines = ktExpression != null ? LinesOfCodeKt.linesOfCode$default(ktExpression, null, 1, null) : 0;
            Integer n = lines;
            ((Map)this.functionToLinesCache).put(function2, n);
            Object object = this.functionToBodyLinesCache;
            KtExpression ktExpression2 = bodyEntity;
            n = ktExpression2 != null ? LinesOfCodeKt.linesOfCode$default(ktExpression2, null, 1, null) : 0;
            object.put(function2, n);
            KtNamedFunction ktNamedFunction = parentMethods;
            if (ktNamedFunction != null) {
                Object object2;
                it = ktNamedFunction;
                boolean bl = false;
                Map $this$getOrPut$iv = this.nestedFunctionTracking;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(it);
                if (value$iv == null) {
                    boolean bl2 = false;
                    HashSet answer$iv = new HashSet();
                    $this$getOrPut$iv.put(it, answer$iv);
                    object2 = answer$iv;
                } else {
                    object2 = value$iv;
                }
                ((HashSet)object2).add(function2);
            }
            super.visitNamedFunction(function2);
            Collection<KtNamedFunction> collection = PsiTreeUtil.findChildrenOfType(function2, KtNamedFunction.class);
            Intrinsics.checkNotNullExpressionValue(collection, "findChildrenOfType(...)");
            it = collection;
            Integer initial$iv = 0;
            boolean $i$f$fold = false;
            Integer accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                void next;
                KtNamedFunction ktNamedFunction2 = (KtNamedFunction)element$iv;
                int acc = ((Number)accumulator$iv).intValue();
                boolean bl = false;
                Integer n2 = this.functionToLinesCache.get(next);
                accumulator$iv = acc + (n2 != null ? n2 : 0);
            }
            n = accumulator$iv;
            int it2 = ((Number)n).intValue();
            boolean bl = false;
            Object object3 = object = it2 > 0 ? n : null;
            if (object == null) break block4;
            it2 = ((Number)object).intValue();
            boolean bl3 = false;
            ((Map)this.functionToLinesCache).put(function2, lines - it2);
        }
    }

    public LongMethod() {
        this((Config)null, 1, (DefaultConstructorMarker)null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(LongMethod.class, "threshold", "getThreshold()I", 0))};
        $$delegatedProperties = kPropertyArray;
    }
}

