/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.bugs;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPostfixExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwnerStub;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0019H\u0016J\u000e\u0010\u001a\u001a\u0004\u0018\u00010\u001b*\u00020\u001cH\u0002J\u001a\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001b2\b\u0010\u001f\u001a\u0004\u0018\u00010\fH\u0002J\f\u0010 \u001a\u00020!*\u00020\u001bH\u0002J\u0010\u0010\"\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001bH\u0002J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001b0$2\u0006\u0010\u0016\u001a\u00020\u001cH\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\"\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006%"}, d2={"Lio/gitlab/arturbosch/detekt/rules/bugs/UselessPostfixExpression;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "properties", "", "", "getProperties", "()Ljava/util/Set;", "setProperties", "(Ljava/util/Set;)V", "visitClass", "", "klass", "Lorg/jetbrains/kotlin/psi/KtClass;", "visitReturnExpression", "expression", "Lorg/jetbrains/kotlin/psi/KtReturnExpression;", "visitBinaryExpression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "asPostFixExpression", "Lorg/jetbrains/kotlin/psi/KtPostfixExpression;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "checkPostfixExpression", "postfixExpression", "leftIdentifierText", "shouldBeReported", "", "report", "getPostfixExpressionChildren", "", "detekt-rules-errorprone"})
@SourceDebugExtension(value={"SMAP\nUselessPostfixExpression.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UselessPostfixExpression.kt\nio/gitlab/arturbosch/detekt/rules/bugs/UselessPostfixExpression\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,134:1\n1557#2:135\n1628#2,3:136\n774#2:139\n865#2,2:140\n1557#2:142\n1628#2,3:143\n774#2:147\n865#2,2:148\n1863#2,2:150\n1863#2,2:152\n1#3:146\n146#4:154\n266#4:155\n277#4,10:156\n299#4:166\n158#4:167\n3829#5:168\n4344#5,2:169\n*S KotlinDebug\n*F\n+ 1 UselessPostfixExpression.kt\nio/gitlab/arturbosch/detekt/rules/bugs/UselessPostfixExpression\n*L\n71#1:135\n71#1:136,3\n72#1:139\n72#1:140,2\n72#1:142\n72#1:143,3\n85#1:147\n85#1:148,2\n86#1:150,2\n95#1:152,2\n114#1:154\n115#1:155\n115#1:156,10\n115#1:166\n131#1:167\n132#1:168\n132#1:169,2\n*E\n"})
public final class UselessPostfixExpression
extends Rule {
    @NotNull
    private final Issue issue;
    @NotNull
    private Set<String> properties;

    public UselessPostfixExpression(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        this.issue = new Issue("UselessPostfixExpression", Severity.Defect, "The incremented or decremented value is unused. This value is replaced with the original value.", Debt.Companion.getTWENTY_MINS());
        this.properties = SetsKt.emptySet();
    }

    public /* synthetic */ UselessPostfixExpression(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    @NotNull
    public final Set<String> getProperties() {
        return this.properties;
    }

    public final void setProperties(@NotNull Set<String> set) {
        Intrinsics.checkNotNullParameter(set, "<set-?>");
        this.properties = set;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitClass(@NotNull KtClass klass) {
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        KtParameter it;
        Iterable<String> iterable;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter(klass, "klass");
        Iterable iterable2 = klass.getProperties();
        UselessPostfixExpression uselessPostfixExpression = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            KtProperty ktProperty = (KtProperty)item$iv$iv;
            iterable = destination$iv$iv;
            boolean bl = false;
            iterable.add(((KtTypeParameterListOwnerStub)((Object)it)).getName());
        }
        $this$map$iv = klass.getPrimaryConstructorParameters();
        iterable = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (KtParameter)element$iv$iv;
            boolean bl = false;
            if (!KtPsiUtilKt.isPropertyParameter(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Collection<String> collection = (List)destination$iv$iv;
        $this$filter$iv = collection;
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (KtParameter)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        collection = (List)destination$iv$iv;
        uselessPostfixExpression.properties = CollectionsKt.union(iterable, (Iterable)collection);
        super.visitClass(klass);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitReturnExpression(@NotNull KtReturnExpression expression2) {
        KtExpression ktExpression;
        KtPostfixExpression postfixExpression;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        KtExpression ktExpression2 = expression2.getReturnedExpression();
        KtPostfixExpression ktPostfixExpression = postfixExpression = ktExpression2 != null ? this.asPostFixExpression(ktExpression2) : null;
        if (postfixExpression != null && this.shouldBeReported(postfixExpression)) {
            this.report(postfixExpression);
        }
        if ((ktExpression = expression2.getReturnedExpression()) != null) {
            Object p0 = ktExpression;
            boolean $i$f$visitReturnExpression$stub_for_inlining = false;
            boolean bl2 = false;
            List<KtPostfixExpression> list = this.getPostfixExpressionChildren((KtExpression)p0);
            if (list != null) {
                void $this$forEach$iv;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                p0 = list;
                boolean $i$f$filter = false;
                void bl2 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    KtPostfixExpression it = (KtPostfixExpression)element$iv$iv;
                    boolean bl3 = false;
                    if (!this.shouldBeReported(it)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    KtPostfixExpression p02 = (KtPostfixExpression)element$iv;
                    boolean $i$f$visitReturnExpression$stub_for_inlining$4 = false;
                    boolean bl4 = false;
                    this.report(p02);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitBinaryExpression(@NotNull KtBinaryExpression expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        KtExpression ktExpression = expression2.getRight();
        KtPostfixExpression postfixExpression = ktExpression != null ? this.asPostFixExpression(ktExpression) : null;
        KtExpression ktExpression2 = expression2.getLeft();
        String leftIdentifierText = ktExpression2 != null ? ktExpression2.getText() : null;
        KtPostfixExpression ktPostfixExpression = postfixExpression;
        if (ktPostfixExpression != null) {
            KtPostfixExpression it = ktPostfixExpression;
            boolean bl2 = false;
            this.checkPostfixExpression(it, leftIdentifierText);
        }
        KtExpression ktExpression3 = expression2.getRight();
        if (ktExpression3 != null) {
            KtExpression p0 = ktExpression3;
            boolean $i$f$visitBinaryExpression$stub_for_inlining$6 = false;
            boolean bl = false;
            List<KtPostfixExpression> list = this.getPostfixExpressionChildren(p0);
            if (list != null) {
                void $this$forEach$iv;
                Iterable bl2 = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    KtPostfixExpression it = (KtPostfixExpression)element$iv;
                    boolean bl3 = false;
                    this.checkPostfixExpression(it, leftIdentifierText);
                }
            }
        }
    }

    private final KtPostfixExpression asPostFixExpression(KtExpression $this$asPostFixExpression) {
        return $this$asPostFixExpression instanceof KtPostfixExpression && (((KtPostfixExpression)$this$asPostFixExpression).getOperationToken() == KtTokens.PLUSPLUS || ((KtPostfixExpression)$this$asPostFixExpression).getOperationToken() == KtTokens.MINUSMINUS) ? (KtPostfixExpression)$this$asPostFixExpression : null;
    }

    private final void checkPostfixExpression(KtPostfixExpression postfixExpression, String leftIdentifierText) {
        PsiElement psiElement = postfixExpression.getFirstChild();
        if (Intrinsics.areEqual(leftIdentifierText, psiElement != null ? psiElement.getText() : null)) {
            this.report(postfixExpression);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean shouldBeReported(KtPostfixExpression $this$shouldBeReported) {
        boolean bl;
        KtExpression ktExpression = $this$shouldBeReported.getBaseExpression();
        String postfixReceiverName = ktExpression != null ? ktExpression.getText() : null;
        PsiElement $this$getNonStrictParentOfType$iv = $this$shouldBeReported;
        boolean $i$f$getNonStrictParentOfType2 = false;
        KtNamedFunction ktNamedFunction = PsiTreeUtil.getParentOfType($this$getNonStrictParentOfType$iv, KtNamedFunction.class, false);
        if (ktNamedFunction != null) {
            void $this$anyDescendantOfType$iv;
            PsiElement $i$f$getNonStrictParentOfType2 = ktNamedFunction;
            Function1<KtProperty, Boolean> predicate$iv = arg_0 -> UselessPostfixExpression.shouldBeReported$lambda$8(postfixReceiverName, arg_0);
            boolean $i$f$anyDescendantOfType = false;
            void $this$findDescendantOfType$iv$iv = $this$anyDescendantOfType$iv;
            boolean $i$f$findDescendantOfType = false;
            void $this$findDescendantOfType$iv$iv$iv = $this$findDescendantOfType$iv$iv;
            boolean $i$f$findDescendantOfType2 = false;
            PsiUtilsKt.checkDecompiledText((PsiElement)$this$findDescendantOfType$iv$iv$iv);
            Ref.ObjectRef result$iv$iv$iv = new Ref.ObjectRef();
            $this$findDescendantOfType$iv$iv$iv.accept(new PsiRecursiveElementWalkingVisitor(predicate$iv, result$iv$iv$iv){
                final /* synthetic */ Function1 $predicate;
                final /* synthetic */ Ref.ObjectRef $result;
                {
                    this.$predicate = $predicate;
                    this.$result = $result;
                }

                public void visitElement(PsiElement element) {
                    Intrinsics.checkNotNullParameter(element, "element");
                    if (element instanceof KtProperty && ((Boolean)this.$predicate.invoke(element)).booleanValue()) {
                        this.$result.element = element;
                        this.stopWalking();
                        return;
                    }
                    PsiElement it = element;
                    boolean bl = false;
                    super.visitElement(element);
                }
            });
            bl = (PsiElement)result$iv$iv$iv.element != null;
        } else {
            bl = !this.properties.contains(postfixReceiverName);
        }
        return bl;
    }

    private final void report(KtPostfixExpression postfixExpression) {
        this.report(new CodeSmell(this.getIssue(), Entity.Companion.from$default(Entity.Companion, postfixExpression, 0, 2, null), "The result of the postfix expression: " + postfixExpression.getText() + " will not be used and is therefore useless.", null, null, 24, null));
    }

    /*
     * WARNING - void declaration
     */
    private final List<KtPostfixExpression> getPostfixExpressionChildren(KtExpression expression2) {
        void $this$filterTo$iv$iv;
        PsiElement $this$getChildrenOfType$iv = expression2;
        boolean $i$f$getChildrenOfType = false;
        PsiElement[] psiElementArray = PsiTreeUtil.getChildrenOfType((PsiElement)$this$getChildrenOfType$iv, KtPostfixExpression.class);
        if (psiElementArray == null) {
            psiElementArray = new KtPostfixExpression[0];
        }
        PsiElement[] $this$filter$iv = psiElementArray;
        boolean $i$f$filter = false;
        PsiElement[] psiElementArray2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            KtPostfixExpression it = (KtPostfixExpression)element$iv$iv;
            boolean bl = false;
            if (!(it.getOperationToken() == KtTokens.PLUSPLUS || it.getOperationToken() == KtTokens.MINUSMINUS)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final boolean shouldBeReported$lambda$8(String $postfixReceiverName, KtProperty it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Intrinsics.areEqual(it.getName(), $postfixReceiverName);
    }

    public UselessPostfixExpression() {
        this((Config)null, 1, (DefaultConstructorMarker)null);
    }
}

