/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.bugs;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.RequiresTypeResolution;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.psi.KtCatchClause;
import org.jetbrains.kotlin.psi.KtModifierListOwnerStub;
import org.jetbrains.kotlin.psi.KtTryExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;

@RequiresTypeResolution
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u000e\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\rH\u0002J\u0014\u0010\u0010\u001a\u00020\u0011*\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Lio/gitlab/arturbosch/detekt/rules/bugs/UnreachableCatchBlock;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitCatchSection", "", "catchClause", "Lorg/jetbrains/kotlin/psi/KtCatchClause;", "catchClassDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "isSubclassOf", "", "detekt-rules-errorprone"})
@SourceDebugExtension(value={"SMAP\nUnreachableCatchBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnreachableCatchBlock.kt\nio/gitlab/arturbosch/detekt/rules/bugs/UnreachableCatchBlock\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Junk.kt\nio/gitlab/arturbosch/detekt/rules/JunkKt\n*L\n1#1,82:1\n142#2:83\n967#3,7:84\n1755#3,3:91\n40#4:94\n*S KotlinDebug\n*F\n+ 1 UnreachableCatchBlock.kt\nio/gitlab/arturbosch/detekt/rules/bugs/UnreachableCatchBlock\n*L\n63#1:83\n64#1:84,7\n67#1:91,3\n74#1:94\n*E\n"})
public final class UnreachableCatchBlock
extends Rule {
    @NotNull
    private final Issue issue;

    public UnreachableCatchBlock(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        String string2 = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue(string2, "getSimpleName(...)");
        this.issue = new Issue(string2, Severity.Warning, "Unreachable catch block detected.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ UnreachableCatchBlock(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    @Override
    public void visitCatchSection(@NotNull KtCatchClause catchClause) {
        boolean bl;
        block8: {
            List prevCatchClauses;
            KtCatchClause it;
            Intrinsics.checkNotNullParameter(catchClause, "catchClause");
            super.visitCatchSection(catchClause);
            PsiElement $this$getStrictParentOfType$iv = catchClause;
            boolean $i$f$getStrictParentOfType = false;
            KtTryExpression ktTryExpression = PsiTreeUtil.getParentOfType($this$getStrictParentOfType$iv, KtTryExpression.class, true);
            if (ktTryExpression == null) {
                return;
            }
            KtTryExpression tryExpression = ktTryExpression;
            List<KtCatchClause> list = tryExpression.getCatchClauses();
            Intrinsics.checkNotNullExpressionValue(list, "getCatchClauses(...)");
            Iterable $this$takeWhile$iv = list;
            boolean $i$f$takeWhile = false;
            ArrayList list$iv = new ArrayList();
            for (Object item$iv : $this$takeWhile$iv) {
                it = (KtCatchClause)item$iv;
                boolean bl2 = false;
                if (!(!Intrinsics.areEqual(it, catchClause))) break;
                list$iv.add(item$iv);
            }
            if ((prevCatchClauses = (List)list$iv).isEmpty()) {
                return;
            }
            ClassDescriptor classDescriptor = this.catchClassDescriptor(catchClause);
            if (classDescriptor == null) {
                return;
            }
            ClassDescriptor catchClassDescriptor = classDescriptor;
            Iterable $this$any$iv = prevCatchClauses;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (KtCatchClause)element$iv;
                    boolean bl3 = false;
                    Intrinsics.checkNotNull(it);
                    if (!this.isSubclassOf(catchClassDescriptor, it)) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        if (bl) {
            this.report(new CodeSmell(this.getIssue(), Entity.Companion.from$default(Entity.Companion, catchClause, 0, 2, null), "This catch block is unreachable.", null, null, 24, null));
        }
    }

    private final ClassDescriptor catchClassDescriptor(KtCatchClause $this$catchClassDescriptor) {
        ClassDescriptor classDescriptor;
        KtModifierListOwnerStub ktModifierListOwnerStub = $this$catchClassDescriptor.getCatchParameter();
        if (ktModifierListOwnerStub == null || (ktModifierListOwnerStub = ktModifierListOwnerStub.getTypeReference()) == null) {
            return null;
        }
        KtModifierListOwnerStub typeReference = ktModifierListOwnerStub;
        Object object = (KotlinType)this.getBindingContext().get(BindingContext.TYPE, typeReference);
        if (object != null && (object = ((KotlinType)object).getConstructor()) != null && (object = object.getDeclarationDescriptor()) != null) {
            Object $this$safeAs$iv = object;
            boolean $i$f$safeAs = false;
            Object object2 = $this$safeAs$iv;
            if (!(object2 instanceof ClassDescriptor)) {
                object2 = null;
            }
            classDescriptor = (ClassDescriptor)object2;
        } else {
            classDescriptor = null;
        }
        return classDescriptor;
    }

    private final boolean isSubclassOf(ClassDescriptor $this$isSubclassOf, KtCatchClause catchClause) {
        ClassDescriptor classDescriptor = this.catchClassDescriptor(catchClause);
        if (classDescriptor == null) {
            return false;
        }
        ClassDescriptor catchClassDescriptor = classDescriptor;
        return DescriptorUtilsKt.isSubclassOf($this$isSubclassOf, catchClassDescriptor);
    }

    public UnreachableCatchBlock() {
        this((Config)null, 1, (DefaultConstructorMarker)null);
    }
}

