/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.bugs;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.RequiresTypeResolution;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;

@RequiresTypeResolution
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lio/gitlab/arturbosch/detekt/rules/bugs/UnnecessaryNotNullOperator;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitUnaryExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtUnaryExpression;", "detekt-rules-errorprone"})
@SourceDebugExtension(value={"SMAP\nUnnecessaryNotNullOperator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnnecessaryNotNullOperator.kt\nio/gitlab/arturbosch/detekt/rules/bugs/UnnecessaryNotNullOperator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,55:1\n1755#2,3:56\n*S KotlinDebug\n*F\n+ 1 UnnecessaryNotNullOperator.kt\nio/gitlab/arturbosch/detekt/rules/bugs/UnnecessaryNotNullOperator\n*L\n43#1:56,3\n*E\n"})
public final class UnnecessaryNotNullOperator
extends Rule {
    @NotNull
    private final Issue issue;

    public UnnecessaryNotNullOperator(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        this.issue = new Issue("UnnecessaryNotNullOperator", Severity.Defect, "Unnecessary not-null unary operator (!!) detected.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ UnnecessaryNotNullOperator(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    @Override
    public void visitUnaryExpression(@NotNull KtUnaryExpression expression2) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            super.visitUnaryExpression(expression2);
            Diagnostics diagnostics = this.getBindingContext().getDiagnostics();
            KtSimpleNameExpression ktSimpleNameExpression = expression2.getOperationReference();
            Intrinsics.checkNotNullExpressionValue(ktSimpleNameExpression, "getOperationReference(...)");
            Collection<Diagnostic> compilerReports = diagnostics.forElement(ktSimpleNameExpression);
            Iterable $this$any$iv = compilerReports;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Diagnostic it = (Diagnostic)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual(it.getFactory(), Errors.UNNECESSARY_NOT_NULL_ASSERTION)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (bl) {
            this.report(new CodeSmell(this.getIssue(), Entity.Companion.from$default(Entity.Companion, expression2, 0, 2, null), expression2.getText() + " contains an unnecessary not-null (!!) operators", null, null, 24, null));
        }
    }

    public UnnecessaryNotNullOperator() {
        this((Config)null, 1, (DefaultConstructorMarker)null);
    }
}

