/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.bugs;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.CompilerResources;
import io.gitlab.arturbosch.detekt.api.internal.RequiresTypeResolution;
import io.gitlab.arturbosch.detekt.rules.KtCallExpressionKt;
import io.gitlab.arturbosch.detekt.rules.TypeUtilsKt;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;

@RequiresTypeResolution
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000f"}, d2={"Lio/gitlab/arturbosch/detekt/rules/bugs/UnnecessaryNotNullCheck;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitCallExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "Companion", "detekt-rules-errorprone"})
@SourceDebugExtension(value={"SMAP\nUnnecessaryNotNullCheck.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnnecessaryNotNullCheck.kt\nio/gitlab/arturbosch/detekt/rules/bugs/UnnecessaryNotNullCheck\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,73:1\n1734#2,3:74\n*S KotlinDebug\n*F\n+ 1 UnnecessaryNotNullCheck.kt\nio/gitlab/arturbosch/detekt/rules/bugs/UnnecessaryNotNullCheck\n*L\n55#1:74,3\n*E\n"})
public final class UnnecessaryNotNullCheck
extends Rule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Issue issue;
    @NotNull
    private static final List<FqName> notNullCheckFunctionFqNames;

    public UnnecessaryNotNullCheck(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        this.issue = new Issue("UnnecessaryNotNullCheck", Severity.Defect, "Remove unnecessary not-null checks on non-null types.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ UnnecessaryNotNullCheck(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    @Override
    public void visitCallExpression(@NotNull KtCallExpression expression2) {
        boolean bl;
        KtElement argument;
        KtExpression callee;
        block8: {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            super.visitCallExpression(expression2);
            CompilerResources compilerResources = this.getCompilerResources();
            if (compilerResources == null) {
                return;
            }
            CompilerResources compilerResources2 = compilerResources;
            KtExpression ktExpression = expression2.getCalleeExpression();
            if (ktExpression == null) {
                return;
            }
            callee = ktExpression;
            List<KtValueArgument> list = expression2.getValueArguments();
            Intrinsics.checkNotNullExpressionValue(list, "getValueArguments(...)");
            KtElement ktElement = CollectionsKt.firstOrNull(list);
            if (ktElement == null || (ktElement = ((KtValueArgument)ktElement).getArgumentExpression()) == null) {
                return;
            }
            argument = ktElement;
            if (!KtCallExpressionKt.isCalling(expression2, notNullCheckFunctionFqNames, this.getBindingContext())) {
                return;
            }
            Set dataFlowAwareTypes = TypeUtilsKt.getDataFlowAwareTypes$default((KtExpression)argument, this.getBindingContext(), compilerResources2.getLanguageVersionSettings(), compilerResources2.getDataFlowValueFactory(), null, 8, null);
            Iterable $this$all$iv = dataFlowAwareTypes;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    KotlinType it = (KotlinType)element$iv;
                    boolean bl2 = false;
                    if (KotlinTypeKt.isNullable(it)) continue;
                    bl = false;
                    break block8;
                }
                bl = true;
            }
        }
        if (bl) {
            return;
        }
        this.report(new CodeSmell(this.getIssue(), Entity.Companion.from$default(Entity.Companion, expression2, 0, 2, null), "Using `" + callee.getText() + "` on non-null `" + argument.getText() + "` is unnecessary", null, null, 24, null));
    }

    public UnnecessaryNotNullCheck() {
        this((Config)null, 1, (DefaultConstructorMarker)null);
    }

    static {
        FqName[] fqNameArray = new FqName[]{new FqName("kotlin.requireNotNull"), new FqName("kotlin.checkNotNull")};
        notNullCheckFunctionFqNames = CollectionsKt.listOf(fqNameArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lio/gitlab/arturbosch/detekt/rules/bugs/UnnecessaryNotNullCheck$Companion;", "", "<init>", "()V", "notNullCheckFunctionFqNames", "", "Lorg/jetbrains/kotlin/name/FqName;", "detekt-rules-errorprone"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

