/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.bugs;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.RequiresTypeResolution;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiRecursiveElementVisitor;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.utils.CollectionsKt;

@RequiresTypeResolution
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u000e\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\u0010H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0011"}, d2={"Lio/gitlab/arturbosch/detekt/rules/bugs/PropertyUsedBeforeDeclaration;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitClassOrObject", "", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "Lorg/jetbrains/kotlin/psi/KtNameReferenceExpression;", "detekt-rules-errorprone"})
@SourceDebugExtension(value={"SMAP\nPropertyUsedBeforeDeclaration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PropertyUsedBeforeDeclaration.kt\nio/gitlab/arturbosch/detekt/rules/bugs/PropertyUsedBeforeDeclaration\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,90:1\n4154#2:91\n4254#2,2:92\n808#3,11:94\n1611#3,9:105\n1863#3:114\n1864#3:116\n1620#3:117\n1863#3:118\n1864#3:129\n1#4:115\n222#5,9:119\n241#5:128\n*S KotlinDebug\n*F\n+ 1 PropertyUsedBeforeDeclaration.kt\nio/gitlab/arturbosch/detekt/rules/bugs/PropertyUsedBeforeDeclaration\n*L\n65#1:91\n65#1:92,2\n67#1:94,11\n67#1:105,9\n67#1:114\n67#1:116\n67#1:117\n75#1:118\n75#1:129\n67#1:115\n76#1:119,9\n76#1:128\n*E\n"})
public final class PropertyUsedBeforeDeclaration
extends Rule {
    @NotNull
    private final Issue issue;

    public PropertyUsedBeforeDeclaration(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        String string2 = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue(string2, "getSimpleName(...)");
        this.issue = new Issue(string2, Severity.Defect, "Properties before declaration should not be used.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ PropertyUsedBeforeDeclaration(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitClassOrObject(@NotNull KtClassOrObject classOrObject) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Collection destination$iv$iv;
        Object $this$filterNot$iv;
        Intrinsics.checkNotNullParameter(classOrObject, "classOrObject");
        super.visitClassOrObject(classOrObject);
        PsiElement[] psiElementArray = classOrObject.getBody();
        if (psiElementArray != null && (psiElementArray = psiElementArray.getChildren()) != null) {
            void $this$filterNotTo$iv$iv;
            $this$filterNot$iv = psiElementArray;
            boolean $i$f$filterNot = false;
            PsiElement[] psiElementArray2 = $this$filterNot$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                void it = element$iv$iv;
                boolean bl = false;
                if (it instanceof KtClassOrObject) continue;
                destination$iv$iv.add(element$iv$iv);
            }
        } else {
            return;
        }
        List classMembers = (List)destination$iv$iv;
        Iterable $this$filterIsInstance$iv = classMembers;
        boolean $i$f$filterIsInstance = false;
        $this$filterNot$iv = $this$filterIsInstance$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof KtProperty)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv2;
        boolean $i$f$mapNotNull = false;
        $this$filterIsInstanceTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Object object = $this$forEach$iv$iv$iv.iterator();
        while (object.hasNext()) {
            Pair<String, DeclarationDescriptor> it$iv$iv;
            DeclarationDescriptor descriptor2;
            String name2;
            Object element$iv$iv$iv;
            Object element$iv$iv;
            element$iv$iv = element$iv$iv$iv = object.next();
            boolean bl = false;
            KtProperty it = (KtProperty)element$iv$iv;
            boolean bl2 = false;
            if ((it.getName() == null ? null : (this.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, it) == null ? null : TuplesKt.to(name2, descriptor2))) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        Map allProperties = MapsKt.toMap((List)destination$iv$iv2);
        Set declaredProperties = new LinkedHashSet();
        Iterable $this$forEach$iv = classMembers;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$forEachDescendantOfType$iv;
            PsiElement member = (PsiElement)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(member);
            object = member;
            Function1<KtNameReferenceExpression, Unit> action$iv = arg_0 -> PropertyUsedBeforeDeclaration.visitClassOrObject$lambda$3$lambda$2(allProperties, declaredProperties, this, arg_0);
            boolean $i$f$forEachDescendantOfType = false;
            void $this$forEachDescendantOfType$iv$iv = $this$forEachDescendantOfType$iv;
            boolean $i$f$forEachDescendantOfType2 = false;
            PsiUtilsKt.checkDecompiledText((PsiElement)$this$forEachDescendantOfType$iv$iv);
            $this$forEachDescendantOfType$iv$iv.accept(new PsiRecursiveElementVisitor(action$iv){
                final /* synthetic */ Function1 $action;
                {
                    this.$action = $action;
                }

                public void visitElement(PsiElement element) {
                    Intrinsics.checkNotNullParameter(element, "element");
                    PsiElement it = element;
                    boolean bl = false;
                    super.visitElement(element);
                    if (element instanceof KtNameReferenceExpression) {
                        this.$action.invoke(element);
                    }
                }
            });
            if (!(member instanceof KtProperty)) continue;
            CollectionsKt.addIfNotNull(declaredProperties, allProperties.get(((KtProperty)member).getName()));
        }
    }

    private final CallableDescriptor descriptor(KtNameReferenceExpression $this$descriptor) {
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall($this$descriptor, this.getBindingContext());
        return resolvedCall2 != null ? resolvedCall2.getResultingDescriptor() : null;
    }

    private static final Unit visitClassOrObject$lambda$3$lambda$2(Map $allProperties, Set $declaredProperties, PropertyUsedBeforeDeclaration this$0, KtNameReferenceExpression it) {
        Intrinsics.checkNotNullParameter(it, "it");
        DeclarationDescriptor property = (DeclarationDescriptor)$allProperties.get(it.getText());
        if (property != null && !$declaredProperties.contains(property) && Intrinsics.areEqual(property, this$0.descriptor(it))) {
            this$0.report(new CodeSmell(this$0.getIssue(), Entity.Companion.from$default(Entity.Companion, it, 0, 2, null), '\'' + it.getText() + "' is before declaration.", null, null, 24, null));
        }
        return Unit.INSTANCE;
    }

    public PropertyUsedBeforeDeclaration() {
        this((Config)null, 1, (DefaultConstructorMarker)null);
    }
}

