/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.bugs;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.CompilerResources;
import io.gitlab.arturbosch.detekt.api.internal.RequiresTypeResolution;
import io.gitlab.arturbosch.detekt.rules.KtCallExpressionKt;
import io.gitlab.arturbosch.detekt.rules.TypeUtilsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@RequiresTypeResolution
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\f\u0010\u000e\u001a\u00020\u000f*\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0015"}, d2={"Lio/gitlab/arturbosch/detekt/rules/bugs/NullableToStringCall;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitSimpleNameExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "hasNullableExpression", "", "Lorg/jetbrains/kotlin/psi/KtStringTemplateEntry;", "report", "element", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "Companion", "detekt-rules-errorprone"})
public final class NullableToStringCall
extends Rule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Issue issue;
    @NotNull
    private static final FqName toString = new FqName("kotlin.toString");

    public NullableToStringCall(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        String string2 = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue(string2, "getSimpleName(...)");
        this.issue = new Issue(string2, Severity.Defect, "`toString()` on nullable receiver may return the string \"null\"", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ NullableToStringCall(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    @Override
    public void visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression2) {
        KtExpression ktExpression;
        KtQualifiedExpression qualifiedExpression;
        KtCallExpression callExpression;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        super.visitSimpleNameExpression(expression2);
        PsiElement psiElement = expression2.getParent();
        KtCallExpression ktCallExpression = callExpression = psiElement instanceof KtCallExpression ? (KtCallExpression)psiElement : null;
        KtQualifiedExpression ktQualifiedExpression = qualifiedExpression = KtPsiUtilKt.getQualifiedExpressionForSelector(ktCallExpression != null ? (KtReferenceExpression)ktCallExpression : (KtReferenceExpression)expression2);
        if (ktQualifiedExpression != null) {
            ktExpression = ktQualifiedExpression;
        } else {
            KtCallExpression ktCallExpression2 = callExpression;
            ktExpression = ktCallExpression2 != null ? (KtExpression)ktCallExpression2 : (KtExpression)expression2;
        }
        PsiElement psiElement2 = ktExpression.getParent();
        KtStringTemplateEntry stringTemplateEntry = psiElement2 instanceof KtStringTemplateEntry ? (KtStringTemplateEntry)psiElement2 : null;
        KtCallExpression ktCallExpression3 = callExpression;
        boolean bl = ktCallExpression3 != null ? KtCallExpressionKt.isCalling(ktCallExpression3, toString, this.getBindingContext()) : false;
        if (bl) {
            KtQualifiedExpression ktQualifiedExpression2 = qualifiedExpression;
            this.report(ktQualifiedExpression2 != null ? (KtExpression)ktQualifiedExpression2 : (KtExpression)callExpression);
        } else {
            KtStringTemplateEntry ktStringTemplateEntry = stringTemplateEntry;
            boolean bl2 = ktStringTemplateEntry != null ? this.hasNullableExpression(ktStringTemplateEntry) : false;
            if (bl2) {
                this.report(stringTemplateEntry);
            }
        }
    }

    private final boolean hasNullableExpression(KtStringTemplateEntry $this$hasNullableExpression) {
        KtExpression ktExpression = $this$hasNullableExpression.getExpression();
        if (ktExpression == null) {
            return false;
        }
        KtExpression expression2 = ktExpression;
        CompilerResources compilerResources = super.getCompilerResources();
        if (compilerResources == null) {
            return false;
        }
        CompilerResources compilerResources2 = compilerResources;
        return TypeUtilsKt.isNullable(expression2, this.getBindingContext(), compilerResources2.getLanguageVersionSettings(), compilerResources2.getDataFlowValueFactory(), false);
    }

    private final void report(PsiElement element) {
        CodeSmell codeSmell = new CodeSmell(this.getIssue(), Entity.Companion.from$default(Entity.Companion, element, 0, 2, null), "This call '" + element.getText() + "' may return the string \"null\".", null, null, 24, null);
        this.report(codeSmell);
    }

    public NullableToStringCall() {
        this((Config)null, 1, (DefaultConstructorMarker)null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lio/gitlab/arturbosch/detekt/rules/bugs/NullableToStringCall$Companion;", "", "<init>", "()V", "toString", "Lorg/jetbrains/kotlin/name/FqName;", "getToString", "()Lorg/jetbrains/kotlin/name/FqName;", "detekt-rules-errorprone"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FqName getToString() {
            return toString;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

