/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.bugs;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.DetektVisitor;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.RequiresTypeResolution;
import io.gitlab.arturbosch.detekt.rules.KtBinaryExpressionKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.UtilsKt;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@RequiresTypeResolution
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\u000eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000f"}, d2={"Lio/gitlab/arturbosch/detekt/rules/bugs/NullCheckOnMutableProperty;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitKtFile", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "NullCheckVisitor", "detekt-rules-errorprone"})
public final class NullCheckOnMutableProperty
extends Rule {
    @NotNull
    private final Issue issue;

    public NullCheckOnMutableProperty(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        String string2 = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue(string2, "getSimpleName(...)");
        this.issue = new Issue(string2, Severity.Defect, "Checking nullability on a mutable property is not useful because the property may be set to null afterwards.", Debt.Companion.getTEN_MINS());
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    @Override
    public void visitKtFile(@NotNull KtFile file2) {
        Intrinsics.checkNotNullParameter(file2, "file");
        super.visitKtFile(file2);
        new NullCheckVisitor().visitKtFile(file2);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\nH\u0016J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0015H\u0016J\u0012\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017*\u00020\u0018H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lio/gitlab/arturbosch/detekt/rules/bugs/NullCheckOnMutableProperty$NullCheckVisitor;", "Lio/gitlab/arturbosch/detekt/api/DetektVisitor;", "<init>", "(Lio/gitlab/arturbosch/detekt/rules/bugs/NullCheckOnMutableProperty;)V", "mutableProperties", "", "Lorg/jetbrains/kotlin/name/FqName;", "candidateProperties", "", "", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "visitPrimaryConstructor", "", "constructor", "Lorg/jetbrains/kotlin/psi/KtPrimaryConstructor;", "visitProperty", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "visitIfExpression", "expression", "visitReferenceExpression", "Lorg/jetbrains/kotlin/psi/KtReferenceExpression;", "collectNonNullChecks", "", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "detekt-rules-errorprone"})
    @SourceDebugExtension(value={"SMAP\nNullCheckOnMutableProperty.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NullCheckOnMutableProperty.kt\nio/gitlab/arturbosch/detekt/rules/bugs/NullCheckOnMutableProperty$NullCheckVisitor\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,157:1\n1317#2,2:158\n1611#3,9:160\n1863#3:169\n1864#3:179\n1620#3:180\n1863#3,2:181\n1#4:170\n1#4:178\n381#5,7:171\n*S KotlinDebug\n*F\n+ 1 NullCheckOnMutableProperty.kt\nio/gitlab/arturbosch/detekt/rules/bugs/NullCheckOnMutableProperty$NullCheckVisitor\n*L\n77#1:158,2\n94#1:160,9\n94#1:169\n94#1:179\n94#1:180\n114#1:181,2\n94#1:178\n106#1:171,7\n*E\n"})
    private final class NullCheckVisitor
    extends DetektVisitor {
        @NotNull
        private final Set<FqName> mutableProperties = new LinkedHashSet();
        @NotNull
        private final Map<FqName, List<KtIfExpression>> candidateProperties = new LinkedHashMap();

        /*
         * WARNING - void declaration
         */
        @Override
        public void visitPrimaryConstructor(@NotNull KtPrimaryConstructor constructor) {
            void $this$forEach$iv;
            Intrinsics.checkNotNullParameter(constructor, "constructor");
            super.visitPrimaryConstructor(constructor);
            Sequence<FqName> sequence2 = SequencesKt.mapNotNull(SequencesKt.filter(CollectionsKt.asSequence((Iterable)constructor.getValueParameters()), NullCheckVisitor::visitPrimaryConstructor$lambda$0), NullCheckVisitor::visitPrimaryConstructor$lambda$1);
            Set<FqName> set = this.mutableProperties;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FqName p0 = (FqName)element$iv;
                boolean bl = false;
                set.add(p0);
            }
        }

        @Override
        public void visitProperty(@NotNull KtProperty property) {
            Intrinsics.checkNotNullParameter(property, "property");
            super.visitProperty(property);
            FqName fqName = property.getFqName();
            if (fqName != null && (property.isVar() || property.getGetter() != null)) {
                this.mutableProperties.add(fqName);
            }
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        @Override
        public void visitIfExpression(@NotNull KtIfExpression expression) {
            Intrinsics.checkNotNullParameter(expression, "expression");
            var4_2 = expression.getCondition();
            var3_3 = var4_2 instanceof KtBinaryExpression != false ? (KtBinaryExpression)var4_2 : null;
            v0 /* !! */  = var3_3 != null ? this.collectNonNullChecks(var3_3) : null;
            if (v0 /* !! */  == null) {
                v0 /* !! */  = CollectionsKt.emptyList();
            }
            nonNullChecks = v0 /* !! */ ;
            var4_2 = nonNullChecks;
            var5_5 = NullCheckOnMutableProperty.this;
            $i$f$mapNotNull = false;
            var7_9 = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$mapNotNullTo = false;
            $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            $i$f$forEach = false;
            var12_14 = $this$forEach$iv$iv$iv.iterator();
            while (var12_14.hasNext()) {
                element$iv$iv = element$iv$iv$iv = var12_14.next();
                $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                nonNullCondition = (KtBinaryExpression)element$iv$iv;
                $i$a$-mapNotNull-NullCheckOnMutableProperty$NullCheckVisitor$visitIfExpression$modifiedCandidateQueues$1 = false;
                v1 = nonNullCondition.getLeft() instanceof KtConstantExpression ? ((var18_20 = nonNullCondition.getRight()) instanceof KtNameReferenceExpression ? (KtNameReferenceExpression)var18_20 : null) : (var19_21 = (var18_20 = nonNullCondition.getLeft()) instanceof KtNameReferenceExpression != false ? (KtNameReferenceExpression)var18_20 : null);
                if (var19_21 == null || (var18_20 = CallUtilKt.getResolvedCall(var19_21, var5_5.getBindingContext())) == null || (var20_22 = var18_20.getResultingDescriptor()) == null || (var21_23 = DescriptorUtilsKt.fqNameOrNull((DeclarationDescriptor)var20_22)) == null) ** GOTO lbl-1000
                var22_24 = var21_23;
                var23_25 = this.mutableProperties;
                p0 = var22_24;
                $i$a$-takeIf-NullCheckOnMutableProperty$NullCheckVisitor$visitIfExpression$modifiedCandidateQueues$1$1 = false;
                $i$f$visitIfExpression$lambda$5$stub_for_inlining = false;
                v2 = var27_32 = var23_25.contains(p0) != false ? var22_24 : null;
                if (var27_32 != null) {
                    candidateFqName = var27_32;
                    $i$a$-let-NullCheckOnMutableProperty$NullCheckVisitor$visitIfExpression$modifiedCandidateQueues$1$2 = false;
                    $this$getOrPut$iv = this.candidateProperties;
                    $i$f$getOrPut = false;
                    value$iv = $this$getOrPut$iv.get(candidateFqName);
                    if (value$iv == null) {
                        $i$a$-getOrPut-NullCheckOnMutableProperty$NullCheckVisitor$visitIfExpression$modifiedCandidateQueues$1$2$1 = false;
                        answer$iv = new ArrayDeque<E>();
                        $this$getOrPut$iv.put(candidateFqName, answer$iv);
                        v3 = answer$iv;
                    } else {
                        v3 = value$iv;
                    }
                    $this$visitIfExpression_u24lambda_u245_u24lambda_u244_u24lambda_u243 = var25_29 = v3;
                    $i$a$-apply-NullCheckOnMutableProperty$NullCheckVisitor$visitIfExpression$modifiedCandidateQueues$1$2$2 = false;
                    $this$visitIfExpression_u24lambda_u245_u24lambda_u244_u24lambda_u243.add((KtIfExpression)expression);
                    v4 = var25_29;
                } else lbl-1000:
                // 2 sources

                {
                    v4 = null;
                }
                if (v4 == null) continue;
                it$iv$iv = v4;
                $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
                destination$iv$iv.add(it$iv$iv);
            }
            modifiedCandidateQueues = (List)destination$iv$iv;
            super.visitIfExpression(expression);
            $this$forEach$iv = modifiedCandidateQueues;
            $i$f$forEach = false;
            for (T element$iv : $this$forEach$iv) {
                it = (List)element$iv;
                $i$a$-forEach-NullCheckOnMutableProperty$NullCheckVisitor$visitIfExpression$1 = false;
                UtilsKt.pop(it);
            }
        }

        @Override
        public void visitReferenceExpression(@NotNull KtReferenceExpression expression2) {
            block2: {
                FqName fqName;
                CallableDescriptor callableDescriptor;
                Intrinsics.checkNotNullParameter(expression2, "expression");
                super.visitReferenceExpression(expression2);
                ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(expression2, NullCheckOnMutableProperty.this.getBindingContext());
                if (resolvedCall2 == null || (callableDescriptor = resolvedCall2.getResultingDescriptor()) == null || (fqName = DescriptorUtilsKt.fqNameOrNull(callableDescriptor)) == null) break block2;
                FqName fqName2 = fqName;
                NullCheckOnMutableProperty nullCheckOnMutableProperty = NullCheckOnMutableProperty.this;
                FqName fqName3 = fqName2;
                boolean bl = false;
                PsiElement expressionParent = expression2.getParent();
                if (!(expressionParent instanceof KtBinaryExpression) || !KtBinaryExpressionKt.isNonNullCheck((KtBinaryExpression)expressionParent) && !KtBinaryExpressionKt.isNullCheck((KtBinaryExpression)expressionParent)) {
                    List<KtIfExpression> list = this.candidateProperties.get(fqName3);
                    if (list != null && (list = UtilsKt.peek(list)) != null) {
                        List<KtIfExpression> ifExpression = list;
                        boolean bl2 = false;
                        nullCheckOnMutableProperty.report(new CodeSmell(nullCheckOnMutableProperty.getIssue(), Entity.Companion.from$default(Entity.Companion, (PsiElement)((Object)ifExpression), 0, 2, null), "Null-check is being called on mutable property '" + fqName3 + "'.", null, null, 24, null));
                    }
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private final List<KtBinaryExpression> collectNonNullChecks(KtBinaryExpression $this$collectNonNullChecks) {
            List<KtBinaryExpression> list;
            if (KtBinaryExpressionKt.isNonNullCheck($this$collectNonNullChecks)) {
                list = CollectionsKt.listOf($this$collectNonNullChecks);
            } else {
                void var2_2;
                KtBinaryExpression it;
                List nonNullChecks = new ArrayList();
                KtExpression ktExpression = $this$collectNonNullChecks.getLeft();
                KtBinaryExpression ktBinaryExpression = ktExpression instanceof KtBinaryExpression ? (KtBinaryExpression)ktExpression : null;
                if (ktBinaryExpression != null) {
                    it = ktBinaryExpression;
                    boolean bl = false;
                    nonNullChecks.addAll((Collection)this.collectNonNullChecks(it));
                }
                ktExpression = $this$collectNonNullChecks.getRight();
                KtBinaryExpression ktBinaryExpression2 = ktExpression instanceof KtBinaryExpression ? (KtBinaryExpression)ktExpression : null;
                if (ktBinaryExpression2 != null) {
                    it = ktBinaryExpression2;
                    boolean bl = false;
                    nonNullChecks.addAll((Collection)this.collectNonNullChecks(it));
                }
                list = var2_2;
            }
            return list;
        }

        private static final boolean visitPrimaryConstructor$lambda$0(KtParameter it) {
            return it.isMutable();
        }

        private static final FqName visitPrimaryConstructor$lambda$1(KtParameter it) {
            return it.getFqName();
        }
    }
}

