/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.bugs;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.rules.bugs.ImplicitDefaultLocaleKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSafeQualifiedExpression;
import org.jetbrains.kotlin.resolve.calls.util.PsiUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0011H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Lio/gitlab/arturbosch/detekt/rules/bugs/ImplicitDefaultLocale;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitDotQualifiedExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;", "visitSafeQualifiedExpression", "Lorg/jetbrains/kotlin/psi/KtSafeQualifiedExpression;", "checkStringFormatting", "Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;", "detekt-rules-errorprone"})
public final class ImplicitDefaultLocale
extends Rule {
    @NotNull
    private final Issue issue;

    public ImplicitDefaultLocale(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        this.issue = new Issue("ImplicitDefaultLocale", Severity.CodeSmell, "Implicit default locale used for string processing. Consider using explicit locale.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ ImplicitDefaultLocale(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    @Override
    public void visitDotQualifiedExpression(@NotNull KtDotQualifiedExpression expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        super.visitDotQualifiedExpression(expression2);
        this.checkStringFormatting(expression2);
    }

    @Override
    public void visitSafeQualifiedExpression(@NotNull KtSafeQualifiedExpression expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        super.visitSafeQualifiedExpression(expression2);
        this.checkStringFormatting(expression2);
    }

    private final void checkStringFormatting(KtQualifiedExpression expression2) {
        if (Intrinsics.areEqual(expression2.getReceiverExpression().getText(), "String")) {
            KtExpression ktExpression = PsiUtilsKt.getCalleeExpressionIfAny(expression2);
            if (Intrinsics.areEqual(ktExpression != null ? ktExpression.getText() : null, "format") && ImplicitDefaultLocaleKt.access$containsStringTemplate(expression2)) {
                this.report(new CodeSmell(this.getIssue(), Entity.Companion.from$default(Entity.Companion, expression2, 0, 2, null), expression2.getText() + " uses implicitly default locale for string formatting.", null, null, 24, null));
            }
        }
    }

    public ImplicitDefaultLocale() {
        this((Config)null, 1, (DefaultConstructorMarker)null);
    }
}

