/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.bugs;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.RequiresTypeResolution;
import io.gitlab.arturbosch.detekt.rules.MethodSignatureKt;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@RequiresTypeResolution
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000f"}, d2={"Lio/gitlab/arturbosch/detekt/rules/bugs/ExitOutsideMain;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitCallExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "Companion", "detekt-rules-errorprone"})
@SourceDebugExtension(value={"SMAP\nExitOutsideMain.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExitOutsideMain.kt\nio/gitlab/arturbosch/detekt/rules/bugs/ExitOutsideMain\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,77:1\n142#2:78\n*S KotlinDebug\n*F\n+ 1 ExitOutsideMain.kt\nio/gitlab/arturbosch/detekt/rules/bugs/ExitOutsideMain\n*L\n60#1:78\n*E\n"})
public final class ExitOutsideMain
extends Rule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Issue issue;
    @NotNull
    private static final Set<String> exitCalls;

    public ExitOutsideMain(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        String string2 = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue(string2, "getSimpleName(...)");
        this.issue = new Issue(string2, Severity.Warning, "Do not directly exit the process outside the `main` function. Throw an exception instead.", Debt.Companion.getTEN_MINS());
    }

    public /* synthetic */ ExitOutsideMain(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    @Override
    public void visitCallExpression(@NotNull KtCallExpression expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        super.visitCallExpression(expression2);
        PsiElement $this$getStrictParentOfType$iv = expression2;
        boolean $i$f$getStrictParentOfType = false;
        KtNamedFunction ktNamedFunction = PsiTreeUtil.getParentOfType($this$getStrictParentOfType$iv, KtNamedFunction.class, true);
        boolean bl = ktNamedFunction != null ? MethodSignatureKt.isMainFunction(ktNamedFunction) : false;
        if (bl) {
            return;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(expression2, this.getBindingContext());
        if (resolvedCall2 == null || (resolvedCall2 = resolvedCall2.getResultingDescriptor()) == null || (resolvedCall2 = DescriptorUtilsKt.fqNameOrNull((DeclarationDescriptor)((Object)resolvedCall2))) == null) {
            return;
        }
        ResolvedCall<? extends CallableDescriptor> fqName = resolvedCall2;
        if (exitCalls.contains(((FqName)((Object)fqName)).asString())) {
            this.report(new CodeSmell(this.getIssue(), Entity.Companion.from$default(Entity.Companion, expression2, 0, 2, null), this.getIssue().getDescription(), null, null, 24, null));
        }
    }

    public ExitOutsideMain() {
        this((Config)null, 1, (DefaultConstructorMarker)null);
    }

    static {
        String[] stringArray = new String[]{"kotlin.system.exitProcess", "java.lang.System.exit", "java.lang.Runtime.exit", "java.lang.Runtime.halt"};
        exitCalls = SetsKt.setOf(stringArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lio/gitlab/arturbosch/detekt/rules/bugs/ExitOutsideMain$Companion;", "", "<init>", "()V", "exitCalls", "", "", "getExitCalls", "()Ljava/util/Set;", "detekt-rules-errorprone"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<String> getExitCalls() {
            return exitCalls;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

